/***************************************************************************
    file	         : kb_qrytable.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	 _KB_QRYTABLE_H
#define	 _KB_QRYTABLE_H


#include "libkbase_exports.h"

#include "kb_qrydata.h"
#include "kb_attrserver.h"



/*  KBQryTable								*/
/*  -----------								*/
/*  Class used for data queries which retrieve data directly from a	*/
/*  table.								*/

class	LIBKBASE_API	KBQryTable : public KBQryData
{
	Q_OBJECT

	KBAttrServer	m_server	;
	KBAttrStr	m_table		;
	KBAttrStr	m_primary	;
	KBAttrInt	m_ptype		;	/* Primary mode		*/
	KBAttrStr	m_pexpr		;	/* Primary expression	*/
	KBAttrStr	m_where		;
	KBAttrStr	m_order		;
	KBAttrBool	m_distinct	;
	KBAttrUInt	m_limit		;	/* Retrieve limit	*/

	KBTable		*m_tabPtr	;

protected :

	virtual	bool		loadQuery	() ;

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg	() ;
#endif

public	:

	KBQryTable	(KBNode *, const QDict<QString> &, bool * = 0) ;
	KBQryTable	(KBNode *, KBQryTable *) ;
	KBQryTable	(KBNode *) ;

virtual~KBQryTable	() ;

	virtual	KBQryTable 	*isQryTable  () { return this ; }

	virtual	void		showAs   	(KB::ShowAs)	;
	virtual	KBNode		*replicate	(KBNode *)	;
	virtual	void		printNode	(QString &, int);
	virtual	QString		getComment	(uint)		;
}	;

#endif	// _KB_QRYTABLE_H
