/***************************************************************************
    file	         : kb_qtmemo.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_QTMEMO_H
#define	_KB_QTMEMO_H


#include	"kb_ctrl.h"

#include	"tktextmanager.h"
#include	"tktexteditor.h"

#include	"tkc_tkemapper.h"

#include	"libkbase_exports.h"

class		KBMemo		;
class		KBCtrlMemo	;

#define	NOCHANGE(s)	\
	{	inSetValue = true  ;	\
		s ;			\
		inSetValue = false ;	\
	}

/*  ------------------------------------------------------------------  */

/*  KBCtrlMemo								*/
/*  ----------								*/
/*  Wrapper class for memi edit control					*/

class	LIBKBASE_API	KBCtrlMemo : public TKTextEditor, public KBControl
{
	Q_OBJECT

	KBMemo			*memo		;
	KBValue			iniVal		;
	TKTextEditorManager	*manager	;
	TKCTKEMapper		mapper		;

	bool			modified	;
	bool			inSetValue	;
	QString			curHilite	;

	void			setHilite	()	;

protected slots :

        virtual void    	giveFocus	() 	;
	void			editChanged	(int)	;
	virtual	bool		eventFilter	(QObject *, QEvent *) ;

public	:

		KBCtrlMemo	(KBDisplay *, KBMemo *, uint) ;
	virtual~KBCtrlMemo	() ;

	virtual	void		showName	()	;
	virtual	void		redraw		()	;
	virtual	void		setPalette	(const QPalette *)	;
	virtual	void		setFont		(const QFont    *)	;
	virtual	void		showAs		(KB::ShowAs) ;
	virtual	void		setValue	(const KBValue &) ;
	virtual	KBValue		getValue	()	;
	virtual	void		clearValue	(bool)	;
	virtual	bool		changed		()	;
	virtual	bool		isEmpty		()	;
	virtual	bool		isValid		(bool)	;
	virtual	bool		write		(KBWriter *, QRect, const KBValue &, bool, int &) ;

	virtual	bool		viewSetFocusOK	()	;

	virtual	QWidget		*mainWidget	()	;

	SETFOCUS
	SIZEHINT
}	;


#endif	// _KB_QTMEMO_H
