/***************************************************************************
    file	         : kb_attrmargindlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#include	<qlabel.h>
#include	<qspinbox.h>
#include	<qlayout.h>

#ifndef		_WIN32
#include	"kb_attrmargindlg.moc"
#else
#include	"kb_attrmargindlg.h"
#endif

#include	"kb_attrmargin.h"



/*  KBAttrMarginItem							*/
/*  KBAttrMarginItem							*/
/*		: Constructor for report margins for property dialog	*/
/*  attrMargin	: KBAttrMargin *   : Parent attribute			*/
/*  (returns)	: KBAttrMarginItem :					*/

KBAttrMarginItem::KBAttrMarginItem
	(	KBAttrMargin	*attrMargin
	)
	:
	KBAttrItem	(attrMargin),
	m_attrMargin	(attrMargin)
{
	m_lMargin	= m_attrMargin->m_lMargin ;
	m_rMargin	= m_attrMargin->m_rMargin ;
	m_tMargin	= m_attrMargin->m_tMargin ;
	m_bMargin	= m_attrMargin->m_bMargin ;
}

/*  KBAttrMarginItem							*/
/* ~ KBAttrMarginItem							*/
/*		: Destructor for report margins for property dialog	*/
/*  (returns)	:		:					*/

KBAttrMarginItem::~KBAttrMarginItem ()
{
}

/*  KBAttrMarginItem							*/
/*  getAttrDlg	: Get dialog for editing margin settings		*/
/*  parent	: QWidget *	      : Parent widget			*/
/*  attrDict	: QDict<KBAttrItem> & : Dictionary or other attributes	*/
/*  (returns)	: KBAttrDlg *	      :					*/

KBAttrDlg
	*KBAttrMarginItem::getAttrDlg
	(	QWidget			*parent,
		QDict<KBAttrItem>	&attrDict
	)
{
	return	new KBAttrMarginDlg (parent, m_attrMargin, this, attrDict) ;
}

/*  KBAttrMarginItem							*/
/*  clear	: Clear values						*/
/*  (returns)	: void		:					*/

void	KBAttrMarginItem::clear ()
{
	m_lMargin = 0 ;
	m_rMargin = 0 ;
	m_tMargin = 0 ;
	m_bMargin = 0 ;
}

/*  KBAttrMarginItem							*/
/*  save	: Save values back to attribute				*/
/*  (returns)	: void		:					*/

void	KBAttrMarginItem::save ()
{
	m_attrMargin->m_lMargin = m_lMargin ;
	m_attrMargin->m_rMargin = m_rMargin ;
	m_attrMargin->m_tMargin = m_tMargin ;
	m_attrMargin->m_bMargin = m_bMargin ;
}

/*  KBAttrMarginItem							*/
/*  displayValuue: Get text for display in preorty dialog		*/
/*  (returns)	 : QString	:					*/

QString	KBAttrMarginItem::displayValue ()
{
	return	QString ("%1,%3,%3,%4")
			.arg(m_lMargin)
			.arg(m_rMargin)
			.arg(m_tMargin)
			.arg(m_bMargin)
			;
}

/*  ------------------------------------------------------------------	*/

/*  KBAttrMarginDlg							*/
/*  KBAttrMarginDlg							*/
/*		: Constructor for margin dialog				*/
/*  parent	: QWidget *		: Parent widget			*/
/*  attr	: KBAttrMargin *	: Associated attribute		*/
/*  item	: KBAttrMarginItem *	: Associated item		*/
/*  attrDict	: QDict<KBAttrItem> &	: Attribute dictionary		*/
/*  (returns)	: KBAttrMarginDlg		:				*/

KBAttrMarginDlg::KBAttrMarginDlg
	(	QWidget			*parent,
		KBAttrMargin		*attr,
		KBAttrMarginItem	*item,
		QDict<KBAttrItem>	&attrDict
	)
	:
	KBAttrDlg	(parent, attr, item, attrDict),
	m_attrItem	(item)
{
	QHBoxLayout	*layTop	 = new QHBoxLayout (this  ) ;
	QGridLayout	*layGrid = new QGridLayout (layTop) ;

	QLabel *l0 = new QLabel	(TR("Left margin"  ), this) ;
	m_lMargin	= new QSpinBox (0, 1000, 1, this) ;
	m_lMargin->setFixedWidth (100) ;
	layGrid  ->addWidget     (l0,	     0, 0) ;
	layGrid  ->addWidget     (m_lMargin, 0, 1) ;

	QLabel *l1 = new QLabel	(TR("Right margin" ), this) ;
	m_rMargin	= new QSpinBox (0, 1000, 1, this) ;
	m_rMargin->setFixedWidth (100) ;
	layGrid  ->addWidget     (l1,	     1, 0) ;
	layGrid  ->addWidget     (m_rMargin, 1, 1) ;

	QLabel *l2 = new QLabel	(TR("Top margin"   ), this) ;
	m_tMargin	= new QSpinBox (0, 1000, 1, this) ;
	m_tMargin->setFixedWidth (100) ;
	layGrid  ->addWidget     (l2,	     2, 0) ;
	layGrid  ->addWidget     (m_tMargin, 2, 1) ;

	QLabel *l3 = new QLabel	(TR("Bottom margin"), this) ;
	m_bMargin	= new QSpinBox (0, 1000, 1, this) ;
	m_bMargin->setFixedWidth (100) ;
	layGrid  ->addWidget     (l3,	     3, 0) ;
	layGrid  ->addWidget     (m_bMargin, 3, 1) ;

	layGrid  ->setRowStretch (4, 1) ;
	layGrid  ->setColStretch (2, 1) ;
}

/*  KBAttrMarginDlg							*/
/*  value	: Get value						*/
/*  (returns)	: QString	: Value					*/

QString	KBAttrMarginDlg::value ()
{
	return	QString("") ;
}

/*  KBAttrMarginDlg							*/
/*  init	: Initialise for editing				*/
/*  value	: const QString & : Value				*/
/*  (returns)	: bool		  : Always false, no modal dialog	*/

bool	KBAttrMarginDlg::init
	(	const QString	&
	)
{
	return	false	;
}

/*  KBAttrMarginDlg							*/
/*  init	: Initialise for editing				*/
/*  (returns)	: bool		: True if modal dialog executed		*/

bool	KBAttrMarginDlg::init()
{
	m_lMargin->setValue (m_attrItem->m_lMargin) ;
	m_rMargin->setValue (m_attrItem->m_rMargin) ;
	m_tMargin->setValue (m_attrItem->m_tMargin) ;
	m_bMargin->setValue (m_attrItem->m_bMargin) ;
	return	false	;
}

/*  KBAttrMarginDlg							*/
/*  save	: Save values back to associated attribute item		*/
/*  (returns)	: bool		: True if modal dialog executed		*/

void	KBAttrMarginDlg::save ()
{
	m_attrItem->m_lMargin	= m_lMargin->value() ;
	m_attrItem->m_rMargin	= m_rMargin->value() ;
	m_attrItem->m_tMargin	= m_tMargin->value() ;
	m_attrItem->m_bMargin	= m_bMargin->value() ;
}
