/***************************************************************************
    file	         : kb_qryexpr.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_node.h"
#include	"kb_qryexpr.h"
#include	"kb_nodereg.h"


/*  KBQryExpr								*/
/*  KBQryExpr	: Constructor for query expression object		*/
/*  parent	: KBNode *	   : Parent node			*/
/*  aList	: QDict<QString> & : Attribute dictionary		*/
/*		: bool *	   :					*/
/*  (returns)	: KBQryExpr	   :					*/

KBQryExpr::KBQryExpr
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*
	)
	:
	KBNode	(parent, "KBQryExpr"),
	expr	(this,	 "expr",	aList),
	alias	(this,	 "alias",	aList),
	usage	(this,	 "usage",	aList)
{
}

/*  KBQryExpr								*/
/*  KBQryExpr	: Constructor for query expression object		*/
/*  _expr	: const QString & : Expression				*/
/*  _alias	: const QString & : As alias				*/
/*  _usage	: Usage		  : Use of expression			*/
/*  (returns)	: KBQryExpr	  :					*/

KBQryExpr::KBQryExpr
	(	KBNode		*parent,
		const QString	&_expr,
		const QString	&_alias,
		Usage		_usage
	)
	:
	KBNode	(parent, "KBQryExpr"),
	expr	(this,	 "expr",	_expr ),
	alias	(this,	 "alias",	_alias),
	usage	(this,	 "usage",	_usage)
{
}

/*  KBQryExpr								*/
/*  KBQryExpr	: Constructor for query expression object		*/
/*  parent	: KBNode *	: Parent node				*/
/*  _qryexpr	: KBQryExpr *	: Query expression to be replicated	*/
/*  (returns)	: KBQryExpr	:					*/

KBQryExpr::KBQryExpr
	(	KBNode		*parent,
		KBQryExpr	*_qryexpr
	)
	:
	KBNode	(parent, "KBQryExpr"),
	expr	(this,	 "ident",	_qryexpr),
	alias	(this,	 "alias",	_qryexpr),
	usage	(this,	 "name",	_qryexpr)
{
}

/*  KBQryExpr								*/
/*  ~KBQryExpr	: Destructor for query expression object		*/
/*  (returns)	:		:					*/

KBQryExpr::~KBQryExpr ()
{
}

/*  KBQryExpr								*/
/*  getSQL	: Get SQL expression text				*/
/*  (returns)	: QString	: Text					*/

QString	KBQryExpr::getSQL()
{
	if (!alias.getValue().isEmpty())
		return	QString("%1 as %2").arg(expr .getValue())
					   .arg(alias.getValue()) ;

	return	expr.getValue() ;
}

NEWNODE	(QryExpr, (cchar *)0, KF_QUERY)
