/***************************************************************************
    file	         : kb_qrylevel.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	 _KB_QRYLEVEL_H
#define	 _KB_QRYLEVEL_H


#include	<qptrdict.h>
#include	<qlist.h>

#include	"kb_classes.h"
#include	"kb_select.h"
#include	"kb_qrybase.h"
#include	"kb_table.h"

#include	"tk_progress.h"

#include	"libkbase_exports.h"



/*  KBQryLevelSet							*/
/*  -------------							*/
/*  This class is used in conjunction with the KBQuerySet class to	*/
/*  handle table updates when the query set contains fields from more	*/
/*  than one table (ie., the query set results from a Rekall-level	*/
/*  query) One KBQryLevelSet object will be created for each table, and	*/
/*  contains the information needed to access the required columns in	*/
/*  the query set.							*/

class	LIBKBASE_API	KBQryLevelSet
{
	KBDBLink	&m_dbLink	;	/* Link to database	*/
	KBTable		*m_table	;	/* Associated table	*/

	QList<KBItem>	m_items		;	/* Updateable items	*/

	KBItem		*m_uniqueItem	;	/* Unique key item	*/
	int		m_uniqueCol	;	/* Query unique column	*/
	QString		m_uniqueExpr	;	/* Retrieval expression	*/
	KBTable::UniqueType
			m_uniqueType	;

	uint		m_permission	;	/* Insert, etc, allowed	*/

	KBSQLInsert	*m_qryInsert	;	/* Insert new row	*/
	KBSQLSelect	*m_qryNewkey	;
	KBSQLUpdate	*m_qryUpdate	;	/* Update a row		*/
	KBValue		*m_values	;	/* For use in queries	*/
	bool		m_updated	;	/* Was updated		*/

	bool		uniqueDisplayed	(const QString &, bool, const QString &) ;
	KBValue		getNewKey	() ;

public	:

	KBQryLevelSet		(KBDBLink &, KBTable *)	;
	~KBQryLevelSet		()		;

	void	addItem		(KBItem  *, const QString &) ;

	KBValue	keyFromExpr	(KBError &, const QString &) ;
	bool	doUpdate	(KBQuerySet *, uint, KBValue &, KBError &) ; 
	bool	doInsert	(KBQuerySet *, uint, KBValue *, const QString &, KBValue &, KBError &) ; 

	int	findPermissions	(QString &, KBError &) ;

	inline	void	setUniqueCol
		(	int	uniqueCol
		)
	{
		m_uniqueCol = uniqueCol ;
	}

	inline	int	getUniqueCol ()
	{
		return	m_uniqueCol ;
	}

	inline	KBTable	*getTable ()
	{
		return	m_table	;
	}

	inline	bool	updated	()
	{
		return	m_updated ;
	}
}	;



/*  KBQryLevel								*/
/*  ----------								*/
/*  Class used to store information about one level in a multi-level	*/
/*  query.								*/

class	LIBKBASE_API	KBQryLevel
{
	enum	InsertRC
	{
		OK		= 1,
		Cancel		= 2,
		Limit		= 3
	}	;

	KBNode		*m_parent	;	/* Parent node		*/
	KBQryLevel	*m_next		;	/* Next level down	*/
	KBDBLink	&m_dbLink	;	/* Common server link	*/
	uint		m_qryLvl	;	/* Query level number	*/

	bool		m_distinct	;
	QString		m_glbWhere	;
	QString		m_glbOrder	;
	QString		m_glbGroup	;
	QString		m_glbHaving	;
	uint		m_limit		;

	KBTable		*m_table	;	/* Associated table	*/
	KBTable		*m_topTable	;	/* Update top table	*/

	QList<KBFieldSpec>
			m_fldList	;	/* Slaved field list	*/

	QList<KBItem>	m_allItems	;	/* All items at level	*/
	QList<KBItem>	m_getItems	;	/* Items from query	*/
	QList<KBItem>	m_updItems	;	/* Database updating	*/

	QPtrDict<KBQryLevelSet>
			m_levelSets	;
	KBQryLevelSet	*m_topLevelSet	;

						/* Query cache ...	*/
	KBSQLSelect	*m_qryFetch	;	/* Fetch back changes	*/
	KBSQLSelect	*m_qryForUpdate	;	/* Fetch for update	*/
	KBSQLDelete	*m_qryDelete	;	/* Delete a row		*/

	KBQuerySet	*m_querySet	;	/* Associated query set	*/

	KBQryBase::Locking
			m_locking	;	/* Update locking	*/

	uint		m_permission	;	/* Insert, etc, allowed	*/
	QString		m_reason	;	/* Reason for above	*/

	KBSQLSelect	*makeFetchSelect(bool) ;

	QString		getNextToken	(const QString &, uint &) ;
	KBQryLevel	*findLevel	(KBItem   *, const QString &, KBTable *&) ;
	KBQryLevel	*rowConstant	(KBItem   *, const QString &, const QString &, KBTable *&) ;
	KBQryLevel	*rowConstant	(KBItem   *, const QStringList &, const QStringList &, KBTable *&) ;
	void		placeItem	(KBItem   *) ;

	bool		findPermissions	(KBError  &) ;
	void		checkUpdate	(uint, uint) ;
	InsertRC	insertRows	(KBSQLSelect *, KBQuerySet *, uint, uint, uint, uint, TKProgress *) ;
	bool		updateRow	(KBSQLSelect *, uint) ;

	void		buildSelect	(KBSelect &, bool, bool) ;
	void		addQueryTerms	(KBSelect &, KBValue *, uint, uint &) ;

	bool		getUpdates	(KBSQLSelect *, uint, bool, bool &, KBError &) ;
	bool		getUpdates	(uint, bool, bool &, KBError &) ;

	bool		verifyChange	(const QString &, KBError &) ;

	bool		doUpdate	(uint, KBValue *, const QString &, KBBlock *, KBValue &, KBError &) ;
	bool		doInsert	(uint, KBValue *, const QString &, KBBlock *, KBValue &, KBError &) ;
	bool		doDelete	(uint, KBValue &, KBError &) ;


public	:

	KBQryLevel	(KBNode *, KBQryLevel *, KBDBLink &, uint) ;
	KBQryLevel	(KBNode *, KBQryLevel *, KBDBLink &, uint, KBTable * = 0, KBTable * = 0) ;
       ~KBQryLevel	()		;

	void		clear		()			;
	bool		addItem		(KBItem *)		;
	void		remItem		(KBItem *)		;
	bool		loadItems	(uint)			;
	bool		clearItems    	(uint)			;
	void		resetData	(uint)			;
	void		markGroups	(const QStringList &)	;

	void		setRowState	(uint, KB::RState)	;
	KB::RState	getRowState	(uint)			;
	bool		rowIsDirty	(uint, bool)		;

	void		insertRow	(uint)			;
	uint		getNumRows 	()			;
	uint		setCurrentRow	(uint)			;
	void		setQuerySet	(KBQuerySet *)		;

	const KBValue	&getField	(uint, uint, bool  = false  ) ;
	void		setField	(uint, uint, const KBValue &) ;
	bool		newRowEmpty	(uint)			;

	bool		startUpdate	(uint, KBQryBase::Locking, KBError &)	;
	bool		endUpdate	(bool, KBError &)	;

	bool		saveRow		(uint, KBError &)	;

	bool		getSelect	(KBSelect &)		;

	bool		syncRow		(uint, KBValue *, const QString &, KBBlock *, KBError &, KB::Action &, KBValue &) ;
	bool		syncAll		(      KBValue *, const QString &, KBBlock *, KBError &) ;
	bool		doSelect	(KBValue *, const QString &, const QString &, const QString &, bool, uint, KBError &) ;

	void		sortByColumn	(uint, bool, KBItem *)	;

	bool		getFieldList	(QList<KBFieldSpec> &, int &, bool, KBError &) ;
	void		setRowMarked	(uint, KB::MarkOp) 	;
	bool		getRowMarked	(uint) 			;
	bool		deleteAllMarked	(uint &, KBError &)	;

	uint		getWidth	(uint)			;

	QString		getSQLText	(bool)			;
	QString		getSQLReason	()			;

	inline	void	setGlobalWhere
		(	const QString	&where
		)
	{
		m_glbWhere = where ;
	}
	inline	void	setGlobalOrder
		(	const QString	&order
		)
	{
		m_glbOrder = order ;
	}
	inline	void	setGlobalGroup
		(	const QString	&group
		)
	{
		m_glbGroup = group ;
	}
	inline	void	setGlobalHaving
		(	const QString	&having
		)
	{
		m_glbHaving= having;
	}
	inline	void	setDistinct
		(	bool		distinct
		)
	{
		m_distinct = distinct ;
	}
	inline	void	setLimit
		(	uint	limit
		)
	{
		m_limit	= limit	;
	}
	inline	uint	getPermission ()
	{
		return	m_permission ;
	}

	inline	KBQryBase::Locking lockingState ()
	{
		return	m_locking	;
	}
}	;

#endif	// _KB_QRYLEVEL_H
