/***************************************************************************
    file	         : kb_qryquerydlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_QRYQUERYDLG_H
#define	_KB_QRYQUERYDLG_H

#if	! __KB_RUNTIME

#include	<qapplication.h>
#include	<qdialog.h>
#include	<qmultilinedit.h>

#include	"kb_classes.h"
#include	"kb_node.h"
#include	"kb_propdlg.h"

#include	"libkbase_exports.h"

/*  KBQryQueryPropDlg							*/
/*  -----------------							*/
/*  Wrapper class for query-query properties dialog. Handles special-	*/
/*  case properties.							*/

class LIBKBASE_API	KBQryQueryPropDlg : public KBPropDlg
{
	Q_OBJECT

	KBQryQuery		*query		;
	QList<QString>		idmap		;
	KBResizeWidget		topTableWidget	;
	QComboBox		topTableCombo	;

	KBQuery			*qryRoot	;
	QList<KBTable>		qryList		;
	QList<QLabel>		blockUp		;

	void		setBlockSizes	()	;
	bool		loadQueryList	(const QString &, const QString &, KBError &) ;

private slots :

	void		topTableResize	(KBResizeWidget *, QSize) ;
	void		showBlockUp	(int)	;

protected :

	virtual KBAttrItem
			*getAttrItem	(KBAttr     *) ;
	virtual	bool	showProperty	(KBAttrItem *) ;
	virtual	bool	saveProperty	(KBAttrItem *) ;

	virtual	bool	playerPerform	(const QString &, const QStringList &, KBError &) ;

public	:

	KBQryQueryPropDlg (KBQryQuery *, cchar *, QList<KBAttr> &) ;
       ~KBQryQueryPropDlg () ;

	QString		nameForIdent	(const QString &) ;
}	;

extern	LIBKBASE_API	bool	qryQueryPropDlg
			(	KBQryQuery	*,
				cchar		*,
				QList<KBAttr>	&
			)	;

#endif
#endif	// _KB_QRYQUERYDLG_H
