/***************************************************************************
    file	         : kb_querychooser.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdlib.h>


#ifndef 	_WIN32
#include 	"kb_querychooser.moc"
#else
#include 	"kb_querychooser.h"
#endif

#include	"kb_serverinfo.h"
#include	"kb_dbdociter.h"


/*  KBQueryChooser							*/
/*  KBQueryChooser							*/
/*		: Constructor for query chooser				*/
/*  location	: KBLocation &	 : Database location			*/
/*  cbServer	: QComboBox &	 : Server selector			*/
/*  cbQuery	: QComboBox &	 : Query selector			*/
/*  (returns)	: KBQueryChooser :					*/

KBQueryChooser::KBQueryChooser
	(	KBLocation	&location,
		QComboBox	&cbServer,
		QComboBox	&cbQuery
	)
	:
	location (location),
	cbServer (cbServer),
	cbQuery  (cbQuery)
{
	if (!location.dbInfo->findServer(KBLocation::m_pFile)->dbType().isEmpty())
		cbServer.insertItem (KBLocation::m_pFile) ;

	QListIterator<KBServerInfo> *svIter = location.dbInfo->getServerIter () ;
	KBServerInfo		    *svInfo ;

	while ((svInfo = svIter->current()) != 0)
	{
		cbServer.insertItem (svInfo->serverName()) ;
		(*svIter) += 1 ;
	}

	delete	svIter	;

	connect	(&cbServer, SIGNAL(activated     (const QString &)),
		 this,	    SLOT  (serverSelected(const QString &))) ;
	connect	(&cbQuery,  SIGNAL(activated     (const QString &)),
		 this,	    SLOT  (querySelected (const QString &))) ;

	serverSelected (cbServer.text(0)) ;
}

/*  KBQueryChooser							*/
/*  serverSelected							*/
/*		: User selects a database server			*/
/*  svName	: const QString & : Server name				*/
/*  (returns)	: void		  :					*/

void	KBQueryChooser::serverSelected
	(	const QString	&svName
	)
{
	cbQuery .clear	()	;
	emit	serverChanged()	;

	if (svName == "")
		return	;

	KBError		error	;
	KBDBDocIter	docIter	;
	if (!docIter.init
		(	location.dbInfo,
			svName,
			"query",
			"qry",
			error,
			false
	   ))
	{
		error.DISPLAY() ;
		return	;
	}

	QString	name	;
	QString	stamp	;

	cbQuery.insertItem ("") ;

	while (docIter.getNextDoc (name, stamp))
	{
		cbQuery.insertItem (name) ;
	}

	emit	serverChanged	() ;
}

/*  KBQueryChooser							*/
/*  querySelected							*/
/*		: User selects a table					*/
/*  qryName	: const QString & : Query name				*/
/*  (returns)	: void		  :					*/

void	KBQueryChooser::querySelected
	(	const QString	&
	)
{
	emit	queryChanged	() ;
}

/*  KBQueryChooser							*/
/*  setServer	: Set specifier server					*/
/*  svrName	: const QString & : Server name				*/
/*  (returns)	: bool		  : Server name valid			*/

bool	KBQueryChooser::setServer
	(	const QString	&svrName
	)
{
	bool	rc	= false ;

	cbServer.setCurrentItem (0) ;

	for (int idx = 0 ; idx < cbServer.count() ; idx += 1)
		if (cbServer.text(idx) == svrName)
		{	cbServer.setCurrentItem (idx) ;
			serverSelected		(svrName) ;
			rc	= true	;
			break	;
		}

	emit serverChanged () ;
	return	rc ;
}

/*  KBQueryChooser							*/
/*  setQuery	: Set specifier query					*/
/*  qryName	: const QString & : Query name				*/
/*  (returns)	: bool		  : Query name valid			*/

bool	KBQueryChooser::setQuery
	(	const QString	&qryName
	)
{
	bool	rc	= false ;

	cbQuery.setCurrentItem (0) ;

	for (int idx = 0 ; idx < cbQuery.count() ; idx += 1)
		if (cbQuery.text(idx) == qryName)
		{	cbQuery.setCurrentItem	(idx) ;
			querySelected		(qryName) ;
			rc	= true	;
			break	;
		}

	emit queryChanged () ;
	return	rc ;
}


/*  ------------------------------------------------------------------ */

/*  KBQueryChooserDlg							*/
/*  KBQueryChooserDlg							*/
/*		: Simple server/query selection dialog			*/
/*  location	: KBLocation &	    : Database location			*/
/*  (returns)	: KBQueryChooserDlg :					*/

KBQueryChooserDlg::KBQueryChooserDlg
	(	KBLocation	&location
	)
	:
	_KBDialog("Pick server and query", true),
	location (location),
	cbServer (this),
	cbQuery  (this),
	lServer  (this),
	lQuery   (this),
	chooser	 (location, cbServer, cbQuery),
	bOK	 (this),
	bCancel	 (this)
{
	layMain	  = new QGridLayout(this) ;
	layMain->addWidget (&lServer,  0, 0) ;
	layMain->addWidget (&cbServer, 0, 1) ;
	layMain->addWidget (&lQuery,   1, 0) ;
	layMain->addWidget (&cbQuery,  1, 1) ;
	layMain->addWidget (&bCancel,  2, 0) ;
	layMain->addWidget (&bOK,      2, 1) ;

	layMain->setMargin (8) ;
	layMain->setSpacing(4) ;

	lServer.setText (TR("Server")) ;
	lQuery .setText (TR("Query" )) ;
	bCancel.setText (TR("Cancel")) ;
	bOK    .setText (TR("OK"    )) ;

	connect	 (&bOK,     SIGNAL(clicked()), this, SLOT(clickOK    ())) ;
	connect	 (&bCancel, SIGNAL(clicked()), this, SLOT(clickCancel())) ;
	connect  (&chooser, SIGNAL(changed()), this, SLOT(changed    ())) ;

	bOK.setEnabled  (false) ;
}

/*  KBQueryChooserDlg							*/
/*  changed	: Selection changed					*/
/*  (returns)	: void		:					*/

void	KBQueryChooserDlg::changed ()
{
	bOK.setEnabled (!cbServer.currentText().isEmpty() &&
			!cbQuery .currentText().isEmpty()) ;
}

/*  KBQueryChooserDlg							*/
/*  clickOK	: User clicks OK					*/
/*  (returns)	: void		:					*/

void	KBQueryChooserDlg::clickOK ()
{
	done	(true)  ;
}

/*  KBQueryChooserDlg							*/
/*  clickCancel	: User clicks cancel					*/
/*  (returns)	: void		:					*/

void	KBQueryChooserDlg::clickCancel ()
{
	done	(false) ;
}
