/***************************************************************************
    file	         : tk_helpproxy.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#ifndef 	_WIN32
#include	<unistd.h>
#include	<sys/socket.h>
#include	<sys/wait.h>
#endif

#include	<errno.h>
#include	<sys/types.h>

#include	<qapplication.h>
#include	<qtextbrowser.h>
#include	<qguardedptr.h>

#if		__KB_KDE
#include	<klocale.h>
#include	<kglobal.h>
#include	<kstddirs.h>
#include	<kinstance.h>
#endif

#include	"kb_classes.h"

#ifndef 	_WIN32
#include	"tk_helpproxy.moc"
#else
#include 	"tk_helpproxy.h"
#endif

extern	QString locateFile(const char *, const QString &) ;
extern	QString locateDir (const char *, const QString &) ;


#if	__KB_KDE

/*  TKHelpProxy								*/
/*  TKHelpProxy	: Constructor for help display proxy			*/
/*  (returns)	: TKHelpProxy	:					*/

TKHelpProxy::TKHelpProxy ()
{
	connect
	(	&process,
		SIGNAL	(processExited(KProcess *)),
		SLOT	(processExited(KProcess *))
	)	;

	helpDir	= locateDir ("appdata", "help/")   ;
	if (!helpDir.isEmpty()) helpDir += "help/" ;

	process	<< "rekallHelp"	;
	process	<< helpDir	;

	fprintf	(stderr, "TKHelpProxy: dir [%s]\n", (cchar *)helpDir) ;
}


/*  TKHelpProxy								*/
/*  helpPageExists							*/
/*		: See if a help page exists				*/
/*  tag		: const QString & : Help tag				*/
/*  (returns)	: bool		  : True if page exists			*/

bool	TKHelpProxy::helpPageExists
	(	const QString	&tag
	)
{
//	fprintf	(stderr, "helpPageExists(%s)\n", (const char *)tag) ;
	return	!locateFile("appdata", QString("help/%1.qt").arg(tag)).isEmpty() ;
}

/*  TKHelpProxy								*/
/*  showHelpPage: Show a help page					*/
/*  tag		: const QString & : Help tag				*/
/*  (returns)	: void		  :					*/

void	TKHelpProxy::showHelpPage
	(	const QString	&tag
	)
{
	/* If the help display process is not running then start it.	*/
	/* We don't really need to know if it exits, but its useful for	*/
	/* debugging.							*/
	if (!process.isRunning())
		if (!process.start (KProcess::NotifyOnExit, KProcess::Stdin))
		{
			fprintf	(stderr, "TKHelpProxy::showHelpPage: process started failed\n") ;
			return	;
		}


	/* Locate the help file. If it cannot be found then generate an	*/
	/* error which will display in the help window. The display	*/
	/* will interpret a string begining with "<" as text rather	*/
	/* than as a file name. This is sent to the display process	*/
	/* along with the tag and the legend.				*/
	QString	help	= locateFile ("appdata", QString("help/%1.qt").arg(tag)) ;
	QString	page	;

	if (help.isEmpty())
		page	= QString ("<qt>No help found (Tag <i>%2</i>)</qt>")
				.arg(tag) ;
	else	page	= tag	;

	TKHelpRequest	req	;
	strncpy	(req.page,   (const char *)page,   sizeof(req.page  )) ;

	if (!process.writeStdin ((const char *)&req, sizeof(req)))
	{
		fprintf	(stderr, "Help window write failed\n") ;
		return	;
	}

//	fprintf
//	(	stderr,
//		"Help window wrote \"%s\"\n",
//		(const char *)req.page
//	)	;
}

/*  TKHelpProxy								*/
/*  processExited: Display process exit handler				*/
/*  p		 : KProcess *	: The process:)				*/
/*  (returns)	 : void		:					*/

void	TKHelpProxy::processExited
	(	KProcess	*
	)
{
//	if (p->normalExit())
//		fprintf	(stderr, "TKHelpProxy: process exited: %d\n",
//				 p->exitStatus()) ;
//	else	fprintf	(stderr, "TKHelpProxy: process died\n") ;
}

#endif	// __KB_KDE


#if	__KB_TKC

/*  TKHelpProxy								*/
/*  TKHelpProxy	: Constructor for help display proxy			*/
/*  (returns)	: TKHelpProxy	:					*/

TKHelpProxy::TKHelpProxy ()
{
}


/*  TKHelpProxy								*/
/*  helpPageExists							*/
/*		: See if a help page exists				*/
/*  tag		: const QString & : Help tag				*/
/*  (returns)	: bool		  : True if page exists			*/

bool	TKHelpProxy::helpPageExists
	(	const QString	&tag
	)
{
	return	!locateFile("appdata", QString("help/%1.qt").arg(tag)).isEmpty() ;
}

/*  TKHelpProxy								*/
/*  showHelpPage: Show a help page					*/
/*  tag		: const QString & : Help tag				*/
/*  (returns)	: void		  :					*/

void	TKHelpProxy::showHelpPage
	(	const QString	&
	)
{
}

/*  TKHelpProxy								*/
/*  processExited: Display process exit handler				*/
/*  p		 : KProcess *	: The process:)				*/
/*  (returns)	 : void		:					*/

void	TKHelpProxy::processExited
	(	KProcess	*
	)
{
}

#endif	// __KB_TKC

/*  TKHelpProxy								*/
/*  self	: Get the proxy						*/
/*  (returns)	: TKHelpProxy * : Proxy					*/

TKHelpProxy	*TKHelpProxy::self()
{
	/* Use this method to get the proxy, unless you really want	*/
	/* more than one instance.					*/
	static	TKHelpProxy *proxy ;
	if (proxy == 0) proxy = new TKHelpProxy() ;
	return	proxy	;
}

