/***************************************************************************
    file	         : tk_filedialog.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	"tk_filedialog.h"


/*  convertFilters							*/
/*		: Convert fron KDE to QT file dialog filter format	*/
/*  filters	: const QString & : KDE style filter specification	*/
/*  (returns)	: QString	  : QT style filter specification	*/

static	QString	convertFilters
	(	const QString	&filters
	)
{
	/* We do a conversion so that the main program can use KDE	*/
	/* format throughout, no need for coditional compilation.	*/
	QStringList kList = QStringList::split ("\n", filters) ;
	QString	    qList ;

	for (uint idx = 0 ; idx < kList.count () ; idx += 1)
	{
		QStringList kPair = QStringList::split ("|", kList[idx]) ;
		QString	    qPair = QString("%1 (%2)").arg(kPair[1]).arg(kPair[0]) ;

//		fprintf	(stderr, "[%s]->[%s]\n", (const char *)kList[idx], (const char *)qPair) ;
		if (!qList.isEmpty()) qList.append ('\n') ;
		qList.append (qPair) ;
	}

	return	qList	;
}

QString	KBFileDialog::getOpenFileName
	(	const QString	&startDir,
		const QString	&filters,
		QWidget		*parent,
		const QString	&caption
	)
{
	QFileDialog fDlg (parent, 0, true) ;

	fDlg.setFilters  (convertFilters(filters)) ;
	fDlg.setDir	 (startDir) ;

	if (caption.isNull())
		fDlg.setCaption ("Open" ) ;
	else	fDlg.setCaption (caption) ;

	fDlg.setMode (QFileDialog::ExistingFile) ;

	if (fDlg.exec() != QDialog::Accepted) return QString::null ;

	return	fDlg.selectedFile () ;
}

QString	KBFileDialog::getSaveFileName
	(	const QString	&startDir,
		const QString	&filters,
		QWidget		*parent,
		const QString	&caption
	)
{
	QFileDialog fDlg (parent, 0, true) ;

	fDlg.setFilters  (convertFilters(filters)) ;
	fDlg.setDir	 (startDir) ;

	if (caption.isNull())
		fDlg.setCaption ("Save as") ;
	else	fDlg.setCaption (caption)   ;

	fDlg.setMode (QFileDialog::AnyFile) ;

	if (fDlg.exec() != QDialog::Accepted) return QString::null ;

	return	fDlg.selectedFile () ;
}

QString	KBFileDialog::getExistingDirectory
	(	const QString	&startDir,
		const QString	&caption
	)
{
	return	QFileDialog::getExistingDirectory
		(	startDir,
			0,
			0,
			caption
		)	;
}


KBFileDialog::KBFileDialog
	(	const QString	&startDir,
		const QString	&filters,
		QWidget		*parent,
		const char	*name,
		bool		modal
	)
	:
	QFileDialog (parent, name, modal)
{
	setFilters  (convertFilters(filters)) ;
	setDir	    (startDir) ;
}

/*  KBFileDialog							*/
/*  currentFilter: Get currently selected filter			*/
/*  (returns)	 : QString	: Filter				*/

QString	KBFileDialog::currentFilter ()
{
	/* The filter returned by QT is processed to extract just the	*/
	/* part in brackets, which we assume is what is wanted.		*/
	QString	filter	= selectedFilter () ;
	int	bra	= filter.find ('(') ;
	int	ket	= filter.find (')') ;

	if ((bra >= 0) && (ket > bra))
		filter	= filter.mid (bra + 1, ket - bra - 1) ;
	else	filter	= QString::null ;

	return	filter	;
}

void	KBFileDialog::setMode
	(	KBFileDialog::KBMode	mode
	)
{
	switch (mode)
	{
		case KBFileDialog::Directory	:
			QFileDialog::setMode (QFileDialog::Directory	) ;
			break	;

		case KBFileDialog::ExistingFile :
			QFileDialog::setMode (QFileDialog::ExistingFile	) ;
			break	;

		case KBFileDialog::AnyFile	:
			QFileDialog::setMode (QFileDialog::AnyFile	) ;
			break	;

		case KBFileDialog::ExistingFiles:
			QFileDialog::setMode (QFileDialog::ExistingFiles) ;
			break	;

		default	:
			break	;
	}
}
