/***************************************************************************
    file	         : kb_filewidget.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_FILEWIDGET_H
#define	__KB_FILEWIDGET_H

#include	<qlayout.h>
#include	<qgroupbox.h>
#include	<qlabel.h>
#include	<qcombobox.h>
#include	<qlistbox.h>
#include	<qpushbutton.h>
#include	<qlabel.h>
#include	<qwidgetstack.h>
#include	<qspinbox.h>

#include	"kb_editlistview.h"
#include	"kb_copybase.h"
#include	"kb_copyfile.h"


/*  KBFileWidget							*/
/*  -------------							*/
/*  This is the copied widget which provides the user GUI interface to	*/
/*  the file copier object.						*/

class	KBFileWidget : public QWidget, public KBCopyFile
{
	Q_OBJECT

	QObject		*m_part		;

	bool		m_srce		;
	KBLocation	m_location	;

	QComboBox	m_cbFixedDelim	;
	QCheckBox	m_cbHeader	;
	QSpinBox	m_spHeader	;

	QWidgetStack	m_typeStack	;

	QGroupBox	m_gbDelim	;
	QGroupBox	m_gbFixed	;
	QGroupBox	m_gbFile	;

	QWidget		m_wDelim	;
	QWidget		m_wFixed	;
	QWidget		m_wFile		;

	QComboBox	m_cbDelim	;
	QComboBox	m_cbQualif	;
	QLineEdit	m_leCopyList	;

	KBEditListView	m_fixedCols	;
	QPushButton	m_bTable	;
	QPushButton	m_bSample	;

	QLineEdit	m_eFile		;
	QPushButton	m_bBrowse	;
	QComboBox	m_cbErrOpt	;

	void		saveall		() ;

signals	:

	void		changed		() ;

protected slots	:

	void		fixedSelected	(int) ;
	void		clickBrowse	() ;
	void		clickTable	() ;
	void		clickSample	() ;

public	:

	KBFileWidget	(QWidget *parent, QObject *, bool, KBLocation &) ;

	bool		valid		(KBError     &) ;
	void		def		(QDomElement &) ;
	bool		set		(QDomElement &, KBError &) ;
}	;

#endif	// __KB_FILEWIDGET_H
