/***************************************************************************
    file	         : kb_sqlwidget.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qdom.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_dialog.h"

#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_serverinfo.h"

#ifndef 	_WIN32
#include	"kb_sqlwidget.moc"
#else
#include 	"kb_sqlwidget.h"
#endif

/*  KBSQLWidget								*/
/*  KBSQLWidget	: Constructor for SQL copier widget			*/
/*  parent	: QWidget *	: Parent widget				*/
/*  part	: QObject *	: Parent copier part			*/
/*  srce	: bool		: Source, else error			*/
/*  location	: KBLocation &	: Database location			*/
/*  (returns)	: KBSQLWidget	:					*/

KBSQLWidget::KBSQLWidget
	(	QWidget		*parent,
		QObject		*part,
		bool		srce,
		KBLocation	&location
	)
	:
	QWidget		(parent),
	KBCopySQL	(srce, location),
	part		(part),
	srce		(srce),
	location	(location),
	cbServer	(this),
	mlSQL		(this)
{

	layMain	= new QVBoxLayout (this) ;

	layMain->addWidget (&cbServer) ;
	layMain->addWidget (&mlSQL   ) ;

	_KBDialog::setupLayout (layMain, -1, -1) ;


	KBServerInfo *self  = location.dbInfo->findServer (location.docLocn) ;
	if (!self ->dbType().isEmpty())
		cbServer.insertItem ("Self") ;

	KBServerInfo *files = location.dbInfo->findServer (KBLocation::m_pFile) ;
	if (!files->dbType().isEmpty())
		cbServer.insertItem (KBLocation::m_pFile) ;

	QListIterator<KBServerInfo> *svIter = location.dbInfo->getServerIter () ;
	KBServerInfo		    *svInfo ;

	while ((svInfo = svIter->current()) != 0)
	{
		cbServer.insertItem (svInfo->serverName()) ;
		(*svIter) += 1 ;
	}

	delete	svIter	;

	connect	(&cbServer, SIGNAL(activated  (int)), part, SLOT(setChanged())) ;
	connect	(&mlSQL,    SIGNAL(textChanged   ()), part, SLOT(setChanged())) ;
		

}

/*  KBSQLWidget								*/
/*  saveall	: Save all settings					*/
/*  (returns)	: void		:					*/

void	KBSQLWidget::saveall ()
{
	setServer (cbServer.currentText()) ;
	setSQL    (mlSQL.text()) ;
}

/*  KBSQLWidget								*/
/*  error	: KBError &	 : Error return				*/
/*  (returns)	: bool		 : Success				*/

bool	KBSQLWidget::valid
	(	KBError		&error
	)
{
	saveall () ;
	return	KBCopySQL::valid (error) ;
}

/*  KBSQLWidget								*/
/*  set		: Set copier from definition				*/
/*  copy	: QDomElement & : Definition parent			*/
/*  error	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBSQLWidget::set
	(	QDomElement	&copy,
		KBError		&error
	)
{
	if (!KBCopySQL::set (copy, error)) return false ;

	for (int idx = 0 ; idx < cbServer.count() ; idx += 1)
		if (cbServer.text(idx) == getServer())
		{	cbServer.setCurrentItem (idx) ;
			break	;
		}

	mlSQL.setText (getSQL()) ;
	return	true	;

}

/*  KBSQLWidget							*/
/*  def		: Get table copy definition				*/
/*  copy	: QDomElement &	: Element to which to attach		*/
/*  (returns)	: void		:					*/

void	KBSQLWidget::def
	(	QDomElement	&copy
	)
{
	saveall () ;
	return	KBCopySQL::def (copy) ;
}
