/***************************************************************************
    file	         : kb_formviewer.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qwidget.h>
#include	<qguardedptr.h>
#include	<qstatusbar.h>

#include	"tk_icons.h"
#include	"tk_messagebox.h"

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_gui.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_display.h"
#include	"kb_form.h"
#include	"kb_options.h"
#include	"kb_string.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"
#include	"kb_docroot.h"
#include	"kb_writer.h"
#include	"kb_viewer.h"

#ifndef 	_WIN32
#include	"kb_formviewer.moc"
#else
#include 	"kb_formviewer.h"
#include	<qapplication.h>
#endif

#include	"kb_objtreeviewer.h"



/*  KBFormViewer							*/
/*  KBFormViewer: Constructor for form viewer object for new form	*/
/*  KBObjBase	: QObject	   : Parent object			*/
/*  embed	: QWidget *	   : Embedding widget			*/
/*  pDict	: QDict<QString> & : Parameter dictionary		*/
/*  modal	: bool		   : Run form modally			*/
/*  (returns)	: KBFormViewer	   :					*/

KBFormViewer::KBFormViewer
	(	KBObjBase		*parent,
		QWidget			*embed,
		const QDict<QString>	&pDict,
		bool			modal
	)
	:
	KBViewer (parent, embed, WDestructiveClose|WStyle_NormalBorder, modal),
	KBPlayer ("formviewer", "", m_partWidget),
	m_pDict	 (pDict)
{
	m_showing	= KB::ShowAsUnknown ;
	m_docRoot	= 0	;
	m_executing	= false	;
	m_objTree	= 0	;
	m_statusBar	= m_partWidget->statusBar () ;

	if (m_statusBar != 0)
	{
		m_locking = new QLabel	(m_statusBar) ;
		m_statusBar->addWidget	(m_locking, 0, true) ;

		int	w1, w2 ;
		m_locking->setText	(TR("Record locked")) ;
		w1 = m_locking->sizeHint().width() ;
		m_locking->setText	(TR("Unlocked"	   )) ;
		w2 = m_locking->sizeHint().width() ;
		m_locking->setMinimumWidth (QMAX(w1,w2)) ;		
	}
	else	m_locking = 0 ;

	m_dataGUI   = new KBNavGUI (this, this, "rekallui.form.data"  ) ;
#if	! __KB_RUNTIME
	m_designGUI = new KBaseGUI (this, this, "rekallui.form.design") ;
#endif
}

/*  KBFormViewer							*/
/*  startup	: Startup form viewer object				*/
/*  docRoot	: KBForm *	: Form object				*/
/*  showAs	: KB::ShowAs	: Initial display mode			*/
/*  key		: const KBValue & : Parent key				*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: KB::ShowRC	: Startup success			*/

KB::ShowRC
	KBFormViewer::startup
	(	KBForm		*docRoot,
		KB::ShowAs	showAs,
		const KBValue	&key,
		KBError		&pError
	)
{
	KB::ShowRC	rc		;
	QSize		size		;
	KBaseGUI 	*gui		;

	m_docRoot	= docRoot	;
	m_showing	= showAs	;
	m_parentKey	= key		;

	/* Show the GUI in the expected state. This is needed to that	*/
	/* the initial call back to "focusAtRow" works correctly. If	*/
	/* the form does not come up as requested, the GUI will be	*/
	/* reset.							*/

	/* Show the document, either in design or data view. If the	*/
	/* user cancels (which should never happen for design view)	*/
	/* then immediately return a false result.			*/
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign)
	{
		setGUI		  (gui = m_designGUI) ;
		m_docRoot->setGUI (gui) ;
		rc	= m_docRoot->showDesign (m_partWidget, size) ;
	}
	else
#endif
	{
		m_dataGUI->setStatusBar (m_docRoot->hasStatusBar()) ;
		setGUI		  (gui = m_dataGUI) ;
		m_docRoot->setGUI (gui) ;
		rc	= m_docRoot->showData   (m_partWidget, m_pDict, m_parentKey, size) ;
	}


	switch (rc)
	{
		case KB::ShowRCCancel :
			/* User cancelled, return this at once to the	*/
			/* caller.					*/
			return	KB::ShowRCCancel;

		case KB::ShowRCData   :
			/* Form now shown in data mode. This will be	*/
			/* passed back as being OK.			*/
			break	;

#if	! __KB_RUNTIME
		case KB::ShowRCDesign :
			/* If the user wanted data view then show the	*/
			/* error, but anyways passes back as OK.	*/
			if (m_showing == KB::ShowAsData)
			{	m_docRoot->lastError().DISPLAY() ;
				m_showing = KB::ShowAsDesign ;
			}
			break	;
#endif
		default	:
			/* The only other case should be an error ...	*/
			pError	= m_docRoot->lastError() ;
			return	KB::ShowRCError	;
	}

	/* Note the top-most widget in the form itself and show it,	*/
	/* size the GUI building will have left it hidden.		*/
	m_topWidget  = m_docRoot->getDisplay()->getTopWidget () ;
	m_topWidget ->show () ;


#if	! __KB_RUNTIME
	if (m_showing != showAs)
	{
		KBaseGUI *g = m_showing == KB::ShowAsDesign ? m_designGUI : m_dataGUI ;
		setGUI		  (g) ;
		m_docRoot->setGUI (g) ;
	}
#endif

	/* Connect to the execution error signal. The "executing" flag	*/
	/* is then set so that we will ignore this signal unless we	*/
	/* are executing the form (ie., we are in data view.		*/
	connect
	(	m_docRoot->getDocRoot(),
		SIGNAL (execError()),
		SLOT   (execError())
	)	;

	connect
	(	m_docRoot,
		SIGNAL(focusAtRow(bool, uint, uint, bool)),
		SLOT  (focusAtRow(bool, uint, uint, bool))
	)	;
	connect
	(	m_docRoot->getDocRoot(),
		SIGNAL(requestClose(int)),
		SLOT  (requestClose(int))
	)	;
	connect
	(	m_docRoot->getDocRoot(),
		SIGNAL (statusChange(KBDocStatus *)),
		SLOT   (statusChange(KBDocStatus *))
	)	;

	m_docRoot->setWidget (m_partWidget->mainWidget()) ;
	setupWidget (size) ;

	/* Finally show the part; it should be shown modally or not	*/
	/* depending on the initial modal setting.			*/
	return	m_partWidget->show  (false, KB::ShowAuto) ;
}

/*  KBFormViewer							*/
/*  ~KBFormViewer: Destructor for form viewer				*/
/*  (returns)	 : void		:					*/

KBFormViewer::~KBFormViewer ()
{
	if ((m_showing == KB::ShowAsData) && m_docRoot)
		m_docRoot->finish () ;

#if	! __KB_RUNTIME
	DELOBJ	(m_objTree) ;
#endif
}

void	KBFormViewer::setupWidget
	(	const QSize	&size
	)
{
	m_executing = m_showing == KB::ShowAsData ;

	setCaption    		(m_docRoot->getAttrVal("caption" )) ;
	m_partWidget->setIcon	(getSmallIcon ("form")) ;

	m_partWidget->resize
	(	size.width (),
		size.height(),
		!m_executing || !m_docRoot->hideMenuToolBars (),
		 m_executing &&  m_docRoot->hasStatusBar     ()
	)	;

	if (m_executing)
	{
		bool hmt = m_docRoot->hideMenuToolBars ()   ;
		m_partWidget->showMenuToolBars (!hmt, !hmt) ;
	}
	else	m_partWidget->showMenuToolBars (true, true) ;

	if (m_statusBar != 0)
		if (m_executing && m_docRoot->hasStatusBar ())
			m_statusBar->show() ;
		else	m_statusBar->hide() ;

}

/*  KBFormViewer							*/
/*  showAs	: Show document in specified mode			*/
/*  _showAs	: KB::ShowAs	: Specified mode			*/
/*  (returns)	: void		:					*/

void	KBFormViewer::showAs
	(	KB::ShowAs	_showAs
	)
{
#if	! __KB_RUNTIME
	if ((_showAs == KB::ShowAsDesign) || (_showAs == KB::ShowAsData))
	{
		cchar		*cmsg	;
		KB::ShowRC	rc	;
		QSize		size	;

		if (_showAs == m_showing) return ;

		if ((cmsg = getChanged (false)) != 0)
			if (TKMessageBox::questionYesNo
				(	0,
					QString(TR("Form %1 changed: switch mode anyway?")).arg(cmsg)
				)		!= TKMessageBox::Yes)
				return	;

		m_showing = _showAs	;

		/* As for ::startup, show the GUI in the expected	*/
		/* state.						*/
		m_dataGUI->setStatusBar (m_docRoot->hasStatusBar()) ;
		KBaseGUI *g = m_showing == KB::ShowAsDesign ? m_designGUI : m_dataGUI ;
		setGUI		  (g) ;
		m_docRoot->setGUI (g) ;


		/* Clear the execution flag so that any execution	*/
		/* errors that occur as we (possibly) enter data view	*/
		/* are not picked up here. At this stage we reply on	*/
		/* the return codes from showDesign/showData.		*/
		m_executing = false	;

		if (m_showing == KB::ShowAsDesign)
			rc = m_docRoot->showDesign (m_partWidget, size) ;
		else	rc = m_docRoot->showData   (m_partWidget, m_pDict, m_parentKey, size) ;

		switch (rc)
		{
			case KB::ShowRCCancel :
				/* User cancelled. Must have been a	*/
				/* switch to data mode, so stay in	*/
				/* design.				*/
				m_showing = KB::ShowAsDesign ;
				break	;

			case KB::ShowRCData   :
				/* Form now shown in data mode.		*/
				break	;

			case KB::ShowRCDesign :
				/* If the user wanted data view then	*/
				/* show the error, but otherwise OK.	*/
				if (m_showing == KB::ShowAsData)
				{	m_docRoot->lastError().DISPLAY() ;
					m_showing = KB::ShowAsDesign ;
				}
				break	;

			default	:
				/* The only other case should be an	*/
				/* error, so assume design mode.	*/
				m_docRoot->lastError().DISPLAY() ;
				m_showing = KB::ShowAsDesign ;
				break	;
		}


		m_topWidget  = m_docRoot->getDisplay()->getTopWidget () ;
		m_topWidget ->show () ;

		if (m_showing != _showAs)
		{
			KBaseGUI *g = m_showing == KB::ShowAsDesign ? m_designGUI : m_dataGUI ;
			setGUI		  (g) ;
			m_docRoot->setGUI (g) ;
		}

		setupWidget (size) ;
		m_partWidget->show (true, KB::ShowAuto) ;
		return	;
	}
#endif

	if (_showAs == KB::ShowAsPrint)
	{
		KBWriter *writer = new KBWriter (0, getLocation()) ;

		if (!writer->setup
			(	QString::null,
				true,
				KBOptions::getLeftMargin  (),
				KBOptions::getRightMargin (),
				KBOptions::getTopMargin   (),
				KBOptions::getBottomMargin(),
				true
		   )	)
		{
			delete	writer ;
			return	;
		}

		int extra ;
		m_docRoot->write    (writer, QPoint(0,0), false, extra) ;
		writer   ->printDoc (QString::null, -1) ;

		delete	writer ;
		return	;
	}
}

/*  KBFormViewer							*/
/*  saveDocumentAs: Save document under specified name			*/
/*  (returns)	  : void	:					*/

void	KBFormViewer::saveDocumentAs ()
{
#if	! __KB_RUNTIME
	/* This is only meaningful in design mode ....			*/
	if (m_showing == KB::ShowAsDesign)
		if (m_objBase->saveDocumentAs ())
		{	m_docRoot->isLayout()->setChanged (false) ;
			setCaption (m_docRoot->getAttrVal("caption")) ;
		}
#endif
}

/*  KBFormViewer							*/
/*  saveDocument: Save document						*/
/*  (returns)	: void		:					*/

void	KBFormViewer::saveDocument ()
{
#if	! __KB_RUNTIME
	/* If we are in design mode then this is interpreted as saving	*/
	/* the form design.						*/
	if (m_showing == KB::ShowAsDesign)
	{
		if (m_objBase->saveDocument ())
		{	m_docRoot->isLayout ()->setChanged  (false) ;
			setCaption (m_docRoot->getAttrVal("caption")) ;
		}
		return	;
	}
#endif
	/* Otherwise, save the values displayed in the form ...		*/
	m_docRoot->formAction (KB::Save) ;
}

/*  KBFormViewer							*/
/*  queryClose	: Query whether to close				*/
/*  (returns)	: bool		: True to allow close			*/

bool	KBFormViewer::queryClose ()
{
	cchar	*cmsg	;

	if ((cmsg = getChanged (true)) != 0)
		if (TKMessageBox::questionYesNo
			(	0,
				QString(TR("Form %1 changed: close anyway?")).arg(cmsg)
			)	!= TKMessageBox::Yes
		   )	return	false	;

	if (m_showing == KB::ShowAsData)
		if (!m_docRoot->queryClose ())
			return	false	;

	return	true	;
}

/*  KBFormViewer							*/
/*  doCtrlAlign	: Handle control alignment request			*/
/*  align	: int		: Aligment operation			*/
/*  (returns)	: void		:					*/

void	KBFormViewer::doCtrlAlign
	(	int	align
	)
{
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign)
		m_docRoot->doCtrlAlign ((KB::CtrlAlign)align) ;
#endif
}

/*  KBFormViewer							*/
/*  showObjTree	: Toggle the object tree for the form			*/
/*  (returns)	: void		:					*/

void	KBFormViewer::showObjTree ()
{
#if	! __KB_RUNTIME
	if (m_objTree == 0)
	{
		m_objTree = new KBObjTreeViewer
			  	(	0,//m_objBase,
					m_embed,
					getLocation(),
					m_docRoot,
					m_docRoot
				)	;

		connect
		(	m_objTree, SIGNAL(destroyed	   ()),
			this,	   SLOT  (objTreeViewerDead())
		)	;

		m_designGUI->setChecked ("KB_showObjTree", true) ;
		m_dataGUI  ->setChecked ("KB_showObjTree", true) ;
	}
	else
	{	DELOBJ	 (m_objTree) ;
		objTreeViewerDead () ;
	}
#endif
}

/*  KBFormViewer							*/
/*  doMultiProp	: Invoke multiple-object properties dialog		*/
/*  (returns)	: void		:					*/

void	KBFormViewer::doMultiProp ()
{
#if	! __KB_RUNTIME
	if (m_docRoot) m_docRoot->KBLayout::doMultiProp () ;
#endif
}

/*  KBFormViewer							*/
/*  doProperties: Invoke object properties dialog			*/
/*  (returns)	: void		:					*/

void	KBFormViewer::doProperties ()
{
#if	! __KB_RUNTIME
	if (m_docRoot) m_docRoot->KBLayout::doSingleProp () ;
#endif
}


/*  KBFormViewer							*/
/*  objTreeViewerDead							*/
/*		: Note death of object tree display			*/
/*  (returns)	: void		:					*/

void	KBFormViewer::objTreeViewerDead ()
{
#if	! __KB_RUNTIME
	m_objTree	= 0 ;
	m_designGUI->setChecked ("KB_showObjTree", false) ;
	m_dataGUI  ->setChecked ("KB_showObjTree", false) ;
#endif
}

/*  KBFormViewer							*/
/*  dbaseAction	: Handle database action request			*/
/*  action	: int		: Database action			*/
/*  (returns)	: void		:					*/

void	KBFormViewer::dbaseAction
	(	int	action
	)
{
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsData)
#endif
		if (!m_docRoot->formAction ((KB::Action)action))
			m_docRoot->lastError().DISPLAY() ;
}

/*  KBFormViewer							*/
/*  reload	: Reload table data					*/
/*  (returns)	: void		:					*/

void	KBFormViewer::reload ()
{
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsData)
#endif
		if (!m_docRoot->requery ())
			m_docRoot->lastError().DISPLAY() ;
}

/*  KBFormViewer							*/
/*  doCut	: Handle cut request					*/
/*  (returns)	: void		:					*/

void	KBFormViewer::doCut ()
{
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign) m_docRoot->doCut () ;
#endif
}

/*  KBFormViewer							*/
/*  doCopy	: Handle copy request					*/
/*  (returns)	: void		:					*/

void	KBFormViewer::doCopy ()
{
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign) m_docRoot->doCopy () ;
#endif
}

/*  KBFormViewer							*/
/*  doSaveComponent							*/
/*		: Handle request to save objects as component		*/
/*  (returns)	: void		:					*/

void	KBFormViewer::doSaveComponent ()
{
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign)
		m_docRoot->doSaveComponent (getLocation()) ;
#endif
}

/*  KBFormViewer							*/
/*  doPaste	: Handle patse request					*/
/*  (returns)	: void		:					*/

void	KBFormViewer::doPaste ()
{
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign) m_docRoot->doPaste () ;
#endif
}

/*  KBFormViewer							*/
/*  getChanged	: Report whether there are unsaved changes		*/
/*  both	: bool		: True for both data and design change	*/
/*  (returns)	: cchar *	: Changed message or null if none	*/

cchar	*KBFormViewer::getChanged
	(	bool	both
	)
{
	return	m_docRoot->getChanged (both) ;
}

/*  KBFormViewer							*/
/*  snapToGrid	: Snap selected controls to the grid			*/
/*  (returns)	: void		:					*/

void	KBFormViewer::snapToGrid ()
{
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign) m_docRoot->snapToGrid () ;
#endif
}

/*  KBFormViewer							*/
/*  execError	: Handle script execution error				*/
/*  (returns)	: void		:					*/

void	KBFormViewer::execError ()
{
#if	! __KB_RUNTIME
	/* The form emits a signal if there is an execution-time error,	*/
	/* typically a script error. If the form is being executed	*/
	/* (ie., we are not inside ::startup nor ::showAs) then flip	*/
	/* to design mode.						*/
	if (m_executing) showAs (KB::ShowAsDesign) ;
#endif
}

void	KBFormViewer::requestClose
	(	int	rc
	)
{
	fprintf
	(	stderr,
		"KBFormViewer::requestClose: %d\n",
		rc
	)	;
	m_objBase->setRC (rc) ;
	qApp->postEvent  (this, new QEvent(QEvent::User)) ;
}

bool	KBFormViewer::event
	(	QEvent		*e
	)
{
	if (e->type() == QEvent::User)
	{
		slotClose () ;
		return	true ;
	}

	return	false	;
}


bool	KBFormViewer::playerPerform
	(	const QString		&action,
		const QStringList	&args,
		KBError			&pError
	)
{
	if (action == "close")
	{
		slotClose ()	;
		return	true	;
	}

	if (action == "save")
	{
		saveDocument () ;
		return	true	;
	}

	return	KBPlayer::playerPerform (action, args, pError) ;
}

QString	KBFormViewer::playerName ()
{
	return	m_docRoot ? m_docRoot->getName() : QString("UnnamedForm") ;
}

/*  KBFormViewer							*/
/*  setFocusAtRow: Set focus row information for current block		*/
/*  hasData	 : bool		: Block has data			*/
/*  curRow	 : uint		: Current row number			*/
/*  numRows	 : uint		: Number of rows			*/
/*  inQuery	 : bool		: In query				*/
/*  (returns)	 : void		:					*/

void	KBFormViewer::focusAtRow
	(	bool		hasData,
		uint		curRow,
		uint		numRows,
		bool		inQuery
	)
{
	if (m_showing == KB::ShowAsData)
		m_dataGUI->setFocusAtRow (hasData, curRow, numRows, inQuery) ;
}

void	KBFormViewer::statusChange
	(	KBDocStatus	*docStatus
	)
{
	if ((m_showing == KB::ShowAsData) && (m_locking != 0))
		m_locking->setText
		(	docStatus->m_locking == KBQryBase::NoLocking ?
				TR("Unlocked") :
				TR("Record locked")
		)	;
}
