/***************************************************************************
    file	         : kb_qryjoindlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"

#ifndef 	_WIN32
#include	"kb_qryjoindlg.moc"
#else
#include 	"kb_qryjoindlg.h"
#endif


KBQryJoinDlg::KBQryJoinDlg
	(	const QString	&tblChildName,
		const QString	&fldChildName,
		const QString	&tblParentName,
		const QString	&fldParentName,
		const QString	&jtype
	)
	:
	_KBDialog	("Join properties", true),
	labChild	(this),
	labParent	(this),
	tblChild	(this),
	tblParent	(this),
	fldChild	(this),
	fldParent	(this),
	labJoin		(this),
	cbJoin		(this),
	bOK		(this),
	bCancel		(this),
	bDelete		(this)
{
	layMain		= new QVBoxLayout (this)	;
	layProps	= new QGridLayout (layMain)	;
	layButt		= new QHBoxLayout (layMain)	;

	layProps->addWidget (&labParent, 0, 0) ;
	layProps->addWidget (&labChild,	 0, 1) ;
	layProps->addWidget (&tblParent, 1, 0) ;
	layProps->addWidget (&tblChild,	 1, 1) ;
	layProps->addWidget (&fldParent, 2, 0) ;
	layProps->addWidget (&fldChild,	 2, 1) ;

	layProps->addWidget (&labJoin,	 3, 0) ;
	layProps->addWidget (&cbJoin,	 3, 1) ;

	labParent.setText   (TR("Many ..."   ));
	labChild .setText   (TR("... to one" ));
	labJoin  .setText   (TR("Join type"  ));

//	fprintf
//	(	stderr,
//		"KBQryJoinDlg::KBQryJoinDlg: tblChildName=[%s]\n",
//		(cchar *)tblChildName
//	)	;
//	fprintf
//	(	stderr,
//		"KBQryJoinDlg::KBQryJoinDlg: tblParentName=[%s]\n",
//		(cchar *)tblParentName
//	)	;
//	fprintf
//	(	stderr,
//		"KBQryJoinDlg::KBQryJoinDlg: fldChildName=[%s]\n",
//		(cchar *)fldChildName
//	)	;
//	fprintf
//	(	stderr,
//		"KBQryJoinDlg::KBQryJoinDlg: fldParentName=[%s]\n",
//		(cchar *)fldParentName
//	)	;

	tblChild .setText   (tblChildName ) ;
	tblParent.setText   (tblParentName) ;
	fldChild .setText   (fldChildName ) ;
	fldParent.setText   (fldParentName) ;

	cbJoin   .insertItem(TR("Inner"	     )) ;
	cbJoin   .insertItem(TR("Left Outer" )) ;
	cbJoin   .insertItem(TR("Right Outer")) ;

	if	(jtype == "left" ) cbJoin.setCurrentItem (1) ;
	else if	(jtype == "right") cbJoin.setCurrentItem (2) ;
	else			   cbJoin.setCurrentItem (0) ;

	tblChild .setReadOnly (true) ;
	tblParent.setReadOnly (true) ;
	fldChild .setReadOnly (true) ;
	fldParent.setReadOnly (true) ;

	QPalette pal = tblChild.palette() ;
	pal.setColor (QColorGroup::Base,       QColor(192,192,192)) ;
	pal.setColor (QColorGroup::Background, QColor(192,192,192)) ;
 
	tblChild .setPalette  (pal) ;
	tblParent.setPalette  (pal) ;
	fldChild .setPalette  (pal) ;
	fldParent.setPalette  (pal) ;

	layButt ->addStretch() ;
	layButt ->addWidget (&bCancel) ;
	layButt ->addWidget (&bDelete) ;
	layButt ->addWidget (&bOK    ) ;

	bCancel  .setText   (TR("Cancel")) ;
	bDelete  .setText   (TR("Delete")) ;
	bOK      .setText   (TR("OK"    )) ;

	doDel	 = false ;

	connect	(&bCancel, SIGNAL(clicked()), SLOT(clickCancel())) ;
	connect	(&bDelete, SIGNAL(clicked()), SLOT(clickDelete())) ;
	connect	(&bOK,     SIGNAL(clicked()), SLOT(clickOK    ())) ;
}

void	KBQryJoinDlg::clickCancel ()
{
	done	(0)	;
}

void	KBQryJoinDlg::clickDelete ()
{
	doDel	= true	;
	done	(1)	;
}

void	KBQryJoinDlg::clickOK ()
{
	doDel	= false	;
	done	(1)	;
}

bool	KBQryJoinDlg::getResults
	(	QString		&jtype
	)
{
	switch (cbJoin.currentItem())
	{	case 1  : jtype = "left"  ; break ;
		case 2  : jtype = "right" ; break ;
		default : jtype = ""	  ; break ;
	}

	return	doDel	;
}

