/***************************************************************************
    file	         : kb_tableviewer.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qobjectlist.h>
#include	<qwidget.h>
#include	<qfile.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_gui.h"
#include	"kb_display.h"
#include	"kb_form.h"
#include	"kb_attrdict.h"
#include	"kb_qrydesign.h"
#include	"kb_databuffer.h"
#include	"kb_grid.h"
#include	"kb_prompt.h"

#include	"kb_nodereg.h"
#include	"kb_parse.h"

#include	"kb_viewer.h"

#ifndef 	_WIN32
#include	"kb_tableviewer.moc"
#else
#include 	"kb_tableviewer.h"
#endif

#if		! __KB_RUNTIME
#include	"kb_designform.h"
#endif

#include	"kb_filterdlg.h"

#include	"tk_icons.h"
#include	"tk_messagebox.h"




static	GUIElement tvGUI[] =
{
//	GType		GGroup		Enable	Text			Icon		Accelerator	Slot			  Element name		Code		Tool Tip
{	GTAction,	KB::GRNone,	true,	"&Edit filters",	"edit",		ACCEL(NoAccel),	SLOT(editFilters          ()),"KB_editFilters",	0,		"Execute copy"			},
{	GTNone,		KB::GRNone,	false,	0,			0,		ACCEL(NoAccel),	0,			  0,		 	0,		0				}
}	;

/*  KBTableViewer							*/
/*  KBTableViewer: Constructor for table view/design class		*/
/*  parent	 : KBObjBase *	 : Parent object			*/
/*  embed	 : QWidget *	 : Embedding widget			*/
/*  modal	 : bool		 : Run form modally			*/
/*  (returns)	 : KBTableViewer :					*/

KBTableViewer::KBTableViewer
	(	KBObjBase	*parent,
		QWidget		*embed,
		bool		modal
	)
	:
	KBViewer  (parent, embed, WDestructiveClose|WStyle_NormalBorder, modal)
{
	setLocalGUISpec	(&tvGUI[0]) ;

	m_showing   = KB::ShowAsUnknown ;
	m_docRoot   = 0	;
	m_ident	    = 0	;
	m_byExpr	  = false ;

	m_sortSet	= new TKActionMenu
			  (	TR("Sorting"),
				this,
				"KB_sortSet"
			  )	;
	m_selectSet	= new TKActionMenu
			  (	TR("Select"),
				this,
				"KB_selectSet"
			  )	;
	m_viewSet	= new TKActionMenu
			  (	TR("Columns"),
				this,
				"KB_viewSet"
			  )	;

	m_filtering.setAutoDelete (true) ;

	m_dataGUI	  = new KBNavGUI (this, this, "rekallui.table.data"  ) ;
#if	! __KB_RUNTIME
	m_designGUI = new KBaseGUI (this, this, "rekallui.table.design") ;
#endif
}

/*  KBTableViewer:							*/
/*  startup	 : Start execution					*/
/*  create	 : bool		: Create new table			*/
/*  showAs	 : KB::ShowAs	: Display mode				*/
/*  pError	 : KBError &	: Error return				*/
/*  (returns)	 : KB::ShowRC	: Startup success			*/

KB::ShowRC
	KBTableViewer::startup
	(	bool		_create,
		KB::ShowAs	showAs,
		KBError		&pError
	)
{
	KB::ShowRC rc   ;
	KBaseGUI   *gui ;

	m_create   = _create ;
	m_showing  = showAs  ;

#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign)
	{
		setGUI (gui = m_designGUI) ;
		rc = showDesign (pError) ;
	}
	else
#endif
	{
		setGUI (gui = m_dataGUI  ) ;
		rc = showData   (pError) ;
	}

	if (rc != KB::ShowRCOK)
		return	KB::ShowRCError	 ;

#if	! __KB_RUNTIME
	if (m_showing != showAs)
	{
		KBaseGUI *gui = m_showing == KB::ShowAsDesign ? m_designGUI : m_dataGUI ;
		setGUI 		(gui) ;
	}
#endif

	setCaption (getLocation().title()) ;
	m_docRoot   ->setGUI (gui) ;

	return	m_partWidget->show   (false, KB::ShowAuto) ;
}

/*  KBTableViewer							*/
/*  ~KBTableViewer: Destructor for table view/design class		*/
/*  (returns)	  : void	:					*/

KBTableViewer::~KBTableViewer ()
{
	if (m_docRoot != 0) m_docRoot->finish () ;

	DELOBJ	(m_ident  ) ;
	DELOBJ	(m_docRoot) ;

	QDictIterator<KBType> iter(m_typeMap) ;

	while (iter.current() != 0)
	{	iter.current()->deref() ;
		iter += 1 ;
	}

	m_typeMap  .clear () ;
	m_filtering.clear () ;
}


/*  KBTableViewer							*/
/*  showView	: Show specified view					*/
/*  root	: KBForm *	: View document root			*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: KB::ShowRC	: Success				*/

KB::ShowRC
	KBTableViewer::showView
	(	KBForm		*root,
		KBError		&pError
	)
{
	KBAttrDict	pDict	;
	KB::ShowRC	rc	;
	QSize		size	;

	pDict.addValue	("_server", getLocation().docLocn) ;
	pDict.addValue	("_table",  getLocation().docName) ;
	pDict.addValue	("_create", m_create ? "Yes" : "No") ;

	rc = root->showData (m_partWidget, pDict, KBValue(), size) ;
	if (rc != KB::ShowRCData)
	{
		pError	= root->lastError () ;
		return	KB::ShowRCError ;
	}

	m_create    = false  ;
	m_topWidget = root->getDisplay()->getTopWidget() ;

	m_partWidget->setIcon (getSmallIcon ("table")) ;

	if (m_showing == KB::ShowAsData)
	{
		QScrollView *sv = root->getDisplay()->getScroller()  ;

		int	fw	= sv  ->frameWidth	 () ;
		int	sbw	= sv  ->verticalScrollBar()->sizeHint().width() ;
		int	height	= sv  ->contentsHeight	 () + 2 * fw ;
		int	width	= sv  ->contentsWidth 	 () + 2 * fw + sbw ;

		if (height > 580) height = 580  ;
		if (height < 420) height = 420  ;
		if (width  > 780) width  = 780  ;

		size	= QSize (width, height) ;
	}
	else	size   += QSize (8, 8) ;

	m_partWidget->resize	(size.width(), size.height() + 24, true, false) ;
 	m_topWidget ->show 	()     ;

	DELOBJ	(m_docRoot) ;
	m_docRoot	= root	  ;
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign)
		m_qryRoot	= (KBQryDesign *)m_docRoot->getQuery() ;
#endif

	return	KB::ShowRCOK ;
}

/*  KBTableViewer							*/
/*  showDesign	 : Show table in design mode				*/
/*  pError	 : KBerror &	: Error return				*/
/*  (returns)	 : KB::ShowRC	: Success				*/

KB::ShowRC
	KBTableViewer::showDesign
	(	KBError	&pError
	)
{
#if	! __KB_RUNTIME
	KBForm		*root	;
	QByteArray	df	;

	df.duplicate (designForm, qstrlen(designForm)) ;

	if ((root = KBOpenFormText (getLocation(), df, pError)) == 0)
		return	KB::ShowRCError ;

	DELOBJ	(m_ident) ;
	return	showView (root, pError) ;
#else
	return	KB::ShowRCError	;
#endif
}

/*  KBTableViewer							*/
/*  showData	 : Show table in data mode				*/
/*  pError	 : KBerror &	: Error return				*/
/*  (returns)	 : KB::ShowRC	: Success				*/

KB::ShowRC
	KBTableViewer::showData
	(	KBError	&pError
	)
{
	extern	KBForm	*KBOpenTable (KBLocation &, QDict<KBType> &, KBError &) ;

	KBForm	*root	;

	QDictIterator<KBType> iter(m_typeMap) ;

	while (iter.current() != 0)
	{	iter.current()->deref() ;
		iter += 1 ;
	}

	m_typeMap.clear () ;

	if ((root = KBOpenTable (getLocation(), m_typeMap, pError)) == 0)
		return	KB::ShowRCError	;

	m_ident	= new KBAttrStr
		  (	root,
			"ident",
			QString("%1/%2").arg(getLocation().docLocn).arg(getLocation().docName)
		  )	;

	connect
	(	root,
		SIGNAL(focusAtRow(bool, uint, uint, bool)),
		SLOT  (focusAtRow(bool, uint, uint, bool))
	)	;


	buildFilterMenu () ;

	return	showView (root, pError) ;
}

/*  KBTableViewer							*/
/*  showAs	: Show in specified mode				*/
/*  _showAs	: KB::ShowAs	: Requested mode			*/
/*  (returns)	: void		:					*/

void	KBTableViewer::showAs
	(	KB::ShowAs	_showAs
	)
{
#if	! __KB_RUNTIME
	KBError	error	;
	bool	ok	;

	if (m_showing == _showAs) return ;

	if (m_docRoot->getChanged (false) != 0)
	{
		QString	msg =  m_showing == KB::ShowAsDesign ?
					TR("Table design changed switch mode anyway?") :
					TR("Table data changed switch mode anyway?") ;

		if (TKMessageBox::questionYesNo (0, msg) != TKMessageBox::Yes)
			return	;
	}

	m_byExpr	= false	   ;
	m_showing	= _showAs  ;
	m_docRoot->finish () ;

	if (m_showing == KB::ShowAsDesign)
		ok = showDesign (error) ;
	else	ok = showData   (error) ;

	KBaseGUI *gui = m_showing == KB::ShowAsDesign ? m_designGUI : m_dataGUI ;
	setGUI (gui) ;
	m_docRoot   ->setGUI (gui) ;
	m_partWidget->show   (true, KB::ShowAuto) ;

	if (ok != KB::ShowRCOK) error.DISPLAY() ;
#endif
}

/*  KBTableViewer							*/
/*  buildFilterMenu							*/
/*		: Build menu for filtering selections			*/
/*  menu	: TKActionMenu *	: Menu to be built		*/
/*  entries	: const QStringList &	: List of entries		*/
/*  first	: const QString &	: Text for first entry		*/
/*  slot	: const char *		: Slot to be invoked 		*/
/*  (returns)	: void			:				*/

void	KBTableViewer::buildFilterMenu
	(	TKActionMenu		*menu,
		const QStringList	&entries,
		const QString		&first,
		const char		*slot
	)
{
	TKToggleAction	*toggle	;

	toggle	= new TKToggleAction
		  (	first,
			QString::null,
			0,
			this,
			slot,
			menu,
			"clear"
		  )	;
	toggle->setChecked (true  ) ;
	menu  ->insert	   (toggle) ;
	m_filtering.append (toggle) ;

	for (uint idx = 0 ; idx < entries.count() ; idx += 1)
	{
		toggle = new TKToggleAction
			 (	entries[idx],
				QString::null,
				0,
				this,
				slot,
				menu,
				0
			 )	;

		menu->insert	   (toggle) ;
		m_filtering.append (toggle) ;

		fprintf	(stderr, "Added filter [%s]\n", (cchar *)entries[idx]) ;
	}

}

/*  KBTableViewer							*/
/*  buildFilterMenu							*/
/*		: Build all filtering menus				*/
/*  (returns)	: void		:					*/

void	KBTableViewer::buildFilterMenu ()
{
	LITER
	(	TKAction,
		m_filtering,
		action,
		action->unplugAll()
	)

	m_filtering.clear () ;

	KBDBInfo	*dbInfo	 = getLocation().dbInfo ;
	KBTableInfo	*tabInfo = dbInfo->findTableInfo (getLocation().docLocn, getLocation().docName) ;

//	fprintf
//	(	stderr,
//		"buildFilterMenu: tabInfo=%p\n",
//		(void *)tabInfo
//	)	;

	if (tabInfo == 0) return ;

	QStringList sortList ;
	tabInfo->sortList   (sortList  ) ;
	buildFilterMenu	    (m_sortSet,   sortList,   TR("Default"),     SLOT(applySort  ())) ;

	QStringList selectList ;
	tabInfo->selectList (selectList) ;
	buildFilterMenu	    (m_selectSet, selectList, TR("All rows"),    SLOT(applySelect())) ;

	QStringList viewList ;
	tabInfo->viewList   (viewList  ) ;
	buildFilterMenu	    (m_viewSet,   viewList,   TR("All columns"), SLOT(applyView  ())) ;

	m_currSort   = QString::null ;
	m_currSelect = QString::null ;
}

/*  KBTableViewer							*/
/*  checkToggle	: Check on toggle on a menu				*/
/*  menu	: TKActionMenu * : Menu to scan				*/
/*  action	: TKAction	 : Action to be checked			*/
/*  (returns)	: void		:					*/

void	KBTableViewer::checkToggle
	(	TKActionMenu	*menu,
		TKAction	*action
	)
{
	QObjectList *children = menu->queryList("TKToggleAction", 0, false, false) ;
	if (children == 0) return ;

	QObjectListIt iter (*children) ;
	QObject	      *obj ;

	while ((obj = iter.current()) != 0)
	{	*++iter ;
		((TKToggleAction *)obj)->setChecked (obj == action) ;
	}
}

/*  KBTableViewer							*/
/*  applySort	: Apply sorting filter					*/
/*  (returns)	: void		:					*/

void	KBTableViewer::applySort ()
{
	const QObject	*object	 = sender() 		;
	TKAction	*action	 = (TKAction *)object	;
	QString		name	 = action ->text()	;
	KBDBInfo	*dbInfo	 = getLocation().dbInfo	;
	KBTableInfo	*tabInfo = dbInfo ->findTableInfo (getLocation().docLocn, getLocation().docName) ;
	KBTableSort	*sort	 = tabInfo->getSort (name) ;

//	fprintf
//	(	stderr,
//		"KBTableViewer::applySort: [%s][%p][%s]\n",
//		(cchar *)name,
//		(void  *)sort,
//		action->name()
//	)	;

	if (qstrcmp (action->name(), "clear") == 0)
	{
		m_currSort = QString::null ;
	}
	else if (sort != 0)
	{
		KBDataBuffer text ;
		sort->sql (text)  ;
		m_currSort = QString::fromUtf8(text.data()) ;
	}

//	fprintf
//	(	stderr,
//		"KBTableViewer::applySort: [%s][%s]\n",
//		(cchar *)m_currSelect,
//		(cchar *)m_currSort
//	)	;

        m_docRoot->setUserFilter  (m_currSelect) ;
        m_docRoot->setUserSorting (m_currSort  ) ;

	if (!m_docRoot->requery ())
		m_docRoot->lastError().DISPLAY() ;

	checkToggle (m_sortSet, action) ;
}

/*  KBTableViewer							*/
/*  applySort	: Apply selection filter					*/
/*  (returns)	: void		:					*/

void	KBTableViewer::applySelect ()
{
	const QObject	*object	 = sender() 		;
	TKAction	*action	 = (TKAction *)object	;
	QString		name	 = action ->text()	;
	KBDBInfo	*dbInfo	 = getLocation().dbInfo	;
	KBTableInfo	*tabInfo = dbInfo ->findTableInfo (getLocation().docLocn, getLocation().docName) ;
	KBTableSelect	*select	 = tabInfo->getSelect (name) ;

//	fprintf
//	(	stderr,
//		"KBTableViewer::applySelect: [%s][%p][%s]\n",
//		(cchar *)name,
//		(void  *)select,
//		sender()->name()
//	)	;

	if (qstrcmp (sender()->name(), "clear") == 0)
	{
		m_currSelect = QString::null ;
	}
	else if (select != 0)
	{
		KBDataBuffer text   ;
		select->sql (text, m_typeMap) ;
		m_currSelect = QString::fromUtf8(text.data()) ;
	}

//	fprintf
//	(	stderr,
//		"KBTableViewer::applySelect: [%s][%s]\n",
//		(cchar *)m_currSelect,
//		(cchar *)m_currSort
//	)	;

        m_docRoot->setUserFilter  (m_currSelect) ;
        m_docRoot->setUserSorting (m_currSort  ) ;

	if (!m_docRoot->requery ())
		m_docRoot->lastError().DISPLAY() ;

	checkToggle (m_selectSet, action) ;
}

/*  KBTableViewer							*/
/*  applyView	: Apply column view filter				*/
/*  (returns)	: void		:					*/

void	KBTableViewer::applyView ()
{
	const QObject	*object	 = sender() 		;
	TKAction	*action	 = (TKAction *)object	;
	QString		name	 = action ->text()	;
	KBDBInfo	*dbInfo	 = getLocation().dbInfo	;
	KBTableInfo	*tabInfo = dbInfo ->findTableInfo (getLocation().docLocn, getLocation().docName) ;
	KBTableView	*view	 = tabInfo->getView (name) ;

	fprintf
	(	stderr,
		"KBTableViewer::applyView: [%s][%p][%s]\n",
		(cchar *)name,
		(void  *)view,
		sender()->name()
	)	;

	KBDBLink    dbLink   ;
	if (!dbLink.connect (getLocation().dbInfo, getLocation().docLocn))
	{	dbLink.lastError().DISPLAY() ;
		return	;
	}

	KBTableSpec tabSpec (getLocation().docName) ;
	if (!dbLink.listFields (tabSpec))
	{	dbLink.lastError().DISPLAY() ;
		return	;
	}

	QValueList<bool> visible ;

	if (view != 0)
	{
		/* View selected. First stage is to hide all the	*/
		/* columns that are *not* in the specified view. The	*/
		/* control items under the grid control will be in the	*/
		/* same order as the columns to we just fill the	*/
		/* visibility array in the same order.			*/
		const QStringList &viewSet = view->columns() ;

		for (uint idx = 0 ; idx < tabSpec.m_fldList.count() ; idx += 1)
		{
			KBFieldSpec *fSpec = tabSpec.m_fldList.at(idx) ;
			bool	    show   = false ;

			for (uint col = 0 ; col < viewSet.count() ; col += 1)
				if (viewSet[col] == fSpec->m_name)
				{	show	= true	;
					break	;
				}

			visible.append (show)	;
		}
	}
	else
	{
		for (uint idx = 0 ; idx < tabSpec.m_fldList.count() ; idx += 1)
			visible.append (true) ;
	}

	KBObject *grid = m_docRoot->getNamedObject("$$grid$$") ;
	if ((grid != 0) && (grid->isGrid() != 0))
		grid->isGrid()->setItemsVisible (visible, true) ;

	checkToggle (m_viewSet, action) ;
}

/*  KBTableViewer							*/
/*  editFilters	: Show filter editing dialog				*/
/*  (returns)	: void		:					*/

void	KBTableViewer::editFilters ()
{
	KBDBInfo    *dbInfo  = getLocation().dbInfo ;
	KBTableInfo *tabInfo = dbInfo->findTableInfo (getLocation().docLocn, getLocation().docName) ;

	KBDBLink    dbLink   ;
	if (!dbLink.connect (getLocation().dbInfo, getLocation().docLocn))
	{	dbLink.lastError().DISPLAY() ;
		return	;
	}

	KBTableSpec tabSpec (getLocation().docName) ;
	if (!dbLink.listFields (tabSpec))
	{	dbLink.lastError().DISPLAY() ;
		return	;
	}


	KBFilterDlg fDlg (tabSpec, tabInfo) ;
	fDlg.exec() ;

	fprintf	(stderr, "KBTableViewer::editFilters: saving ....\n") ;

	KBError	error ;
	if (!tabInfo->save (dbInfo, getLocation().docLocn, error))
		error.DISPLAY() ;

	buildFilterMenu () ;
}

/*  KBTableViewer							*/
/*  saveDocument: Save document						*/
/*  (returns)	: void		:					*/

void	KBTableViewer::saveDocument ()
{
	if (!m_docRoot->doAction (KB::Save))
	{	m_docRoot->lastError().DISPLAY() ;
		return	;
	}
}

/*  KBTableViewer							*/
/*  saveDocumentAs: Save document under specified name			*/
/*  (returns)	  : void	:					*/

void	KBTableViewer::saveDocumentAs ()
{
	QString	tabName	= m_qryRoot->getTableName  () ;
	QString	svrName	= m_qryRoot->getServerName () ;

	if (!doPromptSave
		(	TR("Save table definition as ..."),
			TR("Enter table name"),
			tabName,
			svrName,
			getLocation().dbInfo,
			false
		))
		return	;

	if (!m_qryRoot->setLocation (svrName, tabName))
		return	;

	saveDocument ()	;
}

/*  KBTableViewer							*/
/*  dbaseAction	: Handle database action request			*/
/*  action	: iint		: Database action			*/
/*  (returns)	: void		:					*/

void	KBTableViewer::dbaseAction
	(	int	action
	)
{
	if (m_showing == KB::ShowAsData)
		if (!m_docRoot->doAction ((KB::Action)action))
			m_docRoot->lastError().DISPLAY() ;
}

/*  KBTableViewer							*/
/*  reload	: Reload table data					*/
/*  (returns)	: void		:					*/

void	KBTableViewer::reload ()
{
	if (m_showing == KB::ShowAsData)
	{
		fprintf
		(	stderr,
			"KBTableViewer::reload: [%s][%s]\n",
			(cchar *)m_currSelect,
			(cchar *)m_currSort
		)	;

	        m_docRoot->setUserFilter  (m_currSelect) ;
        	m_docRoot->setUserSorting (m_currSort  ) ;

		if (!m_docRoot->requery ())
			m_docRoot->lastError().DISPLAY() ;
	}
}

/*  KBTableViewer							*/
/*  getChanged	: Report whether there are unsaved changes		*/
/*  both	: bool		: True for both data and design change	*/
/*  (returns)	: cchar *	: Changed message or null if none	*/

cchar	*KBTableViewer::getChanged
	(	bool
	)
{
	if (m_docRoot->getChanged (false) != 0)
		return
#if	! __KB_RUNTIME
			m_showing == KB::ShowAsDesign ? "table design" :
#endif
						      "table data"   ;

	return	0	;
}

/*  KBTableViewer							*/
/*  orderByExpr	: Order columns by column expression			*/
/*  (returns)	: void		:					*/

void	KBTableViewer::orderByExpr ()
{
	if ((m_showing == KB::ShowAsData) && (m_docRoot != 0))
	{
		m_byExpr	= !m_byExpr ;
		m_docRoot->orderGridByExpr (m_byExpr) ;
	}
}

/*  KBTableViewer							*/
/*  setFocusAtRow: Set focus row information for current block		*/
/*  hasData	 : bool		: Block has data			*/
/*  curRow	 : uint		: Current row number			*/
/*  numRows	 : uint		: Number of rows			*/
/*  inQuery	 : bool		: In a query				*/
/*  (returns)	 : void		:					*/

void	KBTableViewer::focusAtRow
	(	bool		hasData,
		uint		curRow,
		uint		numRows,
		bool		inQuery
	)
{
	if (m_showing == KB::ShowAsData)
		m_dataGUI->setFocusAtRow (hasData, curRow, numRows, inQuery) ;
}

/*  KBTableViewer							*/
/*  action	: Get GUI action					*/
/*  element	: QDomElement &	: XML GUI element			*/
/*  (returns)	: KAction *	: Action or null if none		*/

#if	__KB_KDE
KAction	*KBTableViewer::action
#endif
#if	__KB_TKC
TKAction*KBTableViewer::action
#endif
	(	const QDomElement &element
	)
	const
{
	const QString	&name	= element.attribute("name") ;

	if (name == "KB_sortSet"  ) return m_sortSet  ->getAction() ;
	if (name == "KB_selectSet") return m_selectSet->getAction() ;
	if (name == "KB_viewSet"  ) return m_viewSet  ->getAction() ;

	return	KBViewer::action (element) ;
}
