/***************************************************************************
    file	         : kb_kjsregister.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<kjs/global.h>
#include	<kjs/interpreter.h>
#include	<kjs/lookup.h>
#include	<kjs/object.h>
#include	<kjs/operations.h>
#include	<kjs/types.h>
#include	<kjs/ustring.h>
#include	<kjs/value.h>

#include	"kb_classes.h"
#include	"kb_item.h"

#include	"kb_idbase.h"
#include	"kb_objectproxy.h"
#include	"kb_itemproxy.h"
#include	"kb_kjsregister.h"


static	KBKJSRegister	*regList	;
static	QDict<MKFUNC*>	mkfuncMap	;


/*  KBKJSRegister							*/
/*  KBKJSRegister: Constructor for class registration objects		*/
/*  kbname	 : cchar *	 : Rekall name				*/
/*  mkFunc	 : MKFUNC *	 : Pointer to factory function		*/
/*  aliases	 : cchar **	 : Possible aliases list		*/
/*  (returns)	 : KBKJSRegister :					*/

KBKJSRegister::KBKJSRegister
	(	cchar		*kbname,
		MKFUNC		*mkFunc,
		cchar		**aliases
	)
	:
	m_kbname	(kbname ),
	m_mkFunc	(mkFunc ),
	m_aliases	(aliases)
{
	/* At this stage (the constuctor is used statically) we just	*/
	/* put the instance on the registration list.			*/
	m_next	= regList	;
	regList	= this		;
}

/*  KBKJSRegister							*/
/*  doRegister	: Register this instance				*/
/*  (returns)	: KBKJSRegister * : Next on list			*/

KBKJSRegister
	*KBKJSRegister::doRegister ()
{
	/* Use a pointer-to-pointer for the factory function, since	*/
	/* QDict cannot be used directory (it tries to create a		*/
	/* function destructor:).					*/
	MKFUNC	**mkFuncPtr = new MKFUNC * ;

	*mkFuncPtr	= m_mkFunc ;
	mkfuncMap.insert (m_kbname, mkFuncPtr) ;

	/* Add any aliases if present ...				*/
	if (m_aliases != 0)
		for (const char **ap = &m_aliases[0] ; *ap != 0 ; ap += 1)
			mkfuncMap.insert (*ap, mkFuncPtr) ;

	fprintf
	(	stderr,
		"KBKJSRegister::doRegister: [%s]->[%p]\n",
		(cchar *)m_kbname,
		(void  *)m_mkFunc
	)	;

	return	m_next	;
}


/*  registerClasses: Register all classes				*/
/*  (reutrns)	   : void	:					*/

void	registerClasses ()
{
	while (regList != 0) regList = regList->doRegister () ;
}


/*  ------------------------------------------------------------------  */

/*  makeProxy	: Make proxy object					*/
/*  interp	: KJS::Interpreter *	: Interpreter			*/
/*  node	: KBNode *		: Node to be proxied		*/
/*  (returns)	: KBObjectProxy *	: Proxy object			*/

KBObjectProxy
	*makeProxy
	(	KJS::Interpreter	*interp,
		KBNode			*node
	)
{
	/* First see if the rekall node is present in the factory map,	*/
	/* in which case construct a proxy using said factory.		*/
	MKFUNC	**mkFunc	;
	if ((mkFunc = mkfuncMap.find (node->getElement())) != 0)
	{
		fprintf
		(	stderr,
			"makeProxy: [%s][%s]->[%p]\n",
			(cchar *)node->isObject()->getName(),
			(cchar *)node->getElement(),
			(void  *)(*mkFunc)
		)	;

		return	(*mkFunc) (interp, node) ;
	}

	/* If not in the factory map then see if it is an item or an	*/
	/* object, in which case create the appropriate proxy. This	*/
	/* gives a catchall for rekall objects which have no special	*/
	/* scripring interface (other than that which they inherit).	*/
	if (node->isItem  ())
	{
		fprintf
		(	stderr,
			"makeProxy: [%s][%s]->Item\n",
			(cchar *)node->isObject()->getName(),
			(cchar *)node->getElement()
		)	;

		return	new KBItemProxy   (interp, node->isItem  ()) ;
	}

	if (node->isObject())
	{
		fprintf
		(	stderr,
			"makeProxy: [%s][%s]->Object\n",
			(cchar *)node->isObject()->getName(),
			(cchar *)node->getElement()
		)	;

		return	new KBObjectProxy (interp, node->isObject()) ;
	}

	/* Hmmm, this really should not happen ....			*/
	fprintf
	(	stderr,
		"makeProxy: [%s][%s]: *** NO PROXY ***\n",
		(cchar *)node->isObject()->getName(),
		(cchar *)node->getElement()
	)	;
	return	0 ;
}

