/***************************************************************************
    file	         : pyframer.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_PYFRAMER_H
#define	__KB_PYFRAMER_H

#include	<stdio.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_framer.h"
#include	"pyitem.h"

class	PyKBFramer : public PyKBObject
{
public	:

	inline	PyKBFramer
		(	long		_cookie,
			long		_ptr,
			const char	*_name
		)
		:
		PyKBObject (_cookie, _ptr, _name)
	{
	}

	int	getNumRows ()
	{
		if (!isValid ()) return -1 ;
		return	((KBFramer *)ptr)->getNumRows() ;
	}

	int	getQueryRow ()
	{
		if (!isValid ()) return -1 ;
		return	((KBFramer *)ptr)->getCurQRow() ;
	}

	cchar	*getRowValue
		(	cchar	*name,
			uint	qrow
		)
	{
		static QString aQString	  ;
		if (!isValid ()) return 0 ;
		aQString = ((KBFramer *)ptr)->getRowValue (name, qrow).getRawText() ;
		return	aQString ;
	}

	void	setRowValue
		(	cchar	*name,
			uint	qrow,
			cchar	*value
		)
	{
		if (!isValid ()) return ;
		((KBFramer *)ptr)->setRowValue (name, qrow, KBValue(value, &_kbString)) ;
	}
}	;

#endif	// __KB_PYFRAMER_H
