/***************************************************************************
    file	         : pysqldelete.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_PYSQLDELETE_H
#define	__KB_PYSQLDELETE_H

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"pybase.h"

class	PyKBSQLDelete : public PyKBBase
{
public	:

	inline	PyKBSQLDelete
		(	long		_cookie,
			long		_ptr,
			const char	*_name
		)
		:
		PyKBBase (_cookie, _ptr, _name)
	{
	}

	inline	~PyKBSQLDelete ()
	{
		KBSQLDelete *SQLDelete = (KBSQLDelete *)getPtr() ;
		if (SQLDelete != 0) delete SQLDelete ;
	}

	inline	bool	execute
		(	uint		nVals,
			const KBValue	*values
		)
	{
		KBSQLDelete *SQLDelete = (KBSQLDelete *)getPtr() ;
		if (SQLDelete == 0) return false ;

		return	SQLDelete->execute (nVals, values) ;
	}

	inline	uint	getNumRows ()
	{
		KBSQLDelete *SQLDelete = (KBSQLDelete *)getPtr() ;
		return	SQLDelete == 0 ? 0 : SQLDelete->getNumRows() ;
	}

	inline	cchar	*lastError ()
	{
		return	PyKBBase::lastError ((KBSQLDelete *)getPtr()) ;
	}
}	;

#endif	// __KB_PYSQLDELETE_H
