/***************************************************************************
    file	         : tkc_pyvaluelist.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TKC_PYVALUELIST_H
#define	__TKC_PYVALUELIST_H

#include	<qwidget.h>
#include	<qlabel.h>
#include	<qlayout.h>
#include	<qlistview.h>
#include	<qlist.h>
#include	<qdict.h>

#include	"tkc_pyvalue.h"

class	TKCPyDebugWidget	;
class	TKCPyValueList		;
class	TKCPyValueItem		;


/*  TKCPyValueList							*/
/*  --------------							*/
/*  This class is used to display tree views of python objects. When	*/
/*  an entry (an TKCPyValueItem) is to be opened (ie., "setOpen" is	*/
/*  called) then it should call the "expand" to to the work. This, and	*/
/*  the "expandXYZ" and "showObject" methods, can be overridden in	*/
/*  derived classes to do selective expansion, for instance so that	*/
/*  only functions appear.						*/

class	TKCPyValueList : public QListView
{

	TKCPyDebugWidget	*debug	;

protected :

	void	expandClass	(TKCPyValueItem *, QDict<TKCPyValue> &) ;
	void	expandDict	(TKCPyValueItem *, QDict<TKCPyValue> &) ;
	void	expandCode	(TKCPyValueItem *, QDict<TKCPyValue> &) ;
	void	expandFunction	(TKCPyValueItem *, QDict<TKCPyValue> &) ;
	void	expandList	(TKCPyValueItem *, QDict<TKCPyValue> &) ;
	void	expandInstance	(TKCPyValueItem *, QDict<TKCPyValue> &) ;
	void	expandModule	(TKCPyValueItem *, QDict<TKCPyValue> &) ;
	void	expandTuple	(TKCPyValueItem *, QDict<TKCPyValue> &) ;

	void	expandFrame
		(	TKCPyValueItem	  *,
			QDict<TKCPyValue> &,
			QDict<TKCPyValue> &
		)	;

	TKCPyValueItem	*insertEntries
		(	TKCPyValueItem    *,
			TKCPyValueItem    *,
			QDict<TKCPyValue> &
		)	;

public	:

	TKCPyValueList	(QWidget *, TKCPyDebugWidget *) ;

	virtual	bool	expand		(TKCPyValueItem *) ;
	virtual	bool	showObject	(PyObject       *) ;

	TKCPyValueItem	*scanForObject	(PyObject       *, bool = true) ;
	void		invalidate	() ;
	void		clean		() ;
}	;


/*  TKCPyValueKill							*/
/*  --------------							*/
/*  This is a helper class used to get notification of the destruction	*/
/*  of a TKCPyValue. Each TKCPyValueItem contains one of these, which	*/
/*  then removes it if the value to which it refers disappears. This	*/
/*  allows us to safely share TKCPyValue's between multiple lists.	*/

class	TKCPyValueKill : public QObject
{
	Q_OBJECT

	TKCPyValueItem	*theItem	;

private	slots	:

	void	valueGone ()		;

public	:

	TKCPyValueKill	(TKCPyValueItem *) ;
	virtual	~TKCPyValueKill	() ;

	void	detach		() ;
}	;


/*  TCKPyValueItem							*/
/*  --------------							*/
/*  QListViewItem derived class for items under a TKCPyListView.	*/

class	TKCPyValueItem : public QListViewItem
{
	TKCPyValue	*m_value	;
	TKCPyValueKill	killer		;
	bool		valid		;

	void		fillIn		() ;

public	:

	TKCPyValueItem (QListView     *, const QString &, TKCPyValue    *) ;
	TKCPyValueItem (QListViewItem *, const QString &, TKCPyValue    *) ;
	TKCPyValueItem (QListView     *, QListViewItem *, const QString &, TKCPyValue    *) ;
	TKCPyValueItem (QListViewItem *, QListViewItem *, const QString &, TKCPyValue    *) ;
       ~TKCPyValueItem () ;

	virtual	void	setOpen		(bool) ;

	void		invalidate	(bool) ;
	void		clean		()     ;
	void		setValid	()     ;

	TKCPyValueItem	*scanForObject	(PyObject *, bool = true) ;

	inline	TKCPyValue	*value	() { return m_value ; }
	inline	bool		isValid	() { return valid   ; }
	inline	QString		key	() { return text(0) ; }

	friend	class	TKCPyValueKill	;
}	;


#endif	// __TKC_PYVALUELIST_H
