/***************************************************************************
    file	         : pyblock.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_PYBLOCK_H
#define	__KB_PYBLOCK_H

#include	<stdio.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_formblock.h"
#include	"pyitem.h"

class	PyKBBlock : public PyKBItem
{
public	:

	inline	PyKBBlock
		(	long		_cookie,
			long		_ptr,
			const char	*_name
		)
		:
		PyKBItem (_cookie, _ptr, _name)
	{
	}

	int	getNumRows ()
	{
		if (!isValid ()) return -1 ;
		return	((KBBlock *)ptr)->getNumRows() ;
	}

	int	getQueryRow ()
	{
		if (!isValid ()) return -1 ;
		return	((KBBlock *)ptr)->getCurQRow() ;
	}

	void	setChanged ()
	{
		if (!isValid ()) return ;
		KBFormBlock *fb = ((KBBlock *)ptr)->isFormBlock() ;
		if (fb == 0)
		{	KBError::EError
			(	"Python Script Error",
				"Invoking setChanged on non-form block",
				__ERRLOCN
			)	;
			return	;
		}
		fb->dataChanged (fb->getCurQRow()) ;
	}

	int	doAction
		(	uint	action
		)
	{
		if (!isValid ()) return 0 ;
		KBFormBlock *fb = ((KBBlock *)ptr)->isFormBlock() ;
		if (fb == 0)
		{	KBError::EError
			(	"Python Script Error",
				"Invoking doAction on non-form block",
				__ERRLOCN
			)	;
			return	0 ;
		}
		if (!fb->doAction ((KB::Action)action))
		{	fb->lastError().display() ;
			return	0 ;
		}
		return	1 ;
	}

	int	firstRecord ()
	{
		return	doAction (KB::First) ;
	}

	int	previousRecord ()
	{
		return	doAction (KB::Previous) ;
	}

	int	nextRecord ()
	{
		return	doAction (KB::Next) ;
	}

	int	lastRecord ()
	{
		return	doAction (KB::Last) ;
	}

	int	addRecord ()
	{
		return	doAction (KB::Add) ;
	}

	int	saveRecord ()
	{
		return	doAction (KB::Save) ;
	}

	int	deleteRecord ()
	{
		return	doAction (KB::Delete) ;
	}

	int	startQuery ()
	{
		return	doAction (KB::Query) ;
	}

	int	executeQuery ()
	{
		return	doAction (KB::Execute) ;
	}

	int	cancelQuery ()
	{
		return	doAction (KB::Cancel) ;
	}

	int	reload ()
	{
		return	doAction (KB::Reload) ;
	}

	int	gotoQueryRow
		(	uint	qrow
		)
	{
		if (!isValid ()) return 0 ;
		KBFormBlock *fb = ((KBBlock *)ptr)->isFormBlock() ;
		if (fb == 0)
		{	KBError::EError
			(	"EL Script Error",
				"Invoking gotoQueryRow on non-form block",
				__ERRLOCN
			)	;
			return	0 ;
		}
		if (!fb->gotoQRow (qrow))
		{	fb->lastError().display() ;
			return	0 ;
		}
		return	1 ;
	}

	cchar	*getRowValue
		(	cchar	*name,
			uint	qrow
		)
	{
		static QString aQString	  ;
		if (!isValid ()) return 0 ;
		aQString = ((KBBlock *)ptr)->getRowValue (name, qrow).getRawText() ;
		return	aQString ;
	}

	void	setRowValue
		(	cchar	*name,
			uint	qrow,
			cchar	*value
		)
	{
		if (!isValid ()) return ;
		((KBBlock *)ptr)->setRowValue (name, qrow, KBValue(value, &_kbString)) ;
	}

	void	setUserFilter
		(	const char 	*filter
		)
	{
		if (!isValid ()) return ;
		((KBBlock *)ptr)->setUserFilter (filter) ;
	}

	void	setUserSorting
		(	const char	*sorting
		)
	{
		if (!isValid ()) return ;
		((KBBlock *)ptr)->setUserSorting (sorting) ;
	}

	bool	isInQuery ()
	{
		if (!isValid ()) return 0 ;
		KBFormBlock *fb = ((KBBlock *)ptr)->isFormBlock() ;
		return	fb == 0 ? false : fb->isInQuery() ;
	}

	static const int actFirst	= KB::First	;
	static const int actPrevious	= KB::Previous	;
	static const int actNext	= KB::Next	;
	static const int actLast	= KB::Last	;
	static const int actAdd		= KB::Add	;
	static const int actSave	= KB::Save	;
	static const int actDelete	= KB::Delete	;
	static const int actQuery	= KB::Query	;
	static const int actExecute	= KB::Execute	;
	static const int actCancel	= KB::Cancel	;
	static const int actInsert	= KB::Insert	;
	static const int actPrevBack	= KB::PrevBack	;
	static const int actNextForw	= KB::NextForw	;
	static const int actReset	= KB::Reset	;
	static const int actGotoQRow	= KB::GotoQRow	;
	static const int actSyncAll	= KB::SyncAll	;
	static const int actStore	= KB::Store	;
	static const int actPrevPage	= KB::PrevPage	;
	static const int actNextPage	= KB::NextPage	;
	static const int actReload	= KB::Reload	;
	static const int actScroll	= KB::Scroll	;
}	;

#endif	// __KB_PYBLOCK_H
