/***************************************************************************
    file	         : tkc_pyvalue.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#include	"kb_python.h"


#ifndef 	_WIN32
#include	"tkc_pyvalue.moc"
#else
#include 	"tkc_pyvalue.h"
#endif
#include	"tkc_pydebugbase.h"


QPtrDict<TKCPyValue>	TKCPyValue::allValues  ;


/*  TKCPyValue								*/
/*  TKCPyValue	: Constructor for interpreter python value object	*/
/*  pvalue	: PyObject *	: The value object			*/
/*  (returns)	: TKCPyValue	:					*/

TKCPyValue::TKCPyValue
	(	PyObject	*pvalue
	)
	:
	pvalue	(pvalue)
{
	ptype	= TKCPyDebugBase::getPythonType (pvalue) ;
	Py_INCREF (pvalue) ;

	allValues.insert (pvalue, this) ;
//	fprintf	(stderr, "add: %08lx[%4d] %s\n",
//			 (long)pvalue,
//			 pvalue->ob_refcnt,
//			 ptype->simpleVal ?
//				 (const char *)TKCPyDebugBase::getPythonString(pvalue) :
//				 "") ;
}

/*  TKCPyValue								*/
/*  TKCPyValue	: Destructor for interpreter python value object	*/
/*  (returns)	:		:					*/

TKCPyValue::~TKCPyValue ()
{
//	fprintf	(stderr, "rem: %08lx[%4d] %s:%s\n",
//			 (long)pvalue,
//			 pvalue->ob_refcnt,
//			 (const char *)pkey,
//			 ptype->simpleVal ?
//				 (const char *)TKCPyDebugBase::getPythonString(pvalue) :
//				 "") ;

	allValues.remove (pvalue) ;
	Py_DECREF 	 (pvalue) ;
}


/*  The following two methods are used to get a value. These should be	*/
/*  used, rather than directly calling the constructors, so that values	*/
/*  can be shared.							*/

/*  TKCPyValue	:							*/
/*  allocValue	: Get or allocate a value				*/
/*  pvalue	: PyObject *	: The value object			*/
/*  (returns)	: TKCPyValue	:					*/

TKCPyValue
	*TKCPyValue::allocValue
	(	PyObject	*pvalue
	)
{
	TKCPyValue *v ;

	if ((v = allValues.find (pvalue)) != 0)
		v->ref () ;
	else	v = new TKCPyValue (pvalue) ;

	return	v ;
}

