/***************************************************************************
    file	         : driver.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<errno.h>
#include	<unistd.h>

#include	<qfile.h>
#include	<qdom.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_serverinfo.h"



#if		__KB_KDE
#include	<kapp.h>
#include	<klocale.h>
#include	<kaboutdata.h>
#include	<kcmdlineargs.h>
#endif



bool	tableCreate
	(	QDomElement	&tabElem,
		KBServer	*server
	)
{
	for (QDomNode node = tabElem.firstChild	() ;
			     !node  .isNull	() ;
		      node = node   .nextSibling() )
	{
		QDomElement tabElem = node.toElement () ;
		if (tabElem.isNull()) continue ;

		if (tabElem.nodeName() == "table")
		{
			KBTableSpec tabSpec (tabElem)  ;
			if (!server->createTable (tabSpec, false))
			{
				server->lastError().DISPLAY() ;
				return	false	;
			}
		}
	}

	return	true	;
}

bool	tableDrop
	(	QDomElement	&tabElem,
		KBServer	*server
	)
{
	bool	silent	= tabElem.attribute("silent").toInt() ;

	for (QDomNode node = tabElem.firstChild	() ;
			     !node  .isNull	() ;
		      node = node   .nextSibling() )
	{
		QDomElement tabElem = node.toElement () ;
		if (tabElem.isNull()) continue ;

		if (!server->dropTable (tabElem.attribute("name"), false))
			if (!silent)
			{
				server->lastError().DISPLAY() ;
				return	false	;
			}
	}

	return	true	;
}

bool	doSelect
	(	QDomElement	&selElem,
		KBServer	*server
	)
{
	QStringList	exprs	;

	for (QDomNode node = selElem.firstChild	() ;
			     !node  .isNull	() ;
		      node = node   .nextSibling() )
	{
		QDomElement qryElem = node.toElement () ;
		if (qryElem.isNull()) continue ;

		if (qryElem.nodeName() == "expr")
		{
			exprs.append (qryElem.text()) ;
			continue ;
		}
	}

	QString	select	= "" ;

	select	+= "select " + exprs.join(", ") ;
	select	+= " from "  + selElem.attribute ("table") ;

	KBSQLSelect	*query	= server->qrySelect (true, select, false) ;
	if (query == 0)
	{	server->lastError().DISPLAY() ;
		return	false	;
	}

	if (!query->execute (0, 0))
	{	query->lastError().DISPLAY()	;
		return	false	;
	}

	uint	numCols	= query->getNumFields() ;

	printf	("Query returned %d columns\n", numCols) ;

	for (uint c = 0 ; c < numCols ; c += 1)
	{	printf	("\"%s\"", (cchar *)query->getFieldName(c)) ;
		if (c < numCols - 1) printf (",") ;
	}
	printf	("\n")	;

	for (uint r = 0 ; query->rowExists (r) ; r += 1)
	{
		for (uint c = 0 ; c < numCols ; c += 1)
		{
			KBValue	v = query->getField (r, c) ;
			printf	("\"%s\"", (cchar *)v.getRawText()) ;
			if (c < numCols - 1) printf (",") ;
		}

		printf	("\n")	;
	}

	delete	query	;
	return	true	;
}

bool	doInsert
	(	QDomElement	&insElem,
		KBServer	*server
	)
{
	QStringList	exprs	;
	QStringList	place	;

	for (QDomNode node = insElem.firstChild	() ;
			     !node  .isNull	() ;
		      node = node   .nextSibling() )
	{
		QDomElement qryElem = node.toElement () ;
		if (qryElem.isNull()) continue ;

		if (qryElem.nodeName() == "expr")
		{
			exprs .append (qryElem.text()) ;
			place .append ("?") ;
			continue ;
		}
	}

	KBValue	*argv	= new KBValue[exprs.count()] ;
	uint	argc	= 0 ;

	for (QDomNode node = insElem.firstChild	() ;
			     !node  .isNull	() ;
		      node = node   .nextSibling() )
	{
		if (argc >= exprs.count()) break ;

		QDomElement qryElem = node.toElement () ;
		if (qryElem.isNull()) continue ;

		if (qryElem.nodeName() == "value")
		{
			QString	type	= qryElem.attribute ("type") ;

			if	(type == "fixed")
			{
				argv[argc] = KBValue (qryElem.text().toInt   ()) ;
			}
			else if	(type == "float")
			{
				argv[argc] = KBValue (qryElem.text().toDouble()) ;
			}
			else if (type == "datetime")
			{
				argv[argc] = KBValue (qryElem.text(), &_kbDateTime) ;
			}
			else
			{
				argv[argc] = KBValue (qryElem.text()) ;
			}	;

			argc	  += 1 ;
			continue ;
		}
	}

	QString	insert	= "" ;

	insert	+= "insert into " + insElem.attribute ("table") + " (" ;
	insert  += exprs.join (", ") ;
	insert	+= ") values (" ;
	insert	+= place.join (", ") ;
	insert	+= ")" ;

	KBSQLInsert	*query	= server->qryInsert (true, insert, insElem.attribute ("table")) ;
	if (query == 0)
	{	server->lastError().DISPLAY() ;
		delete	[]argv	;
		return	false	;
	}

	if (!query->execute (argc, argv))
	{	query ->lastError().DISPLAY() ;
		delete	[]argv	;
		return	false	;
	}

	KBValue	newKey	;
	if (!query->getNewKey (QString::null, newKey, false))
	{	query ->lastError().DISPLAY() ;
		delete	[]argv	;
		return	false	;
	}

	printf
	(	"Insert key is [%s]\n",
		(cchar *)newKey.getRawText()
	)	;
				
	delete	[]argv	;
	delete	query	;
	return	true	;
}

bool	doUpdate
	(	QDomElement	&insElem,
		KBServer	*server
	)
{
	QStringList	exprs	;
	QStringList	where	;

	for (QDomNode node = insElem.firstChild	() ;
			     !node  .isNull	() ;
		      node = node   .nextSibling() )
	{
		QDomElement qryElem = node.toElement () ;
		if (qryElem.isNull()) continue ;

		if (qryElem.nodeName() == "expr")
		{
			exprs .append (QString("%1 = ?").arg(qryElem.text())) ;
			continue ;
		}
		if (qryElem.nodeName() == "where")
		{
			where .append (qryElem.text()) ;
			continue ;
		}
	}

	KBValue	*argv	= new KBValue[exprs.count()] ;
	uint	argc	= 0 ;

	for (QDomNode node = insElem.firstChild	() ;
			     !node  .isNull	() ;
		      node = node   .nextSibling() )
	{
		if (argc >= exprs.count()) break ;

		QDomElement qryElem = node.toElement () ;
		if (qryElem.isNull()) continue ;

		if (qryElem.nodeName() == "value")
		{
			QString	type	= qryElem.attribute ("type") ;

			if	(type == "fixed")
			{
				argv[argc] = KBValue (qryElem.text().toInt   ()) ;
			}
			else if	(type == "float")
			{
				argv[argc] = KBValue (qryElem.text().toDouble()) ;
			}
			else if (type == "datetime")
			{
				argv[argc] = KBValue (qryElem.text(), &_kbDateTime) ;
			}
			else
			{
				argv[argc] = KBValue (qryElem.text()) ;
			}	;

			argc	  += 1 ;
			continue ;
		}
	}

	QString	update	= "" ;

	update	+= "update " + insElem.attribute ("table") + " set " ;
	update  += exprs.join (", ") ;

	if (where.count() > 0)
	{
		update	+= " where " ;
		update	+= where.join (" and ") ;
	}

	KBSQLUpdate	*query	= server->qryUpdate (true, update, insElem.attribute ("table")) ;
	if (query == 0)
	{	server->lastError().DISPLAY() ;
		delete	[]argv	;
		return	false	;
	}

	if (!query->execute (argc, argv))
	{	query ->lastError().DISPLAY() ;
		delete	[]argv	;
		return	false	;
	}

	delete	[]argv	;
	delete	query	;
	return	true	;
}

bool	doCursor
	(	QDomElement	&curElem,
		KBServer	*server
	)
{
	QStringList	exprs	;

	for (QDomNode node = curElem.firstChild	() ;
			     !node  .isNull	() ;
		      node = node   .nextSibling() )
	{
		QDomElement qryElem = node.toElement () ;
		if (qryElem.isNull()) continue ;

		if (qryElem.nodeName() == "expr")
		{
			exprs.append (qryElem.text()) ;
			continue ;
		}
	}

	QString	name	= curElem.attribute("name") ;
	QString	query	= "" ;
	query	+= "select " + exprs.join(", ") ;
	query	+= " from "  + curElem.attribute ("table") ;

	if (!server->transaction (KBServer::BeginTransaction, 0))
	{	server->lastError().DISPLAY() ;
		return	false	;
	}

	KBSQLCursor	*cursor	= server->qryCursor (true, query, name) ;
	if (cursor == 0)
	{	server->lastError().DISPLAY() ;
		return	false	;
	}

	if (!cursor->execute (0, 0))
	{	cursor->lastError().DISPLAY()	;
		delete	cursor	;
		return	false	;
	}

//	uint	numCols	= query->getNumFields() ;
//
//	printf	("Query returned %d columns\n", numCols) ;
//
//	for (uint c = 0 ; c < numCols ; c += 1)
//	{	printf	("\"%s\"", (cchar *)query->getFieldName(c)) ;
//		if (c < numCols - 1) printf (",") ;
//	}
//	printf	("\n")	;

	bool	rc	;
	bool	got	;
	KBValue	values	[100] ;

	while (rc = cursor->fetch (100, values, got), rc && got)
	{
unsigned int numCols = 2 ;
		for (uint c = 0 ; c < numCols ; c += 1)
		{
			printf	("\"%s\"", (cchar *)values[c].getRawText()) ;
			if (c < numCols - 1) printf (",") ;
		}

		printf	("\n")	;
	}

	if (!rc)
	{	cursor->lastError().DISPLAY()	;
		delete	cursor	;
		return	false	;
	}

	if (!server->transaction (KBServer::CommitTransaction, 0))
	{	server->lastError().DISPLAY() ;
		delete	cursor	;
		return	false	;
	}

	cursor->close()	;
	delete	cursor	;
	return	true	;
}

bool	doDescribe
	(	QDomElement	&descElem,
		KBServer	*server
	)
{
	QString		tabName	= descElem.attribute ("table") ;
	KBTableSpec	tabSpec	(tabName) ;

	if (!server->listFields (tabSpec))
	{	server->lastError().DISPLAY() ;
		return	false	;
	}

	for (uint idx = 0 ; idx < tabSpec.m_fldList.count() ; idx += 1)
	{
		KBFieldSpec *fSpec = tabSpec.m_fldList.at(idx) ;

		printf
		(	"%3u: %-16s: %3u %-12s %3d (%12d,%4d) %c%c%c%c%c%c%c : %s\n",
			idx,
			(cchar *)fSpec->m_name,
			fSpec->m_colno,
			(cchar *)fSpec->m_typeName,
			fSpec->m_typeIntl,
			fSpec->m_length,
			fSpec->m_prec,
			(fSpec->m_flags & KBFieldSpec::Primary ) != 0 ? 'P' : ' ',
			(fSpec->m_flags & KBFieldSpec::NotNull ) != 0 ? 'N' : ' ',
			(fSpec->m_flags & KBFieldSpec::Unique  ) != 0 ? 'U' : ' ',
			(fSpec->m_flags & KBFieldSpec::Serial  ) != 0 ? 'S' : ' ',
			(fSpec->m_flags & KBFieldSpec::Indexed ) != 0 ? 'I' : ' ',
			(fSpec->m_flags & KBFieldSpec::ReadOnly) != 0 ? 'R' : ' ',
			(fSpec->m_flags & KBFieldSpec::InsAvail) != 0 ? 'A' : ' ',
			(cchar *)fSpec->m_defval
		)	;
	}

	return	true	;
}

bool	doMapExpr
	(	QDomElement	&mapElem,
		KBServer	*server
	)
{
	QString		expr	= mapElem.attribute("expr") ;
	QString		mapped	= server->doMapExpression (expr, "[", "]", QString::null) ;

	printf
	(	"mapExpr: <%s> -> <%s>\n",
		(cchar *)expr,
		(cchar *)mapped
	)	;
	return	true	;
}

bool	serverTest
	(	QDomElement	svrElem,
		KBServer	*server
	)
{
	for (QDomNode node = svrElem.firstChild	() ;
			     !node  .isNull	() ;
		      node = node   .nextSibling() )
	{
		QDomElement elem = node.toElement () ;
		if (elem.isNull()) continue ;

		if (elem.nodeName() == "tableCreate")
		{
			if (!tableCreate (elem, server)) return false ;
			continue    ;
		}
		if (elem.nodeName() == "tableDrop")
		{
			if (!tableDrop   (elem, server)) return false ;
			continue    ;
		}
		if (elem.nodeName() == "doSelect")
		{
			if (!doSelect    (elem, server)) return false ;
			continue    ;
		}
		if (elem.nodeName() == "doInsert")
		{
			if (!doInsert    (elem, server)) return false ;
			continue    ;
		}
		if (elem.nodeName() == "doUpdate")
		{
			if (!doUpdate    (elem, server)) return false ;
			continue    ;
		}
		if (elem.nodeName() == "doCursor")
		{
			if (!doCursor    (elem, server)) return false ;
			continue    ;
		}
		if (elem.nodeName() == "describe")
		{
			if (!doDescribe  (elem, server)) return false ;
			continue ;
		}
		if (elem.nodeName() == "mapExpr")
		{
			if (!doMapExpr   (elem, server)) return false ;
			continue ;
		}
	}

	return	true	;
}

bool	xmlTest
	(	const QString	&xmlName
	)
{
	QFile	xmlFile	(xmlName) ;
	if (!xmlFile.open (IO_ReadOnly))
	{
		fprintf	(stderr, "xmlFile: %s: %s\n", (cchar *)xmlName, strerror(errno)) ;
		return	false	;
	}

	QDomDocument doc	;
	if (!doc.setContent (&xmlFile))
	{
		fprintf	(stderr, "xmlFile: %s: cannot parse\n", (cchar *)xmlName) ;
		return	false	;
	}

	QDomElement  docElem	= doc.documentElement() ;
	for (QDomNode node = docElem.firstChild	() ;
			     !node  .isNull	() ;
		      node = node   .nextSibling() )
	{
		QDomElement elem = node.toElement () ;
		if (elem.isNull()) continue ;

		if (elem.nodeName() == "serverinfo")
		{
			KBServerInfo	svInfo (0, elem) ;
			KBError	 	error 	;
			KBServer 	*server = svInfo.getServer (error) ;

			if (server == 0)
			{
				error.DISPLAY() ;
				return	false ;
			}

			serverTest (elem, server) ;
			continue   ;
		}
	}

	return	true	;
}


int	main
	(	int	argc,
		char	*argv[]
	)
{
#if	__KB_KDE
	char *dummy[2]	;

	dummy[0] = (char *)"driver" ;
	dummy[1] = 0	;

	KAboutData about ("rekall",
			  I18N_NOOP("RekallDriverTest"),
			  "0.0.0",
			  I18N_NOOP("Rekall: Driver test harness"),
			  KAboutData::License_Unknown,
			  "(c) 2000,2001,2002 by theKompany.com",
			  0,
			  "http://www.rekall.a-i-s.co.uk",
			  "mike@quaking.demon.co.uk"
			 ) ;
	about.addAuthor  ("Mike Richardson", 0, "mike@quaking.demon.co.uk") ; 
	about.addAuthor  ("John Dean", 	     0, "john@rygannon.com") ; 

	KCmdLineArgs::init (2, dummy, &about) ;

	KApplication	app	;
#endif

	KBError		error	;

	if (argc != 2)
	{
		fprintf	(stderr, "usage: driver xmlfile\n") ;
		exit	(1) ;
	}

//	fprintf	(stderr, "sizeof(QByteArray) : %d\n", sizeof(QByteArray)) ;
//	fprintf	(stderr, "sizeof(KBValue   ) : %d\n", sizeof(KBValue   )) ;
//	fprintf	(stderr, "sizeof(KBRowSet  ) : %d\n", sizeof(KBRowSet  )) ;

	if (!xmlTest (argv[1]))
	{	fprintf	(stderr, "Driver test exiting: failed\n") ;
		_exit	(1) ;
	}

	fprintf	(stderr, "Driver test exiting\n") ;
	_exit	(0) ;
}
