DEFAULT_DATA_PATH = ".releaseforge"

RELEASEFORGE_CONFIG_FILENAME = "releaseforge.cfg"
PROJECTS_FILENAME = "projects"
FM_PROJECTS_FILENAME = "projects.fm"
LOGIN_FILENAME = "login"
SF_COOKIE_FILENAME = 'cookies.sf'
FM_XMLRPC = "http://freshmeat.net/xmlrpc/"

LOGGER_CONFIG_FILENAME = "logger.ini"

SF_FTP_SERVER = "upload.sourceforge.net"
SF_FTP_DIRECTORY = "incoming"

# custom event ids
EVENT_LOGIN            = 10000
EVENT_STATUS           = 10001
EVENT_UPDATE_PROJECT   = 10002
EVENT_ADD_PACKAGE      = 10003
EVENT_UPDATE_PACKAGE   = 10004
EVENT_REFRESH_PACKAGES = 10005
EVENT_CREATE_RELEASE   = 10006
EVENT_UPLOAD_FILES     = 10007
EVENT_EDIT_RELEASE_1   = 10008
EVENT_EDIT_RELEASE_2   = 10009
EVENT_EDIT_RELEASE_3   = 10010
EVENT_EDIT_RELEASE_4   = 10011
EVENT_GET_RELEASES     = 10012
EVENT_RELEASE_FETCHED  = 10013
EVENT_DELETE_FILES     = 10014
EVENT_NEWS_SUBMITTED   = 10015

# page numbers of the releaseWizard
WIZARD_PAGE_EDIT_RELEASE = 0
WIZARD_PAGE_RELEASE_NAME = 1
WIZARD_PAGE_FILE_SELECTION = 2
WIZARD_PAGE_PROGRESS = 3

WIZARD_HELP_PAGES = {
    WIZARD_PAGE_EDIT_RELEASE: ('', 'edit_release.html'), 
    WIZARD_PAGE_RELEASE_NAME: ('new_release.html', 'edit_release_details.html'),
    WIZARD_PAGE_FILE_SELECTION: ('file_selection.html', 'edit_release_files.html'),
    WIZARD_PAGE_PROGRESS: ('progress.html', 'progress.html')
    }

# mappings of processor to their SF id's
CPU = {'i386': '1000',
       'IA64': '6000',
       'Alpha': '7000',
       'Any': '8000',
       'PPC': '2000',
       'MIPS': '3000',
       'Sparc': '4000',
       'UltraSparc': '5000',
       'Other': '9999',
       'Platform-Independent': '8500',
       'ARM': '3001',
       'SH3': '3002',
       'AMD64': '6001',
       'PPC64': '2001'}

# mappings of file type names to their SF id's
FILE_TYPE = {
    '.deb': '1000',
    '.rpm': '2000',
    '.zip': '3000',
    '.bz2': '3001',
    '.gz': '3002',
    'Source .zip': '5000',
    'Source .bz2': '5001',
    'Source .gz': '5002',
    'Source .rpm': '5100',
    'Other Source File': '5900',
    '.jpg': '8000',
    'text': '8001',
    'html': '8002',
    'pdf': '8003',
    'Other': '9999',
    '.sit': '3003',
    '.nbz': '3004',
    '.exe (DOS)': '2500',
    '.exe (16-bit Windows)': '2501',
    '.exe (32-bit Windows)': '2502',
    '.exe (OS/2)': '2600',
    '.dmg': '3005',    
    '.jar': '2601',    
    'Source Patch/Diff': '5901',    
    '.prc (PalmOS)': '2700',    
    '.iso': '3006',
    'Source .Z': '5003',
    '.bin (MacBinary)': '2650',
    '.ps (PostScript)': '8004',
    '.msi (Windows Installer)': '2503',
    'Other Binary Package': '4000'
    }

# mappings of guessing file extentions to their names (in the previous hash)
FILE_TYPE_GUESS = {
    '.deb': '.deb',
    '.rpm': '.rpm',
    '.zip': '.zip',
    '.bz2': '.bz2',
    '.bz': '.bz2',
    '.gz': '.gz',
    '.tgz': '.gz',
    '.tar.gz': '.gz',
    '.src.zip': 'Source .zip',
    '.src.bz2': 'Source .bz2',
    '.src.bz': 'Source .bz2',
    '.src.tar.gz': 'Source .gz',
    '.src.tgz': 'Source .gz',
    '.src.rpm': 'Source .rpm',
    '.jpeg': '.jpg',
    '.jpg': '.jpg',
    '.text': 'text',
    '.txt': 'text',
    '.html': 'html',
    '.htm': 'html',
    '.pdf': 'pdf',
    '.sit': '.sit',
    '.nbz': '.nbz',
    '.exe': '.exe (32-bit Windows)',
    '.win32.exe': '.exe (32-bit Windows)',
    '.win16.exe': '.exe (16-bit Windows)',
    '.dos.exe': '.exe (DOS)',
    '.os2.exe': '.exe (OS/2)',
    '.dmg': '.dmg',    
    '.jar': '.jar',
    '.diff': 'Source Patch/Diff',
    '.prc': '.prc (PalmOS)',
    '.iso': '.iso',
    '.Z': 'Source .Z',
    '.bin': '.bin (MacBinary)',
    '.ps': '.ps (PostScript)',
    '.msi': '.msi (Windows Installer)'
    }
