from constants import *
def getFileTypeComboData(filename):
    parts = filename.split(".")

    lparts = len(parts)
    if lparts == 1:
        exts = []
    elif lparts == 2:
        exts = [".%s" % parts[1]]
    else:
        exts = [".%s.%s" % (parts[-2], parts[-1]), ".%s" % parts[-1]]

    guess = None
    for ext in exts:
        guess = FILE_TYPE_GUESS.get(ext)
        if guess: break
    print guess

getFileTypeComboData("test.zip")
getFileTypeComboData("test.rpm")
getFileTypeComboData("test.zip")
getFileTypeComboData("test.src.zip")
getFileTypeComboData("testing.of.src.zip")
getFileTypeComboData("test.src.rpm")
getFileTypeComboData("test.jpg")
getFileTypeComboData("test.huh")
