from qt import *
from freshmeatProjectChooserBA import FreshmeatProjectChooserBA
from messageQueue import mainMessageQueue

CHOOSE = "Choose..."

class FreshmeatProjectChooser(FreshmeatProjectChooserBA):
    def __init__(self, parent, sf_projectname, fm_project_vos):
        FreshmeatProjectChooserBA.__init__(self, parent)
        self.parent = parent
        self.fm_project_vos = fm_project_vos
        self.sfProjectNameTextLabel.setText(sf_projectname)
        
        self.populateCombo(fm_project_vos)
        self.selected_project_vo = None
        self.show()


    def populateCombo(self, vos):
        self.fmProjectComboBox.insertItem(CHOOSE)
        for vo in vos:
            self.fmProjectComboBox.insertItem(vo.getProjectName())

        
    def accept(self):
        s = str(self.fmProjectComboBox.currentText())
        emitted = False
        if s != CHOOSE:
            for vo in self.fm_project_vos:
                if vo.getProjectName() == s:
                    self.parent.emit(PYSIGNAL("fm_release_project_selected()"), (vo, ))
                    emitted = True
                    break
            
        if not emitted:
            mainMessageQueue.put("Freshmeat release operation cancelled")

        FreshmeatProjectChooserBA.accept(self)


        
