.buildReposToolsOpts <- function(OST) {
    if (is.null(getOption("BioC"))) {
        BioC <- list()
        class(BioC) <- "BioCOptions"
        options("BioC"=BioC)
    }
    ReposEntry <- list()
    class(ReposEntry) <- "BioCPkg"

    ## Set the default download type
    if (OST == "windows")
        ReposEntry$type <- "Win32"
    else
        ReposEntry$type <- "Source"

    BioC <- getOption("BioC")
    BioC$reposEntry <- ReposEntry
    options("BioC"=BioC)

    ## Set up the repositories2 option
    if (!("CRAN" %in% names(getOption("repositories2")))) {
        bioCOpt <- "http://www.bioconductor.org/CRANrepository"
        names(bioCOpt) <- "CRAN"
        options("repositories2"=c(getOption("repositories2"),bioCOpt))
    }

    if (!("BIOCRel1.7" %in% names(getOption("repositories2")))) {
        bioROpt <- "http://www.bioconductor.org/packages/bioc/1.7"
        names(bioROpt) <- "BIOCRel1.7"
        options("repositories2"=c(getOption("repositories2"),bioROpt))
    }

    if (!("BIOCData" %in% names(getOption("repositories2")))) {
        bioDaDopt <- "http://www.bioconductor.org/packages/data/annotation/1.7"
        names(bioDaDopt) <- "BIOCData"
        options("repositories2"=c(getOption("repositories2"),
        bioDaDopt))
    }

    if (!("BIOCExdata" %in% names(getOption("repositories2")))) {
        bioCexpr <- "http://www.bioconductor.org/packages/data/experiment/1.7"
        names(bioCexpr) <- "BIOCExdata"
        options("repositories2"=c(getOption("repositories2"),
                bioCexpr))
    }
    if (!("BIOCCourses" %in% names(getOption("repositories2")))) {
        bioCCourse <- "http://www.bioconductor.org/repository/Courses"
        names(bioCCourse) <- "BIOCCourses"
        options("repositories2"=c(getOption("repositories2"),
                bioCCourse))
    }
    if (!("BIOCcdf" %in% names(getOption("repositories2")))) {
        bioCcdf <- "http://www.bioconductor.org/packages/data/annotation/1.7"
        names(bioCcdf) <- "BIOCcdf"
        options("repositories2"=c(getOption("repositories2"),
                bioCcdf))
    }
    if (!("BIOCprobes" %in% names(getOption("repositories2")))) {
        bioCProbe <- "http://www.bioconductor.org/packages/data/annotation/1.7"
        names(bioCProbe) <- "BIOCprobes"
        options("repositories2"=c(getOption("repositories2"),
                bioCProbe))
    }
    if (!("BIOCOmegahat" %in% names(getOption("repositories2")))) {
        bioCOmegahat <-
        "http://www.bioconductor.org/packages/omegahat/1.7"
        names(bioCOmegahat) <- "BIOCOmegahat"
        options("repositories2"=c(getOption("repositories2"),
                bioCOmegahat))
    }

    if (!("BIOCLinds" %in% names(getOption("repositories2")))) {
        bioClindsey <-
        "http://www.bioconductor.org/packages/lindsey/1.7"
        names(bioClindsey) <- "BIOCLinds"
        options("repositories2"=c(getOption("repositories2"),
                bioClindsey))
    }

}

.First.lib <- function(libname, pkgname) {
    ##.initComparisonMethods()
    OST <- .Platform$OS.type
    .buildReposToolsOpts(OST)
}

