\name{getDependings}
\alias{getDependings}
\title{A function to retrieve which packages depend on which}
\description{
This function is used to list which packages are depending on other
packages within a CRAN style repository.
}
\usage{
getDependings(repository, depLevel = c("Depends", "Suggests"), method="auto")
}
\arguments{
  \item{repository}{The URL of a \code{CRAN} style repository}
  \item{depLevel}{Which dependency level to be using}
  \item{method}{Download method to use.  Same as in \code{\link{download.file}}.}
}
\value{
  A list with an element for every package in the repository.  If a
  particular package is not depended on by anything, then the value of
  that element will be NULL, otherwise a character vector of every
  package depending on it will be present.
}
\author{Jeff Gentry}
\seealso{\code{\link{CRAN.packages}}}
\examples{
z <- getDependings(contrib.url("http://bioconductor.org"))
}
\keyword{utilities}

