#! /usr/bin/env perl

# Test package that computes default database settings:

use strict;
use warnings;
use utf8;
use Data::Dumper;

use lib 'lib';
use Database::ForeignKey;
use Database::View;

binmode( STDOUT, "utf8" );

$Data::Dumper::Sortkeys = 1;
$Data::Dumper::Indent   = 1;

do { # Simple example with three islands
    my @parts = (
        { table_from => 'J', table_to => 'K' },
        { table_from => 'A', table_to => 'B' },
        { table_from => 'C', table_to => 'D' },
        { table_from => 'G', table_to => 'H' },
        { table_from => 'H', table_to => 'I' },
        { table_from => 'B', table_to => 'C' },
        { table_from => 'D', table_to => 'E' },
    );
    my @fks = map { Database::ForeignKey->new( $_ ) } @parts;

    print Dumper [ Database::View::_sort_fk( @fks ) ];
    print Dumper [ Database::View::_locate_parent_tables( @fks ) ];
};
do { # A tree
    my @parts = (
        { table_from => 'A', table_to => 'B' },
        { table_from => 'B', table_to => 'C' },
        { table_from => 'B', table_to => 'D' },
        { table_from => 'D', table_to => 'E' },
    );
    my @fks = map { Database::ForeignKey->new( $_ ) } @parts;

    print Dumper [ Database::View::_sort_fk( @fks ) ];
    print Dumper [ Database::View::_locate_parent_tables( @fks ) ];
};
