/* mouse.c generated by valac 0.35.5, the Vala compiler
 * generated from mouse.vala, do not modify */

/* This file is part of retro-gtk. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <string.h>


#define RETRO_TYPE_MOTION_PARSER (retro_motion_parser_get_type ())
#define RETRO_MOTION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_MOTION_PARSER, RetroMotionParser))
#define RETRO_MOTION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_MOTION_PARSER, RetroMotionParserClass))
#define RETRO_IS_MOTION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_MOTION_PARSER))
#define RETRO_IS_MOTION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_MOTION_PARSER))
#define RETRO_MOTION_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_MOTION_PARSER, RetroMotionParserClass))

typedef struct _RetroMotionParser RetroMotionParser;
typedef struct _RetroMotionParserClass RetroMotionParserClass;
typedef struct _RetroMotionParserPrivate RetroMotionParserPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RETRO_TYPE_INPUT_DEVICE (retro_input_device_get_type ())
#define RETRO_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_INPUT_DEVICE, RetroInputDevice))
#define RETRO_IS_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_INPUT_DEVICE))
#define RETRO_INPUT_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_INPUT_DEVICE, RetroInputDeviceIface))

typedef struct _RetroInputDevice RetroInputDevice;
typedef struct _RetroInputDeviceIface RetroInputDeviceIface;

#define RETRO_TYPE_DEVICE_TYPE (retro_device_type_get_type ())

#define RETRO_TYPE_MOUSE (retro_mouse_get_type ())
#define RETRO_MOUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_MOUSE, RetroMouse))
#define RETRO_MOUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_MOUSE, RetroMouseClass))
#define RETRO_IS_MOUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_MOUSE))
#define RETRO_IS_MOUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_MOUSE))
#define RETRO_MOUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_MOUSE, RetroMouseClass))

typedef struct _RetroMouse RetroMouse;
typedef struct _RetroMouseClass RetroMouseClass;
typedef struct _RetroMousePrivate RetroMousePrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define RETRO_TYPE_MOUSE_ID (retro_mouse_id_get_type ())
typedef struct _Block1Data Block1Data;
enum  {
	RETRO_MOUSE_UNGRAB_SIGNAL,
	RETRO_MOUSE_LAST_SIGNAL
};
static guint retro_mouse_signals[RETRO_MOUSE_LAST_SIGNAL] = {0};

struct _RetroMotionParser {
	GObject parent_instance;
	RetroMotionParserPrivate * priv;
};

struct _RetroMotionParserClass {
	GObjectClass parent_class;
};

struct _RetroMotionParserPrivate {
	GdkScreen* screen;
	gboolean _grab_pointer;
	gint x_last;
	gint y_last;
};

typedef enum  {
	RETRO_DEVICE_TYPE_TYPE_MASK = 0xff,
	RETRO_DEVICE_TYPE_NONE = 0,
	RETRO_DEVICE_TYPE_JOYPAD = 1,
	RETRO_DEVICE_TYPE_MOUSE = 2,
	RETRO_DEVICE_TYPE_KEYBOARD = 3,
	RETRO_DEVICE_TYPE_LIGHTGUN = 4,
	RETRO_DEVICE_TYPE_ANALOG = 5,
	RETRO_DEVICE_TYPE_POINTER = 6
} RetroDeviceType;

struct _RetroInputDeviceIface {
	GTypeInterface parent_iface;
	void (*poll) (RetroInputDevice* self);
	gint16 (*get_input_state) (RetroInputDevice* self, RetroDeviceType device, guint index, guint id);
	RetroDeviceType (*get_device_type) (RetroInputDevice* self);
	guint64 (*get_device_capabilities) (RetroInputDevice* self);
};

struct _RetroMouse {
	GObject parent_instance;
	RetroMousePrivate * priv;
};

struct _RetroMouseClass {
	GObjectClass parent_class;
};

struct _RetroMousePrivate {
	GtkWidget* _widget;
	GHashTable* button_state;
	RetroMotionParser* parser;
	gint16 x_delta;
	gint16 y_delta;
	gulong ungrab_id;
};

typedef enum  {
	RETRO_MOUSE_ID_X,
	RETRO_MOUSE_ID_Y,
	RETRO_MOUSE_ID_LEFT,
	RETRO_MOUSE_ID_RIGHT,
	RETRO_MOUSE_ID_WHEELUP,
	RETRO_MOUSE_ID_WHEELDOWN,
	RETRO_MOUSE_ID_MIDDLE,
	RETRO_MOUSE_ID_HORIZ_WHEELUP,
	RETRO_MOUSE_ID_HORIZ_WHEELDOWN
} RetroMouseId;

struct _Block1Data {
	int _ref_count_;
	RetroMouse* self;
	GdkScreen* screen;
	gint x;
	gint y;
	GdkDevice* device;
};


static gpointer retro_motion_parser_parent_class = NULL;
static gpointer retro_mouse_parent_class = NULL;
static RetroInputDeviceIface * retro_mouse_retro_input_device_parent_iface = NULL;

GType retro_motion_parser_get_type (void) G_GNUC_CONST;
#define RETRO_MOTION_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RETRO_TYPE_MOTION_PARSER, RetroMotionParserPrivate))
enum  {
	RETRO_MOTION_PARSER_DUMMY_PROPERTY,
	RETRO_MOTION_PARSER_GRAB_POINTER
};
gboolean retro_motion_parser_parse_event (RetroMotionParser* self, GdkEventMotion* event, gint* x_movement, gint* y_movement);
gboolean retro_motion_parser_get_grab_pointer (RetroMotionParser* self);
RetroMotionParser* retro_motion_parser_new (void);
RetroMotionParser* retro_motion_parser_construct (GType object_type);
void retro_motion_parser_set_grab_pointer (RetroMotionParser* self, gboolean value);
static void retro_motion_parser_finalize (GObject * obj);
static void _vala_retro_motion_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_retro_motion_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType retro_device_type_get_type (void) G_GNUC_CONST;
GType retro_input_device_get_type (void) G_GNUC_CONST;
GType retro_mouse_get_type (void) G_GNUC_CONST;
#define RETRO_MOUSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RETRO_TYPE_MOUSE, RetroMousePrivate))
enum  {
	RETRO_MOUSE_DUMMY_PROPERTY,
	RETRO_MOUSE_WIDGET,
	RETRO_MOUSE_PARSE
};
RetroMouse* retro_mouse_new (GtkWidget* widget);
RetroMouse* retro_mouse_construct (GType object_type, GtkWidget* widget);
static void retro_mouse_real_poll (RetroInputDevice* base);
static gint16 retro_mouse_real_get_input_state (RetroInputDevice* base, RetroDeviceType device, guint index, guint id);
GType retro_mouse_id_get_type (void) G_GNUC_CONST;
gboolean retro_mouse_get_button_state (RetroMouse* self, guint button);
static RetroDeviceType retro_mouse_real_get_device_type (RetroInputDevice* base);
static guint64 retro_mouse_real_get_device_capabilities (RetroInputDevice* base);
static gboolean retro_mouse_on_button_press_event (RetroMouse* self, GtkWidget* source, GdkEventButton* event);
gboolean retro_mouse_get_parse (RetroMouse* self);
static void retro_mouse_grab (RetroMouse* self, GdkDevice* device, GdkWindow* window, guint32 time);
static guint* _uint_dup (guint* self);
static gboolean* _bool_dup (gboolean* self);
static gboolean retro_mouse_on_button_release_event (RetroMouse* self, GtkWidget* source, GdkEventButton* event);
static gboolean retro_mouse_on_motion_notify_event (RetroMouse* self, GtkWidget* source, GdkEventMotion* event);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void retro_mouse_set_parse (RetroMouse* self, gboolean value);
static void __lambda10_ (Block1Data* _data1_, guint32 time);
static void ___lambda10__retro_mouse_ungrab (RetroMouse* _sender, guint32 time, gpointer self);
GtkWidget* retro_mouse_get_widget (RetroMouse* self);
static void retro_mouse_set_widget (RetroMouse* self, GtkWidget* value);
static GObject * retro_mouse_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _retro_mouse_on_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _retro_mouse_on_motion_notify_event_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
static gboolean _retro_mouse___lambda11_ (RetroMouse* self, GtkWidget* w, GdkEventFocus* e);
static gboolean __retro_mouse___lambda11__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean _retro_mouse___lambda12_ (RetroMouse* self, GtkWidget* w, GdkEventKey* e);
static gboolean __retro_mouse___lambda12__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean _retro_mouse_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _g_free0_ (gpointer var);
static void retro_mouse_finalize (GObject * obj);
static void _vala_retro_mouse_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_retro_mouse_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean retro_motion_parser_parse_event (RetroMotionParser* self, GdkEventMotion* event, gint* x_movement, gint* y_movement) {
	gint _vala_x_movement = 0;
	gint _vala_y_movement = 0;
	gboolean result = FALSE;
	GdkDevice* device;
	GdkEventMotion* _tmp0_;
	GdkDevice* _tmp1_;
	GdkDevice* _tmp2_;
	GdkScreen* s = NULL;
	gint x = 0;
	gint y = 0;
	GdkDevice* _tmp3_;
	GdkScreen* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GdkScreen* _tmp7_;
	gint x_center;
	GdkScreen* _tmp8_;
	gint _tmp9_;
	gint y_center;
	GdkScreen* _tmp10_;
	gint _tmp11_;
	GdkScreen* _tmp12_;
	GdkScreen* _tmp13_;
	GdkScreen* _tmp27_;
	GdkScreen* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gboolean _tmp33_ = FALSE;
	gint _tmp34_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->device;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	device = _tmp2_;
	_tmp3_ = device;
	gdk_device_get_position (_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	_g_object_unref0 (s);
	_tmp7_ = _g_object_ref0 (_tmp4_);
	s = _tmp7_;
	x = _tmp5_;
	y = _tmp6_;
	_tmp8_ = s;
	_tmp9_ = gdk_screen_get_width (_tmp8_);
	x_center = _tmp9_ / 2;
	_tmp10_ = s;
	_tmp11_ = gdk_screen_get_height (_tmp10_);
	y_center = _tmp11_ / 2;
	_tmp12_ = s;
	_tmp13_ = self->priv->screen;
	if (_tmp12_ != _tmp13_) {
		GdkScreen* _tmp14_;
		GdkScreen* _tmp15_;
		gint _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp14_ = s;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_g_object_unref0 (self->priv->screen);
		self->priv->screen = _tmp15_;
		_vala_y_movement = 0;
		_tmp16_ = _vala_y_movement;
		_vala_x_movement = _tmp16_;
		_tmp17_ = retro_motion_parser_get_grab_pointer (self);
		_tmp18_ = _tmp17_;
		if (_tmp18_) {
			GdkDevice* _tmp19_;
			GdkScreen* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			_tmp19_ = device;
			_tmp20_ = s;
			_tmp21_ = x_center;
			_tmp22_ = y_center;
			gdk_device_warp (_tmp19_, _tmp20_, _tmp21_, _tmp22_);
			_tmp23_ = x_center;
			self->priv->x_last = _tmp23_;
			_tmp24_ = y_center;
			self->priv->y_last = _tmp24_;
		} else {
			gint _tmp25_;
			gint _tmp26_;
			_tmp25_ = x;
			self->priv->x_last = _tmp25_;
			_tmp26_ = y;
			self->priv->y_last = _tmp26_;
		}
		result = FALSE;
		_g_object_unref0 (s);
		_g_object_unref0 (device);
		if (x_movement) {
			*x_movement = _vala_x_movement;
		}
		if (y_movement) {
			*y_movement = _vala_y_movement;
		}
		return result;
	}
	_tmp27_ = s;
	_tmp28_ = _g_object_ref0 (_tmp27_);
	_g_object_unref0 (self->priv->screen);
	self->priv->screen = _tmp28_;
	_tmp29_ = x;
	_tmp30_ = self->priv->x_last;
	_vala_x_movement = _tmp29_ - _tmp30_;
	_tmp31_ = y;
	_tmp32_ = self->priv->y_last;
	_vala_y_movement = _tmp31_ - _tmp32_;
	_tmp34_ = _vala_x_movement;
	if (_tmp34_ == 0) {
		gint _tmp35_;
		_tmp35_ = _vala_y_movement;
		_tmp33_ = _tmp35_ == 0;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		result = FALSE;
		_g_object_unref0 (s);
		_g_object_unref0 (device);
		if (x_movement) {
			*x_movement = _vala_x_movement;
		}
		if (y_movement) {
			*y_movement = _vala_y_movement;
		}
		return result;
	}
	_tmp36_ = retro_motion_parser_get_grab_pointer (self);
	_tmp37_ = _tmp36_;
	if (_tmp37_) {
		GdkDevice* _tmp38_;
		GdkScreen* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		_tmp38_ = device;
		_tmp39_ = s;
		_tmp40_ = x_center;
		_tmp41_ = y_center;
		gdk_device_warp (_tmp38_, _tmp39_, _tmp40_, _tmp41_);
		_tmp42_ = x_center;
		self->priv->x_last = _tmp42_;
		_tmp43_ = y_center;
		self->priv->y_last = _tmp43_;
	} else {
		gint _tmp44_;
		gint _tmp45_;
		_tmp44_ = x;
		self->priv->x_last = _tmp44_;
		_tmp45_ = y;
		self->priv->y_last = _tmp45_;
	}
	result = TRUE;
	_g_object_unref0 (s);
	_g_object_unref0 (device);
	if (x_movement) {
		*x_movement = _vala_x_movement;
	}
	if (y_movement) {
		*y_movement = _vala_y_movement;
	}
	return result;
}


RetroMotionParser* retro_motion_parser_construct (GType object_type) {
	RetroMotionParser * self = NULL;
	self = (RetroMotionParser*) g_object_new (object_type, NULL);
	return self;
}


RetroMotionParser* retro_motion_parser_new (void) {
	return retro_motion_parser_construct (RETRO_TYPE_MOTION_PARSER);
}


gboolean retro_motion_parser_get_grab_pointer (RetroMotionParser* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_grab_pointer;
	result = _tmp0_;
	return result;
}


void retro_motion_parser_set_grab_pointer (RetroMotionParser* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (retro_motion_parser_get_grab_pointer (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_grab_pointer = _tmp0_;
		_g_object_unref0 (self->priv->screen);
		self->priv->screen = NULL;
		g_object_notify ((GObject *) self, "grab-pointer");
	}
}


static void retro_motion_parser_class_init (RetroMotionParserClass * klass) {
	retro_motion_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RetroMotionParserPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_retro_motion_parser_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_retro_motion_parser_set_property;
	G_OBJECT_CLASS (klass)->finalize = retro_motion_parser_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MOTION_PARSER_GRAB_POINTER, g_param_spec_boolean ("grab-pointer", "grab-pointer", "grab-pointer", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void retro_motion_parser_instance_init (RetroMotionParser * self) {
	self->priv = RETRO_MOTION_PARSER_GET_PRIVATE (self);
}


static void retro_motion_parser_finalize (GObject * obj) {
	RetroMotionParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_MOTION_PARSER, RetroMotionParser);
	_g_object_unref0 (self->priv->screen);
	G_OBJECT_CLASS (retro_motion_parser_parent_class)->finalize (obj);
}


GType retro_motion_parser_get_type (void) {
	static volatile gsize retro_motion_parser_type_id__volatile = 0;
	if (g_once_init_enter (&retro_motion_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroMotionParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) retro_motion_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RetroMotionParser), 0, (GInstanceInitFunc) retro_motion_parser_instance_init, NULL };
		GType retro_motion_parser_type_id;
		retro_motion_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "RetroMotionParser", &g_define_type_info, 0);
		g_once_init_leave (&retro_motion_parser_type_id__volatile, retro_motion_parser_type_id);
	}
	return retro_motion_parser_type_id__volatile;
}


static void _vala_retro_motion_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RetroMotionParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_MOTION_PARSER, RetroMotionParser);
	switch (property_id) {
		case RETRO_MOTION_PARSER_GRAB_POINTER:
		g_value_set_boolean (value, retro_motion_parser_get_grab_pointer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_retro_motion_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RetroMotionParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_MOTION_PARSER, RetroMotionParser);
	switch (property_id) {
		case RETRO_MOTION_PARSER_GRAB_POINTER:
		retro_motion_parser_set_grab_pointer (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


RetroMouse* retro_mouse_construct (GType object_type, GtkWidget* widget) {
	RetroMouse * self = NULL;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = widget;
	self = (RetroMouse*) g_object_new (object_type, "widget", _tmp0_, NULL);
	return self;
}


RetroMouse* retro_mouse_new (GtkWidget* widget) {
	return retro_mouse_construct (RETRO_TYPE_MOUSE, widget);
}


static void retro_mouse_real_poll (RetroInputDevice* base) {
	RetroMouse * self;
	self = (RetroMouse*) base;
}


static gint16 retro_mouse_real_get_input_state (RetroInputDevice* base, RetroDeviceType device, guint index, guint id) {
	RetroMouse * self;
	gint16 result = 0;
	RetroDeviceType _tmp0_;
	guint _tmp1_;
	self = (RetroMouse*) base;
	_tmp0_ = device;
	if (_tmp0_ != RETRO_DEVICE_TYPE_MOUSE) {
		result = (gint16) 0;
		return result;
	}
	_tmp1_ = id;
	switch ((RetroMouseId) _tmp1_) {
		case RETRO_MOUSE_ID_X:
		{
			gint16 _result_;
			gint16 _tmp2_;
			_tmp2_ = self->priv->x_delta;
			_result_ = _tmp2_;
			self->priv->x_delta = (gint16) 0;
			result = _result_;
			return result;
		}
		case RETRO_MOUSE_ID_Y:
		{
			gint16 _result_;
			gint16 _tmp3_;
			_tmp3_ = self->priv->y_delta;
			_result_ = _tmp3_;
			self->priv->y_delta = (gint16) 0;
			result = _result_;
			return result;
		}
		case RETRO_MOUSE_ID_LEFT:
		{
			gint16 _tmp4_ = 0;
			gboolean _tmp5_;
			_tmp5_ = retro_mouse_get_button_state (self, (guint) 1);
			if (_tmp5_) {
				_tmp4_ = G_MAXINT16;
			} else {
				_tmp4_ = (gint16) 0;
			}
			result = _tmp4_;
			return result;
		}
		case RETRO_MOUSE_ID_RIGHT:
		{
			gint16 _tmp6_ = 0;
			gboolean _tmp7_;
			_tmp7_ = retro_mouse_get_button_state (self, (guint) 3);
			if (_tmp7_) {
				_tmp6_ = G_MAXINT16;
			} else {
				_tmp6_ = (gint16) 0;
			}
			result = _tmp6_;
			return result;
		}
		default:
		{
			result = (gint16) 0;
			return result;
		}
	}
}


static RetroDeviceType retro_mouse_real_get_device_type (RetroInputDevice* base) {
	RetroMouse * self;
	RetroDeviceType result = 0;
	self = (RetroMouse*) base;
	result = RETRO_DEVICE_TYPE_MOUSE;
	return result;
}


static guint64 retro_mouse_real_get_device_capabilities (RetroInputDevice* base) {
	RetroMouse * self;
	guint64 result = 0ULL;
	self = (RetroMouse*) base;
	result = (guint64) (1 << RETRO_DEVICE_TYPE_MOUSE);
	return result;
}


static guint* _uint_dup (guint* self) {
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}


static gpointer __uint_dup0 (gpointer self) {
	return self ? _uint_dup (self) : NULL;
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


static gboolean retro_mouse_on_button_press_event (RetroMouse* self, GtkWidget* source, GdkEventButton* event) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GHashTable* _tmp8_;
	GdkEventButton* _tmp9_;
	guint _tmp10_;
	gboolean _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = retro_mouse_get_parse (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		GdkEventButton* _tmp2_;
		GdkDevice* _tmp3_;
		GdkEventButton* _tmp4_;
		GdkWindow* _tmp5_;
		GdkEventButton* _tmp6_;
		guint32 _tmp7_;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->device;
		_tmp4_ = event;
		_tmp5_ = _tmp4_->window;
		_tmp6_ = event;
		_tmp7_ = _tmp6_->time;
		retro_mouse_grab (self, _tmp3_, _tmp5_, _tmp7_);
		result = FALSE;
		return result;
	}
	_tmp8_ = self->priv->button_state;
	_tmp9_ = event;
	_tmp10_ = _tmp9_->button;
	_tmp11_ = g_hash_table_contains (_tmp8_, &_tmp10_);
	if (_tmp11_) {
		GHashTable* _tmp12_;
		GdkEventButton* _tmp13_;
		guint _tmp14_;
		guint* _tmp15_;
		gboolean _tmp16_;
		gboolean* _tmp17_;
		_tmp12_ = self->priv->button_state;
		_tmp13_ = event;
		_tmp14_ = _tmp13_->button;
		_tmp15_ = __uint_dup0 (&_tmp14_);
		_tmp16_ = TRUE;
		_tmp17_ = __bool_dup0 (&_tmp16_);
		g_hash_table_replace (_tmp12_, _tmp15_, _tmp17_);
	} else {
		GHashTable* _tmp18_;
		GdkEventButton* _tmp19_;
		guint _tmp20_;
		guint* _tmp21_;
		gboolean _tmp22_;
		gboolean* _tmp23_;
		_tmp18_ = self->priv->button_state;
		_tmp19_ = event;
		_tmp20_ = _tmp19_->button;
		_tmp21_ = __uint_dup0 (&_tmp20_);
		_tmp22_ = TRUE;
		_tmp23_ = __bool_dup0 (&_tmp22_);
		g_hash_table_insert (_tmp18_, _tmp21_, _tmp23_);
	}
	result = FALSE;
	return result;
}


static gboolean retro_mouse_on_button_release_event (RetroMouse* self, GtkWidget* source, GdkEventButton* event) {
	gboolean result = FALSE;
	GHashTable* _tmp0_;
	GdkEventButton* _tmp1_;
	guint _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->button_state;
	_tmp1_ = event;
	_tmp2_ = _tmp1_->button;
	_tmp3_ = g_hash_table_contains (_tmp0_, &_tmp2_);
	if (_tmp3_) {
		GHashTable* _tmp4_;
		GdkEventButton* _tmp5_;
		guint _tmp6_;
		guint* _tmp7_;
		gboolean _tmp8_;
		gboolean* _tmp9_;
		_tmp4_ = self->priv->button_state;
		_tmp5_ = event;
		_tmp6_ = _tmp5_->button;
		_tmp7_ = __uint_dup0 (&_tmp6_);
		_tmp8_ = FALSE;
		_tmp9_ = __bool_dup0 (&_tmp8_);
		g_hash_table_replace (_tmp4_, _tmp7_, _tmp9_);
	}
	result = FALSE;
	return result;
}


/**
 * Update the pointer's position
 */
static gboolean retro_mouse_on_motion_notify_event (RetroMouse* self, GtkWidget* source, GdkEventMotion* event) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint x = 0;
	gint y = 0;
	RetroMotionParser* _tmp2_;
	GdkEventMotion* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = retro_mouse_get_parse (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->parser;
	_tmp3_ = event;
	_tmp6_ = retro_motion_parser_parse_event (_tmp2_, _tmp3_, &_tmp4_, &_tmp5_);
	x = _tmp4_;
	y = _tmp5_;
	if (_tmp6_) {
		gint16 _tmp7_;
		gint _tmp8_;
		gint16 _tmp9_;
		gint _tmp10_;
		_tmp7_ = self->priv->x_delta;
		_tmp8_ = x;
		self->priv->x_delta = _tmp7_ + ((gint16) _tmp8_);
		_tmp9_ = self->priv->y_delta;
		_tmp10_ = y;
		self->priv->y_delta = _tmp9_ + ((gint16) _tmp10_);
	}
	result = FALSE;
	return result;
}


gboolean retro_mouse_get_button_state (RetroMouse* self, guint button) {
	gboolean result = FALSE;
	GHashTable* _tmp0_;
	guint _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->button_state;
	_tmp1_ = button;
	_tmp2_ = g_hash_table_contains (_tmp0_, &_tmp1_);
	if (_tmp2_) {
		GHashTable* _tmp3_;
		guint _tmp4_;
		gconstpointer _tmp5_;
		_tmp3_ = self->priv->button_state;
		_tmp4_ = button;
		_tmp5_ = g_hash_table_lookup (_tmp3_, &_tmp4_);
		result = *((gboolean*) _tmp5_);
		return result;
	}
	result = FALSE;
	return result;
}


/**
 * Grab the poiner
 */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RetroMouse* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->screen);
		_g_object_unref0 (_data1_->device);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda10_ (Block1Data* _data1_, guint32 time) {
	RetroMouse* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data1_->self;
	_tmp0_ = retro_mouse_get_parse (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GdkDevice* _tmp2_;
		guint32 _tmp3_;
		GdkDevice* _tmp4_;
		gulong _tmp5_;
		retro_mouse_set_parse (self, FALSE);
		_tmp2_ = _data1_->device;
		_tmp3_ = time;
		gdk_device_ungrab (_tmp2_, _tmp3_);
		_tmp4_ = _data1_->device;
		gdk_device_warp (_tmp4_, _data1_->screen, _data1_->x, _data1_->y);
		_tmp5_ = self->priv->ungrab_id;
		g_signal_handler_disconnect ((GObject*) self, _tmp5_);
	}
}


static void ___lambda10__retro_mouse_ungrab (RetroMouse* _sender, guint32 time, gpointer self) {
	__lambda10_ (self, time);
}


static void retro_mouse_grab (RetroMouse* self, GdkDevice* device, GdkWindow* window, guint32 time) {
	Block1Data* _data1_;
	GdkDevice* _tmp0_;
	GdkDevice* _tmp1_;
	GdkDevice* _tmp2_;
	GdkScreen* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GdkScreen* _tmp6_;
	GdkCursor* cursor;
	GdkCursor* _tmp7_;
	GdkDevice* _tmp8_;
	GdkWindow* _tmp9_;
	guint32 _tmp10_;
	gulong _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_return_if_fail (window != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = device;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data1_->device);
	_data1_->device = _tmp1_;
	_tmp2_ = _data1_->device;
	gdk_device_get_position (_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	_g_object_unref0 (_data1_->screen);
	_tmp6_ = _g_object_ref0 (_tmp3_);
	_data1_->screen = _tmp6_;
	_data1_->x = _tmp4_;
	_data1_->y = _tmp5_;
	retro_mouse_set_parse (self, TRUE);
	_tmp7_ = gdk_cursor_new (GDK_BLANK_CURSOR);
	cursor = _tmp7_;
	_tmp8_ = _data1_->device;
	_tmp9_ = window;
	_tmp10_ = time;
	gdk_device_grab (_tmp8_, _tmp9_, GDK_OWNERSHIP_NONE, FALSE, GDK_ALL_EVENTS_MASK, cursor, _tmp10_);
	_tmp11_ = g_signal_connect_data (self, "ungrab", (GCallback) ___lambda10__retro_mouse_ungrab, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	self->priv->ungrab_id = _tmp11_;
	_g_object_unref0 (cursor);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


GtkWidget* retro_mouse_get_widget (RetroMouse* self) {
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_widget;
	result = _tmp0_;
	return result;
}


static void retro_mouse_set_widget (RetroMouse* self, GtkWidget* value) {
	g_return_if_fail (self != NULL);
	if (retro_mouse_get_widget (self) != value) {
		GtkWidget* _tmp0_;
		GtkWidget* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_widget);
		self->priv->_widget = _tmp1_;
		g_object_notify ((GObject *) self, "widget");
	}
}


gboolean retro_mouse_get_parse (RetroMouse* self) {
	gboolean result;
	RetroMotionParser* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->parser;
	_tmp1_ = retro_motion_parser_get_grab_pointer (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void retro_mouse_set_parse (RetroMouse* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (retro_mouse_get_parse (self) != value) {
		RetroMotionParser* _tmp0_;
		gboolean _tmp1_;
		_tmp0_ = self->priv->parser;
		_tmp1_ = value;
		retro_motion_parser_set_grab_pointer (_tmp0_, _tmp1_);
		g_object_notify ((GObject *) self, "parse");
	}
}


static gboolean _retro_mouse_on_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = retro_mouse_on_button_press_event ((RetroMouse*) self, _sender, event);
	return result;
}


static gboolean _retro_mouse_on_motion_notify_event_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = retro_mouse_on_motion_notify_event ((RetroMouse*) self, _sender, event);
	return result;
}


static gboolean _retro_mouse___lambda11_ (RetroMouse* self, GtkWidget* w, GdkEventFocus* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	g_signal_emit (self, retro_mouse_signals[RETRO_MOUSE_UNGRAB_SIGNAL], 0, (guint32) 0);
	result = FALSE;
	return result;
}


static gboolean __retro_mouse___lambda11__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = _retro_mouse___lambda11_ ((RetroMouse*) self, _sender, event);
	return result;
}


static gboolean _retro_mouse___lambda12_ (RetroMouse* self, GtkWidget* w, GdkEventKey* e) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp1_ = e;
	_tmp2_ = _tmp1_->keyval;
	if (_tmp2_ == ((guint) GDK_KEY_Escape)) {
		GdkEventKey* _tmp3_;
		GdkModifierType _tmp4_;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->state;
		_tmp0_ = (gboolean) (_tmp4_ & GDK_CONTROL_MASK);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GdkEventKey* _tmp5_;
		guint32 _tmp6_;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->time;
		g_signal_emit (self, retro_mouse_signals[RETRO_MOUSE_UNGRAB_SIGNAL], 0, _tmp6_);
	}
	result = FALSE;
	return result;
}


static gboolean __retro_mouse___lambda12__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = _retro_mouse___lambda12_ ((RetroMouse*) self, _sender, event);
	return result;
}


static gboolean _retro_mouse_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = retro_mouse_on_button_release_event ((RetroMouse*) self, _sender, event);
	return result;
}


static void _g_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}


static GObject * retro_mouse_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RetroMouse * self;
	RetroMotionParser* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	parent_class = G_OBJECT_CLASS (retro_mouse_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_MOUSE, RetroMouse);
	_tmp0_ = retro_motion_parser_new ();
	_g_object_unref0 (self->priv->parser);
	self->priv->parser = _tmp0_;
	_tmp1_ = self->priv->_widget;
	g_signal_connect_object (_tmp1_, "button-press-event", (GCallback) _retro_mouse_on_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp2_ = self->priv->_widget;
	g_signal_connect_object (_tmp2_, "motion-notify-event", (GCallback) _retro_mouse_on_motion_notify_event_gtk_widget_motion_notify_event, self, 0);
	_tmp3_ = self->priv->_widget;
	g_signal_connect_object (_tmp3_, "focus-out-event", (GCallback) __retro_mouse___lambda11__gtk_widget_focus_out_event, self, 0);
	_tmp4_ = self->priv->_widget;
	g_signal_connect_object (_tmp4_, "key-press-event", (GCallback) __retro_mouse___lambda12__gtk_widget_key_press_event, self, 0);
	_tmp5_ = self->priv->_widget;
	g_signal_connect_object (_tmp5_, "button-press-event", (GCallback) _retro_mouse_on_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp6_ = self->priv->_widget;
	g_signal_connect_object (_tmp6_, "button-release-event", (GCallback) _retro_mouse_on_button_release_event_gtk_widget_button_release_event, self, 0);
	_tmp7_ = g_int_hash;
	_tmp8_ = g_int_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->button_state);
	self->priv->button_state = _tmp9_;
	return obj;
}


static void retro_mouse_class_init (RetroMouseClass * klass) {
	retro_mouse_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RetroMousePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_retro_mouse_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_retro_mouse_set_property;
	G_OBJECT_CLASS (klass)->constructor = retro_mouse_constructor;
	G_OBJECT_CLASS (klass)->finalize = retro_mouse_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MOUSE_WIDGET, g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_MOUSE_PARSE, g_param_spec_boolean ("parse", "parse", "parse", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Release the pointer
	 */
	retro_mouse_signals[RETRO_MOUSE_UNGRAB_SIGNAL] = g_signal_new ("ungrab", RETRO_TYPE_MOUSE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
}


static void retro_mouse_retro_input_device_interface_init (RetroInputDeviceIface * iface) {
	retro_mouse_retro_input_device_parent_iface = g_type_interface_peek_parent (iface);
	iface->poll = (void (*) (RetroInputDevice *)) retro_mouse_real_poll;
	iface->get_input_state = (gint16 (*) (RetroInputDevice *, RetroDeviceType, guint, guint)) retro_mouse_real_get_input_state;
	iface->get_device_type = (RetroDeviceType (*) (RetroInputDevice *)) retro_mouse_real_get_device_type;
	iface->get_device_capabilities = (guint64 (*) (RetroInputDevice *)) retro_mouse_real_get_device_capabilities;
}


static void retro_mouse_instance_init (RetroMouse * self) {
	self->priv = RETRO_MOUSE_GET_PRIVATE (self);
}


static void retro_mouse_finalize (GObject * obj) {
	RetroMouse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_MOUSE, RetroMouse);
	_g_object_unref0 (self->priv->_widget);
	_g_hash_table_unref0 (self->priv->button_state);
	_g_object_unref0 (self->priv->parser);
	G_OBJECT_CLASS (retro_mouse_parent_class)->finalize (obj);
}


GType retro_mouse_get_type (void) {
	static volatile gsize retro_mouse_type_id__volatile = 0;
	if (g_once_init_enter (&retro_mouse_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroMouseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) retro_mouse_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RetroMouse), 0, (GInstanceInitFunc) retro_mouse_instance_init, NULL };
		static const GInterfaceInfo retro_input_device_info = { (GInterfaceInitFunc) retro_mouse_retro_input_device_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType retro_mouse_type_id;
		retro_mouse_type_id = g_type_register_static (G_TYPE_OBJECT, "RetroMouse", &g_define_type_info, 0);
		g_type_add_interface_static (retro_mouse_type_id, RETRO_TYPE_INPUT_DEVICE, &retro_input_device_info);
		g_once_init_leave (&retro_mouse_type_id__volatile, retro_mouse_type_id);
	}
	return retro_mouse_type_id__volatile;
}


static void _vala_retro_mouse_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RetroMouse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_MOUSE, RetroMouse);
	switch (property_id) {
		case RETRO_MOUSE_WIDGET:
		g_value_set_object (value, retro_mouse_get_widget (self));
		break;
		case RETRO_MOUSE_PARSE:
		g_value_set_boolean (value, retro_mouse_get_parse (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_retro_mouse_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RetroMouse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_MOUSE, RetroMouse);
	switch (property_id) {
		case RETRO_MOUSE_WIDGET:
		retro_mouse_set_widget (self, g_value_get_object (value));
		break;
		case RETRO_MOUSE_PARSE:
		retro_mouse_set_parse (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



