/* log.c generated by valac 0.35.5, the Vala compiler
 * generated from log.vala, do not modify */

/* This file is part of retro-gtk. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define RETRO_TYPE_LOG_LEVEL (retro_log_level_get_type ())

#define RETRO_TYPE_LOG (retro_log_get_type ())
#define RETRO_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_LOG, RetroLog))
#define RETRO_IS_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_LOG))
#define RETRO_LOG_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_LOG, RetroLogIface))

typedef struct _RetroLog RetroLog;
typedef struct _RetroLogIface RetroLogIface;

typedef enum  {
	RETRO_LOG_LEVEL_DEBUG = 0,
	RETRO_LOG_LEVEL_INFO,
	RETRO_LOG_LEVEL_WARN,
	RETRO_LOG_LEVEL_ERROR
} RetroLogLevel;

struct _RetroLogIface {
	GTypeInterface parent_iface;
	gboolean (*log) (RetroLog* self, RetroLogLevel level, const gchar* message);
};



GType retro_log_level_get_type (void) G_GNUC_CONST;
GType retro_log_get_type (void) G_GNUC_CONST;
gboolean retro_log_log (RetroLog* self, RetroLogLevel level, const gchar* message);


/**
 * The level of importance of a message.
 */
GType retro_log_level_get_type (void) {
	static volatile gsize retro_log_level_type_id__volatile = 0;
	if (g_once_init_enter (&retro_log_level_type_id__volatile)) {
		static const GEnumValue values[] = {{RETRO_LOG_LEVEL_DEBUG, "RETRO_LOG_LEVEL_DEBUG", "debug"}, {RETRO_LOG_LEVEL_INFO, "RETRO_LOG_LEVEL_INFO", "info"}, {RETRO_LOG_LEVEL_WARN, "RETRO_LOG_LEVEL_WARN", "warn"}, {RETRO_LOG_LEVEL_ERROR, "RETRO_LOG_LEVEL_ERROR", "error"}, {0, NULL, NULL}};
		GType retro_log_level_type_id;
		retro_log_level_type_id = g_enum_register_static ("RetroLogLevel", values);
		g_once_init_leave (&retro_log_level_type_id__volatile, retro_log_level_type_id);
	}
	return retro_log_level_type_id__volatile;
}


/**
 * Logs a message.
 *
 * @param level the importance of the message
 * @param message the message to log
 * @return true if the message have been logged, false otherwise
 */
gboolean retro_log_log (RetroLog* self, RetroLogLevel level, const gchar* message) {
	g_return_val_if_fail (self != NULL, FALSE);
	return RETRO_LOG_GET_INTERFACE (self)->log (self, level, message);
}


static void retro_log_base_init (RetroLogIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


/**
 * An interface for logging.
 */
GType retro_log_get_type (void) {
	static volatile gsize retro_log_type_id__volatile = 0;
	if (g_once_init_enter (&retro_log_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroLogIface), (GBaseInitFunc) retro_log_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType retro_log_type_id;
		retro_log_type_id = g_type_register_static (G_TYPE_INTERFACE, "RetroLog", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (retro_log_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&retro_log_type_id__volatile, retro_log_type_id);
	}
	return retro_log_type_id__volatile;
}



