/* memory.c generated by valac 0.35.5, the Vala compiler
 * generated from memory.vala, do not modify */

/* This file is part of retro-gtk. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define RETRO_TYPE_MEMORY_TYPE (retro_memory_type_get_type ())

#define RETRO_TYPE_MEM_DESC (retro_mem_desc_get_type ())

#define RETRO_TYPE_MEMORY_DESCRIPTOR (retro_memory_descriptor_get_type ())
typedef struct _RetroMemoryDescriptor RetroMemoryDescriptor;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RETRO_TYPE_MEMORY_MAP (retro_memory_map_get_type ())
typedef struct _RetroMemoryMap RetroMemoryMap;
#define _retro_memory_descriptor_free0(var) ((var == NULL) ? NULL : (var = (retro_memory_descriptor_free (var), NULL)))

typedef enum  {
	RETRO_MEMORY_TYPE_TYPE_MASK = 0xff,
	RETRO_MEMORY_TYPE_SAVE_RAM = 0,
	RETRO_MEMORY_TYPE_RTC = 1,
	RETRO_MEMORY_TYPE_SYSTEM_RAM = 2,
	RETRO_MEMORY_TYPE_VIDEO_RAM = 3,
	RETRO_MEMORY_TYPE_SNES_BSX_RAM = (1 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_BSX_PRAM = (2 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_SUFAMI_TURBO_A_RAM = (3 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_SUFAMI_TURBO_B_RAM = (4 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_GAME_BOY_RAM = (5 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_GAME_BOY_RTC = (6 << 8) | RETRO_MEMORY_TYPE_RTC
} RetroMemoryType;

typedef enum  {
	RETRO_MEM_DESC_CONST = 1 << 0,
	RETRO_MEM_DESC_BIGENDIAN = 1 << 1,
	RETRO_MEM_DESC_ALIGN_2 = 1 << 16,
	RETRO_MEM_DESC_ALIGN_4 = 2 << 16,
	RETRO_MEM_DESC_ALIGN_8 = 3 << 16,
	RETRO_MEM_DESC_MINSIZE_2 = 1 << 24,
	RETRO_MEM_DESC_MINSIZE_4 = 2 << 24,
	RETRO_MEM_DESC_MINSIZE_8 = 3 << 24
} RetroMemDesc;

struct _RetroMemoryDescriptor {
	guint64 flags;
	void* ptr;
	gsize offset;
	gsize start;
	gsize select;
	gsize disconnect;
	gsize len;
	gchar* addrspace;
};

struct _RetroMemoryMap {
	RetroMemoryDescriptor* descriptors;
	guint num_descriptors;
};



GType retro_memory_type_get_type (void) G_GNUC_CONST;
RetroMemoryType retro_memory_type_get_basic_type (RetroMemoryType self);
GType retro_mem_desc_get_type (void) G_GNUC_CONST;
GType retro_memory_descriptor_get_type (void) G_GNUC_CONST;
RetroMemoryDescriptor* retro_memory_descriptor_dup (const RetroMemoryDescriptor* self);
void retro_memory_descriptor_free (RetroMemoryDescriptor* self);
void retro_memory_descriptor_copy (const RetroMemoryDescriptor* self, RetroMemoryDescriptor* dest);
void retro_memory_descriptor_destroy (RetroMemoryDescriptor* self);
GType retro_memory_map_get_type (void) G_GNUC_CONST;
RetroMemoryMap* retro_memory_map_dup (const RetroMemoryMap* self);
void retro_memory_map_free (RetroMemoryMap* self);
void retro_memory_map_copy (const RetroMemoryMap* self, RetroMemoryMap* dest);
void retro_memory_map_destroy (RetroMemoryMap* self);


/**
 * Gets the basic type of a memory type.
 *
 * Applies the type mask on a MemoryType to get its basic type.
 * If the memory type is already basic, it will return the same type.
 *
 * E.g MemoryType.SNES_BSX_RAM.get_basic_type () returns
 * MemoryType.SAVE_RAM, and MemoryType.SAVE_RAM.get_basic_type () also
 * returns MemoryType.SAVE_RAM.
 *
 * @return the basic type of a memory type
 */
RetroMemoryType retro_memory_type_get_basic_type (RetroMemoryType self) {
	RetroMemoryType result = 0;
	RetroMemoryType basic_type;
	basic_type = self & RETRO_MEMORY_TYPE_TYPE_MASK;
	result = basic_type;
	return result;
}


/**
 * The memory region types.
 */
GType retro_memory_type_get_type (void) {
	static volatile gsize retro_memory_type_type_id__volatile = 0;
	if (g_once_init_enter (&retro_memory_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RETRO_MEMORY_TYPE_TYPE_MASK, "RETRO_MEMORY_TYPE_TYPE_MASK", "type-mask"}, {RETRO_MEMORY_TYPE_SAVE_RAM, "RETRO_MEMORY_TYPE_SAVE_RAM", "save-ram"}, {RETRO_MEMORY_TYPE_RTC, "RETRO_MEMORY_TYPE_RTC", "rtc"}, {RETRO_MEMORY_TYPE_SYSTEM_RAM, "RETRO_MEMORY_TYPE_SYSTEM_RAM", "system-ram"}, {RETRO_MEMORY_TYPE_VIDEO_RAM, "RETRO_MEMORY_TYPE_VIDEO_RAM", "video-ram"}, {RETRO_MEMORY_TYPE_SNES_BSX_RAM, "RETRO_MEMORY_TYPE_SNES_BSX_RAM", "snes-bsx-ram"}, {RETRO_MEMORY_TYPE_SNES_BSX_PRAM, "RETRO_MEMORY_TYPE_SNES_BSX_PRAM", "snes-bsx-pram"}, {RETRO_MEMORY_TYPE_SNES_SUFAMI_TURBO_A_RAM, "RETRO_MEMORY_TYPE_SNES_SUFAMI_TURBO_A_RAM", "snes-sufami-turbo-a-ram"}, {RETRO_MEMORY_TYPE_SNES_SUFAMI_TURBO_B_RAM, "RETRO_MEMORY_TYPE_SNES_SUFAMI_TURBO_B_RAM", "snes-sufami-turbo-b-ram"}, {RETRO_MEMORY_TYPE_SNES_GAME_BOY_RAM, "RETRO_MEMORY_TYPE_SNES_GAME_BOY_RAM", "snes-game-boy-ram"}, {RETRO_MEMORY_TYPE_SNES_GAME_BOY_RTC, "RETRO_MEMORY_TYPE_SNES_GAME_BOY_RTC", "snes-game-boy-rtc"}, {0, NULL, NULL}};
		GType retro_memory_type_type_id;
		retro_memory_type_type_id = g_enum_register_static ("RetroMemoryType", values);
		g_once_init_leave (&retro_memory_type_type_id__volatile, retro_memory_type_type_id);
	}
	return retro_memory_type_type_id__volatile;
}


/**
 * TODO Change visibility once the interface have been tested.
 */
GType retro_mem_desc_get_type (void) {
	static volatile gsize retro_mem_desc_type_id__volatile = 0;
	if (g_once_init_enter (&retro_mem_desc_type_id__volatile)) {
		static const GFlagsValue values[] = {{RETRO_MEM_DESC_CONST, "RETRO_MEM_DESC_CONST", "const"}, {RETRO_MEM_DESC_BIGENDIAN, "RETRO_MEM_DESC_BIGENDIAN", "bigendian"}, {RETRO_MEM_DESC_ALIGN_2, "RETRO_MEM_DESC_ALIGN_2", "align-2"}, {RETRO_MEM_DESC_ALIGN_4, "RETRO_MEM_DESC_ALIGN_4", "align-4"}, {RETRO_MEM_DESC_ALIGN_8, "RETRO_MEM_DESC_ALIGN_8", "align-8"}, {RETRO_MEM_DESC_MINSIZE_2, "RETRO_MEM_DESC_MINSIZE_2", "minsize-2"}, {RETRO_MEM_DESC_MINSIZE_4, "RETRO_MEM_DESC_MINSIZE_4", "minsize-4"}, {RETRO_MEM_DESC_MINSIZE_8, "RETRO_MEM_DESC_MINSIZE_8", "minsize-8"}, {0, NULL, NULL}};
		GType retro_mem_desc_type_id;
		retro_mem_desc_type_id = g_flags_register_static ("RetroMemDesc", values);
		g_once_init_leave (&retro_mem_desc_type_id__volatile, retro_mem_desc_type_id);
	}
	return retro_mem_desc_type_id__volatile;
}


void retro_memory_descriptor_copy (const RetroMemoryDescriptor* self, RetroMemoryDescriptor* dest) {
	guint64 _tmp0_;
	void* _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	gsize _tmp4_;
	gsize _tmp5_;
	gsize _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	_tmp0_ = (*self).flags;
	(*dest).flags = _tmp0_;
	_tmp1_ = (*self).ptr;
	(*dest).ptr = _tmp1_;
	_tmp2_ = (*self).offset;
	(*dest).offset = _tmp2_;
	_tmp3_ = (*self).start;
	(*dest).start = _tmp3_;
	_tmp4_ = (*self).select;
	(*dest).select = _tmp4_;
	_tmp5_ = (*self).disconnect;
	(*dest).disconnect = _tmp5_;
	_tmp6_ = (*self).len;
	(*dest).len = _tmp6_;
	_tmp7_ = (*self).addrspace;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 ((*dest).addrspace);
	(*dest).addrspace = _tmp8_;
}


void retro_memory_descriptor_destroy (RetroMemoryDescriptor* self) {
	_g_free0 ((*self).addrspace);
}


RetroMemoryDescriptor* retro_memory_descriptor_dup (const RetroMemoryDescriptor* self) {
	RetroMemoryDescriptor* dup;
	dup = g_new0 (RetroMemoryDescriptor, 1);
	retro_memory_descriptor_copy (self, dup);
	return dup;
}


void retro_memory_descriptor_free (RetroMemoryDescriptor* self) {
	retro_memory_descriptor_destroy (self);
	g_free (self);
}


GType retro_memory_descriptor_get_type (void) {
	static volatile gsize retro_memory_descriptor_type_id__volatile = 0;
	if (g_once_init_enter (&retro_memory_descriptor_type_id__volatile)) {
		GType retro_memory_descriptor_type_id;
		retro_memory_descriptor_type_id = g_boxed_type_register_static ("RetroMemoryDescriptor", (GBoxedCopyFunc) retro_memory_descriptor_dup, (GBoxedFreeFunc) retro_memory_descriptor_free);
		g_once_init_leave (&retro_memory_descriptor_type_id__volatile, retro_memory_descriptor_type_id);
	}
	return retro_memory_descriptor_type_id__volatile;
}


static gpointer _retro_memory_descriptor_dup0 (gpointer self) {
	return self ? retro_memory_descriptor_dup (self) : NULL;
}


void retro_memory_map_copy (const RetroMemoryMap* self, RetroMemoryMap* dest) {
	RetroMemoryDescriptor* _tmp0_;
	RetroMemoryDescriptor* _tmp1_;
	guint _tmp2_;
	_tmp0_ = (*self).descriptors;
	_tmp1_ = _retro_memory_descriptor_dup0 (_tmp0_);
	_retro_memory_descriptor_free0 ((*dest).descriptors);
	(*dest).descriptors = _tmp1_;
	_tmp2_ = (*self).num_descriptors;
	(*dest).num_descriptors = _tmp2_;
}


void retro_memory_map_destroy (RetroMemoryMap* self) {
	_retro_memory_descriptor_free0 ((*self).descriptors);
}


RetroMemoryMap* retro_memory_map_dup (const RetroMemoryMap* self) {
	RetroMemoryMap* dup;
	dup = g_new0 (RetroMemoryMap, 1);
	retro_memory_map_copy (self, dup);
	return dup;
}


void retro_memory_map_free (RetroMemoryMap* self) {
	retro_memory_map_destroy (self);
	g_free (self);
}


GType retro_memory_map_get_type (void) {
	static volatile gsize retro_memory_map_type_id__volatile = 0;
	if (g_once_init_enter (&retro_memory_map_type_id__volatile)) {
		GType retro_memory_map_type_id;
		retro_memory_map_type_id = g_boxed_type_register_static ("RetroMemoryMap", (GBoxedCopyFunc) retro_memory_map_dup, (GBoxedFreeFunc) retro_memory_map_free);
		g_once_init_leave (&retro_memory_map_type_id__volatile, retro_memory_map_type_id);
	}
	return retro_memory_map_type_id__volatile;
}



