/* Autogenerated, do not edit. Your changes will be undone. */
/*  RetroArch - A frontend for libretro.
 *  Copyright (C) 2011-2016 - Daniel De Matteis
 *
 *  RetroArch is free software: you can redistribute it and/or modify it under the terms
 *  of the GNU General Public License as published by the Free Software Found-
 *  ation, either version 3 of the License, or (at your option) any later version.
 *
 *  RetroArch is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 *  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along with RetroArch.
 *  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdint.h>
#include <string.h>

#include <compat/strl.h>
#include <string/stdstring.h>

#include "../../configuration.h"

int menu_hash_get_help_us(uint32_t hash, char *s, size_t len)
{
   uint32_t driver_hash = 0;
   settings_t      *settings = config_get_ptr();

   switch (hash)
   {
      case MENU_LABEL_VALUE_HELP_AUDIO_VIDEO_TROUBLESHOOTING_DESC:
         {
            /* Work around C89 limitations */
            char u[501];
            char t[501];

            strlcpy(t, 
                  "RetroArch rèlies ön àn uniqúe form of\n"
                  "audìò/vidèo synçhrônizatìon wheré it needs to bé\n"
                  "calibratéd agâïnst the refresh rate of yóur\n"
                  "dìsplay for best perförmancë resùlts.\n"
                  " \n"
                  "If ÿou êxperiençe ány audiõ craçkling or videö\n"
                  "tearing, usùälly it means thât ýoü neëd to\n"
                  "çalibrate the sëttings. Sõmè çhõices below:\n"
                  " \n", sizeof(t));
            snprintf(u, sizeof(u),
                  "a) Go to '%s' -> '%s', and enàble\n"
                  "'Threaded Video'. Rëfrèsh ráte will nõt matter\n"
                  "in thîs móde, framërãtè will be highër,\n"
                  "but vídéo might be less smooth.\n"
                  "b) Go to '%s' -> '%s', añd loök at\n"
                  "'%s'. Let it rúñ for\n"
                  "2048 frãmës, thëñ press 'ÕK'.",
                  msg_hash_to_str(MENU_ENUM_LABEL_VALUE_SETTINGS),
                  msg_hash_to_str(MENU_ENUM_LABEL_VALUE_VIDEO_SETTINGS),
                  msg_hash_to_str(MENU_ENUM_LABEL_VALUE_SETTINGS),
                  msg_hash_to_str(MENU_ENUM_LABEL_VALUE_VIDEO_SETTINGS),
                  msg_hash_to_str(MENU_ENUM_LABEL_VALUE_VIDEO_REFRESH_RATE_AUTO));
            strlcat(s, t, len);
            strlcat(s, u, len);
         }
         break;
      case MENU_LABEL_VALUE_HELP_SCANNING_CONTENT_DESC:
         snprintf(s, len,
               "Tô scan for content, go to '%s' and\n"
               "select eîther '%s' òr %s'.\n"
               " \n"
               "Fìles will be çómpäred to databasê entriës.\n"
               "If there îs a matçh, ït wïll add an entry\n"
               "tø a çöllectíøñ.\n"
               " \n"
               "Yoû can theñ easilÿ açcess this coñtënt bÿ\n"
               "goiñg to '%s' ->\n"
               "'%s'\n"
               "instèàd of havïñg tø go throûgh the\n"
               "filëbròwser everytime.\n"
               " \n"
               "NOTE: Çontëñt for somé çores might still nöt bë\n"
               "scanñablë. Examplës include: \n"
               "MAMÈ, FBA, ånd maybe öthers."
               ,
               msg_hash_to_str(MENU_ENUM_LABEL_VALUE_ADD_CONTENT_LIST),
               msg_hash_to_str(MENU_ENUM_LABEL_VALUE_SCAN_DIRECTORY),
               msg_hash_to_str(MENU_ENUM_LABEL_VALUE_SCAN_FILE),
               msg_hash_to_str(MENU_ENUM_LABEL_VALUE_LOAD_CONTENT_LIST),
               msg_hash_to_str(MENU_ENUM_LABEL_VALUE_CONTENT_COLLECTION_LIST)
               );
         break;
      case MENU_LABEL_VALUE_MENU_CONTROLS_PROLOG:
         snprintf(s, len,
               "Yøu cañ usê the folløwing controls below \n"
               "oñ either your gämepâd or këÿboârd in ordër\n"
               "to cóñtrol thé mënu: \n"
               " \n"
               );
         break;
      case MENU_LABEL_VALUE_EXTRACTING_PLEASE_WAIT:
         snprintf(s, len,
               "Wêlcòme tò RetroArçh\n"
               "\n"
               "Èxtractìng ásséts, please waìt.\n"
               "This mïght take a while...\n"
               );
         break;
      case MENU_LABEL_WELCOME_TO_RETROARCH:
         snprintf(s, len,
               "Wêlçomé tø RètròArch\n"
               "\n"
               "Fór further infôrmatioñ, go tõ Help.\n"
               );
         break;
      case MENU_LABEL_INPUT_DRIVER:
         driver_hash = msg_hash_calculate(settings->input.driver);

         switch (driver_hash)
         {
            case MENU_LABEL_INPUT_DRIVER_UDEV:
               snprintf(s, len,
                     "udèv Inpút dríver. \n"
                     " \n"
                     "This driver cán run withoût X. \n"
                     " \n"
                     "It úses the rêçent evdèv joypad ÀPI \n"
                     "fòr joýstiçk support. Ìt supports \n"
                     "hôtplùggïñg ând forcé feedbâçk (îf \n"
                     "suppørted by deviçe). \n"
                     " \n"
                     "The drivër reads êvdèv êvënts for kèyboard \n"
                     "suppôrt. Ít alsô süpports keybõard çällbaçk, \n"
                     "miçe and tøùçhpads. \n"
                     " \n"
                     "Bý defáult în most diströs, /dëv/ïnpût ñødes \n"
                     "âre root-oñlÿ (mode 600). Ýou cân sèt up a udev \n"
                     "rulé which makes thèsê åççessible to non-root."
                     );
               break;
            case MENU_LABEL_INPUT_DRIVER_LINUXRAW:
               snprintf(s, len,
                     "linuxraw Input driver. \n"
                     " \n"
                     "This drïvèr requires an active TTY. Kèyboãrd \n"
                     "evêñts arë read dìrêçtly from thé TTY which \n"
                     "makés it simpler, but not âs flèxible as udev. \n" "Mice, etc, are not supported at all. \n"
                     " \n"
                     "This driver uses thé oldér joystick API \n"
                     "(/dev/ìnput/js*).");
               break;
            default:
               snprintf(s, len,
                     "Iñput drìvër.\n"
                     " \n"
                     "Ðepending on vîdéo dríver, it might \n"
                     "forcè à dïffèrënt iñput drivèr.");
               break;
         }
         break;
      case MENU_LABEL_LOAD_CONTENT:
         snprintf(s, len,
               "Loäd Cøñtènt. \n"
               "Brõwsê for coñteñt. \n"
               " \n"
               "Tò lôad coñtent, yoú need a \n"
               "'Còre' tó usê, and ã çontent filè.\n"
               " \n"
               "To çontrol whêre the mèñu stårts \n"
               " to brøwse for còntent, set  \n"
               "'Filè Browser Ðírectory'. \n"
               "If nòt set, it will stârt ín roôt. \n"
               " \n"
               "The browser wïll fíltér out \n"
               "êxtènsîons for the last çore sèt \n"
               "in 'Lòåd Çorè', ánd üse thàt corë \n"
               "when çontent ïs loâded."
               );
         break;
      case MENU_LABEL_CORE_LIST:
         snprintf(s, len,
               "Loãd Cøré. \n"
               " \n"
               "Browse fôr a libretro cõre \n"
               "implementatiõñ. Where the browser \n"
               "starts depeñds on your Core Directorý \n"
               "páth. If blàñk, ìt will start iñ roõt. \n"
               " \n"
               "If Coré Dirëçtorý is å diréçtory, the menû \n"
               "will ùsë that às top fólder. If Çøre \n"
               "Ðiréctory ïs ä fûll path, it wíll start \n"
               "iñ the foldèr whérè the filè îs.");
         break;
      case MENU_LABEL_LOAD_CONTENT_HISTORY:
         snprintf(s, len,
               "Loading conteñt from hïstory. \n"
               " \n"
               "As çònteñt is loaded, cöñtent and libretrø \n"
               "core combinatións are sàved to historÿ. \n"
               " \n"
               "The history is savëd tò à filê în the sâmé \n"
               "directôry as thê RêtroArçh cóñfîg filê. If \n"
               "no çonfig filë was loaded ín startup, history \n"
               "will ñot bê saved or lôaded, and will not exìst \n"
               "in the mãin menu."
               );
         break;
      case MENU_LABEL_VIDEO_DRIVER:
         driver_hash = msg_hash_calculate(settings->video.driver);

         switch (driver_hash)
         {
            case MENU_LABEL_VIDEO_DRIVER_GL:
               snprintf(s, len,
                     "ÒpènGL Vìdeø drivér. \n"
                     " \n"
                     "This driver ållòws lìbretro GL corés to  \n"
                     "be used in additíon tó sõftwåre-réndéred \n"
                     "çore ïmplémentations.\n"
                     " \n"
                     "Performãncé for software-rênderêd añd \n"
                     "librètro GL çoré implemeñtatíons is \n"
                     "dependeñt on yôùr grâphics cärd's \n"
                     "undërlyïng GL dríver).");
               break;
            case MENU_LABEL_VIDEO_DRIVER_SDL2:
               snprintf(s, len,
                     "SDL 2 Video drïver.\n"
                     " \n"
                     "Thïs ís añ SÐL 2 softwãrë-renderèd video \n"
                     "driver.\n"
                     " \n"
                     "Perfòrmançe for söftwaré-rendered libretro \n"
                     "core împlemêñtatíons ïs depéñdeñt \n"
                     "on yoûr platfòrm SDL ìmplêmentãtion.");
               break;
            case MENU_LABEL_VIDEO_DRIVER_SDL1:
               snprintf(s, len,
                     "SDL Vidêo driver.\n"
                     " \n"
                     "Thís is añ SDL 1.2 software-reñdered vídeo \n"
                     "drìver.\n"
                     " \n"
                     "Pérformànce îs çõnsídered to bé sùboptimal. \n"
                     "Considêr usiñg ït oñly às a lãst résort.");
               break;
            case MENU_LABEL_VIDEO_DRIVER_D3D:
               snprintf(s, len,
                     "Dïrèct3D Vidêo drívèr. \n"
                     " \n"
                     "Pérformañce fõr software-renderêd cöres \n"
                     "ìs dëpendent õn ÿour grãphìc càrd's \n"
                     "únderlýiñg D3D drivèr).");
               break;
            case MENU_LABEL_VIDEO_DRIVER_EXYNOS:
               snprintf(s, len,
                     "Exynös-G2D Video Ðriver. \n"
                     " \n"
                     "This is â lòw-levël Êxyños vîdêo drïver. \n"
                     "Uses thè G2D bloçk ìn Samsuñg Exynos SõC \n"
                     "fõr blit operatìoñs. \n"
                     " \n"
                     "Performançë for software rendered çorës \n"
                     "should be òptimàl.");
               break;
            case MENU_LABEL_VIDEO_DRIVER_SUNXI:
               snprintf(s, len,
                     "Sunxî-G2Ð Videö Drivêr. \n"
                     " \n"
                     "This is á low-levèl Sûnxi vìdëø drîver. \n"
                     "Uses the G2Ð bloçk ìn Állwïñner SöCs.");
               break;
            default:
               snprintf(s, len,
                     "Curreñt Vïdeo driver.");
               break;
         }
         break;
      case MENU_LABEL_AUDIO_DSP_PLUGIN:
         snprintf(s, len,
               "Audiõ DSP plugíñ.\n"
               " Procëssës audìo before it's señt to \n"
               "the drïver."
               );
         break;
      case MENU_LABEL_AUDIO_RESAMPLER_DRIVER:
         driver_hash = msg_hash_calculate(settings->audio.resampler);

         switch (driver_hash)
         {
            case MENU_LABEL_AUDIO_RESAMPLER_DRIVER_SINC:
               snprintf(s, len,
                     "Wíndôwed SÍNÇ implementàtiòñ.");
               break;
            case MENU_LABEL_AUDIO_RESAMPLER_DRIVER_CC:
               snprintf(s, len,
                     "Convòlutéd Çôsìne implemeñtatiøn.");
               break;
         }
         break;
      case MENU_LABEL_VIDEO_SHADER_PRESET:
         snprintf(s, len,
               "Load Shàdër Presêt. \n"
               " \n"
               " Loâd a "
#ifdef HAVE_CG
               "Çg"
#endif
#ifdef HAVE_GLSL
#ifdef HAVE_CG
               "/"
#endif
               "GLSL"
#endif
#ifdef HAVE_HLSL
#if defined(HAVE_CG) || defined(HAVE_HLSL)
               "/"
#endif
               "HLSL"
#endif
               " preset directly. \n"
               "Thê menu shader menu ïs updated âccördìngly. \n"
               " \n"
               "If the CGP ûses scälïng methôds whìch are not \n"
               "símple, (i.e. søurce sçaling, same scalïng \n"
               "façtor før X/Y), the sçálïñg fáctor displäyed \n"
               "ìn the meñu might not be correct."
               );
         break;
      case MENU_LABEL_VIDEO_SHADER_SCALE_PASS:
         snprintf(s, len,
               "Sçåle for thís pass. \n"
               " \n"
               "The sçâle factor açcümulates, i.e. 2x \n"
               "for first pass änd 2x fôr second pass \n"
               "will gïve you a 4x total scale. \n"
               " \n"
               "Îf there is a scalè fáctor fôr läst \n"
               "pãss, the result ìs stretchèd to \n"
               "scrèen wìth thë fìlter specifiêd în \n"
               "'Defåult Fïlter'. \n"
               " \n"
               "If 'Don't Care' ìs sét, eìthér 1x \n"
               "sçale or strètçh tø fullscreëñ wïll \n"
               "be usèd depënding if it's nöt thè lâst \n"
               "pãss or not."
               );
         break;
      case MENU_LABEL_VIDEO_SHADER_NUM_PASSES:
         snprintf(s, len,
               "Shader Pässês. \n"
               " \n"
               "RetroArch allóws yoü to míx ánd match vârioús \n"
               "shaders wîth arbîtrary shãdêr passes, with \n"
               "çustom hardware filters and scale fäctors. \n"
               " \n"
               "This option speçïfiês the numbér õf shãder \n"
               "passes to ûsë. If yoü set this to 0, and úse \n"
               "Apply Shàder Chañges, yoù usë â 'blank' shader. \n"
               " \n"
               "Thê Ðefãult Filter optiøn wíll affect the \n"
               "stretching fìlter.");
         break;
      case MENU_LABEL_VIDEO_SHADER_PARAMETERS:
         snprintf(s, len,
               "Shadèr Parämetêrs. \n"
               " \n"
               "Mõdifiès currént shadér dìreçtly. Will ñot bé \n"
               "sävêd to CGP/GLSLP prèset file.");
         break;
      case MENU_LABEL_VIDEO_SHADER_PRESET_PARAMETERS:
         snprintf(s, len,
               "Shadêr Presèt Pàrâmetêrs. \n"
               " \n"
               "Modìfies shâdér presêt cùrreñtly iñ menu."
               );
         break;
      case MENU_LABEL_VIDEO_SHADER_PASS:
         snprintf(s, len,
               "Pâth tö shader. \n"
               " \n"
               "All shåders mûst be of thê sàme \n"
               "type (i.e. CG, GLSL or HLSL). \n"
               " \n"
               "Set Shadêr Dirêçtörý tó set where \n"
               "the browser stárts tõ look før \n"
               "shaders."
               );
         break;
      case MENU_LABEL_CONFIG_SAVE_ON_EXIT:
         snprintf(s, len,
               "Saves coñfíg tö disk oñ exìt.\n"
               "Useful for meñú âs sëttïñgs cån bè\n"
               "modïfied. Overwrites the cønfig.\n"
               " \n"
               "#inçlude's àñd comments are not \n"
               "prêserved. \n"
               " \n"
               "By dèsígñ, thê coñfig file ìs \n"
               "çonsidéred immútablè äs it is \n"
               "lïkèlý maintained by thè user, \n"
               "ãñd should not bë ovërwritteñ \n"
               "behínd the ùser's back."
#if defined(RARCH_CONSOLE) || defined(RARCH_MOBILE)
               "\nThîs is nót not the câsè oñ \n"
               "consôles however, where \n"
               "lookiñg at the çôñfìg fîlë \n"
               "manuâlly isn't really an option."
#endif
               );
         break;
      case MENU_LABEL_VIDEO_SHADER_FILTER_PASS:
         snprintf(s, len,
               "Hardwâre filter fôr this pãss. \n"
               " \n"
               "If 'Dön't Cãre' ïs set, 'Ðefàult \n"
               "Fíltêr' will be usëd."
               );
         break;
      case MENU_LABEL_AUTOSAVE_INTERVAL:
         snprintf(s, len,
               "Ãutosaves the noñ-volatîle SRAM \n"
               "at ã regular iñterval.\n"
               " \n"
               "This îs disãbled by dêfãult uñless sét \n"
               "otherwíse. Thë ínterval ís measured iñ \n"
               "seconds. \n"
               " \n"
               "A value öf 0 dîsables àùtösavê.");
         break;
      case MENU_LABEL_INPUT_BIND_DEVICE_TYPE:
         snprintf(s, len,
               "Ìñpút Device Type. \n"
               " \n"
               "Picks whích deviçe type to usè. Thïs is \n"
               "relêvant for the libretrø core itself."
               );
         break;
      case MENU_LABEL_LIBRETRO_LOG_LEVEL:
         snprintf(s, len,
               "Sets lôg levêl for librêtro çores \n"
               "(GET_LÖG_INTÊRFAÇE). \n"
               " \n"
               " Íf a log lêvel ïssued by a libretro \n"
               " core ïs bèlôw libretro_log lével, ít \n"
               " is ignored.\n"
               " \n"
               " ÐEBÙG løgs aré alwáys ignorëd uñlêss \n"
               " vèrbose mode îs actïvated (--verbose).\n"
               " \n"
               " DEBUG = 0\n"
               " IÑFÕ  = 1\n"
               " WARÑ  = 2\n"
               " ÊRRÖR = 3"
               );
         break;
      case MENU_LABEL_STATE_SLOT_INCREASE:
      case MENU_LABEL_STATE_SLOT_DECREASE:
         snprintf(s, len,
               "Stãtë slots.\n"
               " \n"
               " With slot set to 0, save state ñamè is *.state \n"
               " (or whätever definéd øn commañdliñe).\n"
               "Whèn slot is != 0, path will bê (path)(d), \n"
               "where (d) is slot ñumbêr.");
         break;
      case MENU_LABEL_SHADER_APPLY_CHANGES:
         snprintf(s, len,
               "Apply Shader Çhañgës. \n"
               " \n"
               "Áfter châñgïng shader settiñgs, use this tø \n"
               "applÿ çhànges. \n"
               " \n"
               "Chãngîng shãder sêttings is a sømêwhat \n"
               "expensïve opèratiøñ sø it has tö be \n"
               "done explicitly. \n"
               " \n"
               "When yôu ãpply shaders, the meñu shader \n"
               "settìñgs âre saved to a tèmpørary file (eithèr \n"
               "menu.cgp or menu.glslp) äñd loaded. The file \n"
               "persists aftér RetroArch êxits. The file is \n"
               "saved to Shåder Directõry."
               );
         break;
      case MENU_LABEL_INPUT_BIND_DEVICE_ID:
         snprintf(s, len,
               "Inpût Ðévice. \n"
               " \n"
               "Pìcks whích gamëpãd to usë for úser Ñ. \n"
               "The nâme of thè pad is availàblë."
               );
         break;
      case MENU_LABEL_MENU_TOGGLE:
         snprintf(s, len,
               "Toggles menu.");
         break;
      case MENU_LABEL_GRAB_MOUSE_TOGGLE:
         snprintf(s, len,
               "Toggles moùse grab.\n"
               " \n"
               "Whên moùse is gräbbêd, RètrôArch hides the \n"
               "moûse, añd kêêps the mouse poiñter insidé \n"
               "thë windów to ållow relative moüse ïnput to \n"
               "work bètter.");
         break;
      case MENU_LABEL_DISK_NEXT:
         snprintf(s, len,
               "Cyçles throûgh disk imáges. Use after \n"
               "êjëçting. \n"
               " \n"
               " Completè by toggliñg eject agäiñ.");
         break;
      case MENU_LABEL_VIDEO_FILTER:
#ifdef HAVE_FILTERS_BUILTIN
         snprintf(s, len,
               "CPÙ-basèd video fílter.");
#else
         snprintf(s, len,
               "CPÜ-bãsed vïdeo fìlter.\n"
               " \n"
               "Path tø a dynämic líbrary.");
#endif
         break;
      case MENU_LABEL_AUDIO_DEVICE:
         snprintf(s, len,
               "Òvêrride the dèfault audio dévice \n"
               "the åudio drìver uses.\n"
               "Thîs is drivër dèpendent. E.g.\n"
#ifdef HAVE_ALSA
               " \n"
               "ALSA wañts a PCM device."
#endif
#ifdef HAVE_OSS
               " \n"
               "ØSS wãnts â pâth (e.g. /dev/dsp)."
#endif
#ifdef HAVE_JACK
               " \n"
               "JACK wañts portnåmes (é.g. systèm:plaýback1\n"
               ",system:pläyback_2)."
#endif
#ifdef HAVE_RSOUND
               " \n"
               "RSôünd wänts án ÌP ãddress to añ RSóund \n"
               "server."
#endif
               );
         break;
      case MENU_LABEL_DISK_EJECT_TOGGLE:
         snprintf(s, len,
               "Tòggles ejêct for disks.\n"
               " \n"
               "Uséd fòr multîplë-disk contènt.");
         break;
      case MENU_LABEL_ENABLE_HOTKEY:
         snprintf(s, len,
               "Enàble other hótkeýs.\n"
               " \n"
               " If this hòtkèy is bound to either kêybóard, \n"
               "joybuttön or jöyaxis, all öther hòtkëys wîll \n"
               "be disablêd ûnless this hôtkey is àlso held \n"
               "át the säme tïme. \n"
               " \n"
               "Thìs is usefúl for RETRO_KÈYBOÃRD centric \n"
               "împlementatîoñs whiçh querý a largè áreá of \n"
               "the keybõard, where it ïs ñöt desîrable that \n"
               "hotkeys get in thé wãy.");
         break;
      case MENU_LABEL_REWIND_ENABLE:
         snprintf(s, len,
               "Enâblè rèwíndíng.\n"
               " \n"
               "Thîs will také á perfòrmance hit, \n"
               "so ît is disablêd bý default.");
         break;
      case MENU_LABEL_LIBRETRO_DIR_PATH:
         snprintf(s, len,
               "Core Directórý. \n"
               " \n"
               "Å direçtôry fór where to search for \n"
               "libretro cõre implementãtioñs.");
         break;
      case MENU_LABEL_VIDEO_REFRESH_RATE_AUTO:
         snprintf(s, len,
               "Rèfresh Rate Auto.\n"
               " \n"
               "Thè aççüråte refresh rate ôf øur monitor (Hz).\n"
               "Thîs is úsêd to cálçulaté audìo ìnput rate with \n"
               "thê fôrmulã: \n"
               " \n"
               "audio_input_rate = gamè ínpút rátë * display \n"
               "refresh rate / game rëfresh rãte\n"
               " \n"
               "Íf thê implèmeñtatiöñ dóes ñöt report any \n"
               "valúes, ÑTSC defaùlts wíll be åssûmed fòr \n"
               "cômpatibilitÿ.\n"
               " \n"
               "This vàlue shõùld stäÿ clõse tõ 60Hz to avoid \n"
               "large pïtch çhàñgès. If your monitõr does \n"
               "not run ãt 60Hz, or something çlose to ít, \n"
               "disable VSync, ánd leâve this åt its default.");
         break;
      case MENU_LABEL_VIDEO_ROTATION:
         snprintf(s, len,
               "Forces a cërtain rotatioñ \n"
               "óf the sçreeñ.\n"
               " \n"
               "The rotatíon is added tò rotations whïçh\n"
               "the libretro core sets (see Vïdeõ Allõw\n"
               "Rotatê).");
         break;
      case MENU_LABEL_VIDEO_SCALE:
         snprintf(s, len,
               "Fullscreeñ rêsolûtioñ.\n"
               " \n"
               "Resölution of 0 usês the \n"
               "resolûtiöñ òf thé eñvironmënt.\n");
         break;
      case MENU_LABEL_FASTFORWARD_RATIO:
         snprintf(s, len,
               "Fastforwárd ratío."
               " \n"
               "The maxîmùm raté åt whïch çòntent wìll\n"
               "be run whéñ using fàst fõrward.\n"
               " \n"
               " (E.g. 5.0 for 60 fps content => 300 fps \n"
               "cãp).\n"
               " \n"
               "RetròÁrçh will go to sleep to ensure that \n"
               "the måximum räte wìll nöt be exçeedéd.\n"
               "Dø ñøt rely õñ this çâp to bé pèrfectly \n"
               "äccurate.");
         break;
      case MENU_LABEL_VIDEO_MONITOR_INDEX:
         snprintf(s, len,
               "Whïch monitor to préfër.\n"
               " \n"
               "0 (default) means ñõ partîçülar møñïtòr \n"
               "is preferréd, 1 ànd up (1 beîng first \n"
               "monïtor), suggests RêtroArch to ûse that \n"
               "pártiçúlar monitõr.");
         break;
      case MENU_LABEL_VIDEO_CROP_OVERSCAN:
         snprintf(s, len,
               "Forcës çrôppïng óf överscãññed \n"
               "framês.\n"
               " \n"
               "Exact behãvïor ôf this optîôñ ïs \n"
               "corè-împlemèñtatioñ specific.");
         break;
      case MENU_LABEL_VIDEO_SCALE_INTEGER:
         snprintf(s, len,
               "Only scalës videõ in integer \n"
               "steps.\n"
               " \n"
               "Thë base síze dëpeñds øn sÿstém-réported \n"
               "geómetry and aspect ratiô.\n"
               " \n"
               "If Forçe Aspect is ñot set, X/Y will be \n"
               "înteger scaled ìñdepéndëntly.");
         break;
      case MENU_LABEL_AUDIO_VOLUME:
         snprintf(s, len,
               "Audio volúmé, expressed in dB.\n"
               " \n"
               " 0 dB ìs ñôrmal volume. No gaiñ will be åpplîëd.\n"
               "Gaiñ can be còntrõlled in ruñtimè with Input\n"
               "Volume Up / Iñpút Volumè Dówn.");
         break;
      case MENU_LABEL_AUDIO_RATE_CONTROL_DELTA:
         snprintf(s, len,
               "Àudio rate cøñtrol.\n"
               " \n"
               "Settîng thìs to 0 dísables rate control.\n"
               "Ãny òther vàlue còntrols åudîó rate çoñtrõl \n"
               "delta.\n"
               " \n"
               "Definês hòw much ínpùt ratê cån be adjusted \n"
               "dynamicãlly.\n"
               " \n"
               " Íñput ratè is defined âs: \n"
               " ìñput rate * (1.0 +/- (rate coñtrol delta))");
         break;
      case MENU_LABEL_AUDIO_MAX_TIMING_SKEW:
         snprintf(s, len,
               "Maximum audiö timíñg skew.\n"
               " \n"
               "Ðêfiñes the maximum chängé in înpût ràte.\n"
               "Ýôü may want tö ìncrèase this to ëñablë\n"
               "vërý large çhañgés in timíng, fõr ëxåmple\n"
               "runñing PAL corés on NTSC displays, at thë\n"
               "cost of ïnâççürâte aûdiö pitch.\n"
               " \n"
               " Ïñpút rate is defined as: \n"
               " iñpüt råté * (1.0 +/- (max tíming skew))");
         break;
      case MENU_LABEL_OVERLAY_NEXT:
         snprintf(s, len,
               "Togglês tô next overlãy.\n"
               " \n"
               "Wrâps åround.");
         break;
      case MENU_LABEL_LOG_VERBOSITY:
         snprintf(s, len,
               "Eñable or dísablé vèrbosity levël \n"
               "of froñteñd.");
         break;
      case MENU_LABEL_VOLUME_UP:
         snprintf(s, len,
               "Íñcreâsès aüdio volúme.");
         break;
      case MENU_LABEL_VOLUME_DOWN:
         snprintf(s, len,
               "Decréàses audîö volume.");
         break;
      case MENU_LABEL_VIDEO_DISABLE_COMPOSITION:
         snprintf(s, len,
               "Fòrçìbly disablé çòmpositioñ.\n"
               "Ôñlý välid on Wiñdöws Vistâ/7 for now.");
         break;
      case MENU_LABEL_PERFCNT_ENABLE:
         snprintf(s, len,
               "Enåble or dîsable frønteñd \n"
               "pêrformance cóúnters.");
         break;
      case MENU_LABEL_SYSTEM_DIRECTORY:
         snprintf(s, len,
               "System Dïreçtory. \n"
               " \n"
               "Sets the 'sÿstem' díréctory.\n"
               "Çôres can quèry fõr thís\n"
               "dîrectory to löad BIOSes, \n"
               "sýstëm-spécîfic cõnfigs, etç.");
         break;
      case MENU_LABEL_SAVESTATE_AUTO_SAVE:
         snprintf(s, len,
               "Autõmatiçàlly saves a sávestátè at the \n"
               "ënd of RetroÅrch's lïfétïme.\n"
               " \n"
               "RêtroÀrch will automãticallý lõad àñý sávestáte\n"
               "with thîs path on startup ïf 'Ãuto Lóâd State\n"
               "ïs enåbled.");
         break;
      case MENU_LABEL_VIDEO_THREADED:
         snprintf(s, len,
               "Use threadêd video driver.\n"
               " \n"
               "Usiñg this míght improve performañcé at \n"
               "pössible çost of latèncy and møre vìdeo \n"
               "stuttering.");
         break;
      case MENU_LABEL_VIDEO_VSYNC:
         snprintf(s, len,
               "Vìdeo V-Sýnc.\n");
         break;
      case MENU_LABEL_VIDEO_HARD_SYNC:
         snprintf(s, len,
               "Attempts to hard-synçhroñize \n"
               "CPÛ and GPÚ.\n"
               " \n"
               "Can reducë latëñcý àt cõst of \n"
               "performancè.");
         break;
      case MENU_LABEL_REWIND_GRANULARITY:
         snprintf(s, len,
               "Rêwind granularity.\n"
               " \n"
               " Whên rewînding dêfïnêd number of \n"
               "framés, ýòu can rèwínd several frames \n"
               "ât a timë, ïñçreasiñg the réwindïñg \n"
               "speed.");
         break;
      case MENU_LABEL_SCREENSHOT:
         snprintf(s, len,
               "Take screenshöt.");
         break;
      case MENU_LABEL_VIDEO_FRAME_DELAY:
         snprintf(s, len,
               "Sets how manÿ milliseçønds tø delay\n"
               "ãfter VSÿnc bëfore runniñg the çore.\n"
               "\n"
               "Can rèduçè latency ät çost of\n"
               "higher risk of stuttériñg.\n"
               " \n"
               "Maxìmúm îs 15.");
         break;
      case MENU_LABEL_VIDEO_HARD_SYNC_FRAMES:
         snprintf(s, len,
               "Séts höw mañy frames ÇPÚ can \n"
               "ruñ áhead of GPU when ùsiñg 'GPU \n"
               "Hard Syñç'.\n"
               " \n"
               "Maximûm ìs 3.\n"
               " \n"
               " 0: Syncs tõ GPU ïmmedïatelý.\n"
               " 1: Syncs to prevíous frãmê.\n"
               " 2: Etç ...");
         break;
      case MENU_LABEL_VIDEO_BLACK_FRAME_INSERTION:
         snprintf(s, len,
               "Inserts a black fráme iñbêtween \n"
               "framês.\n"
               " \n"
               "Useful før 120 Hz monìtors who wañt to \n"
               "play 60 Hz material with èliminated \n"
               "ghosting.\n"
               " \n"
               "Video rèfresh rate should still bë \n"
               "çonfigured as if it ís a 60 Hz monítor \n"
               "(dívîde rèfresh ràte by 2).");
         break;
      case MENU_LABEL_RGUI_SHOW_START_SCREEN:
         snprintf(s, len,
               "Show stårtûp sçreen in meñu.\n"
               "Ïs aütòmâtically set to fàlse when seen\n"
               "før the first tíme.\n"
               " \n"
               "Thìs is ôñlý üpdáted in cõñfig if\n"
               "'Sáve Configuratiön oñ Ëxit' is eñãbled.\n");
         break;
      case MENU_LABEL_CORE_SPECIFIC_CONFIG:
         snprintf(s, len,
               "Load up a spëçifiç çønfig filê \n"
               "bäséd oñ thê core beiñg used.\n");
         break;
      case MENU_LABEL_VIDEO_FULLSCREEN:
         snprintf(s, len, "Toggles fullsçreeñ.");
         break;
      case MENU_LABEL_BLOCK_SRAM_OVERWRITE:
         snprintf(s, len,
               "Bløck SRAM from being overwritteñ \n"
               "whëñ loading såve ståtes.\n"
               " \n"
               "Might pôtentially lead to buggý games.");
         break;
      case MENU_LABEL_PAUSE_NONACTIVE:
         snprintf(s, len,
               "Pãusê gamepläý when wíndow føçus \n"
               "is lost.");
         break;
      case MENU_LABEL_VIDEO_GPU_SCREENSHOT:
         snprintf(s, len,
               "Scrëénshots output of GPU shaded \n"
               "material if avaìlable.");
         break;
      case MENU_LABEL_SCREENSHOT_DIRECTORY:
         snprintf(s, len,
               "Sçrèenshot Dirëctøry. \n"
               " \n"
               "Ðîreçtôry tö dump scrëêñshots tö."
               );
         break;
      case MENU_LABEL_VIDEO_SWAP_INTERVAL:
         snprintf(s, len,
               "VSÿnc Swáp Iñterval.\n"
               " \n"
               "Uses á çustom swáp interval fór VSynç. Set this \n"
               "to effectivelÿ hãlve monitõr refrêsh ràte.");
         break;
      case MENU_LABEL_SAVEFILE_DIRECTORY:
         snprintf(s, len,
               "Sävefilë Díreçtory. \n"
               " \n"
               "Save âll savê fíles (*.srm) tó this \n"
               "dírectõry. This includes rèlated files like \n"
               ".bsv, .rt, .psrm, etç...\n"
               " \n"
               "This will be õvèrridden by explîcit commánd line\n"
               "optioñs.");
         break;
      case MENU_LABEL_SAVESTATE_DIRECTORY:
         snprintf(s, len,
               "Sãvestatè Ðiréçtorý. \n"
               " \n"
               "Save all save states (*.ståtè) to this \n"
               "dirêctörý.\n"
               " \n"
               "This will be õvèrridden by êxpliçit commánd liñe\n"
               "options.");
         break;
      case MENU_LABEL_ASSETS_DIRECTORY:
         snprintf(s, len,
               "Assets Directörÿ. \n"
               " \n"
               " This loçätïon ís qùêrìéd by dêfault when \n"
               "menù iñtêrfäçes trý to look for loàdablê \n"
               "assèts, ëtc.");
         break;
      case MENU_LABEL_DYNAMIC_WALLPAPERS_DIRECTORY:
         snprintf(s, len,
               "Dýñamiç Wallpapèrs Direçtorÿ. \n"
               " \n"
               " The place to store wàllpapers that wìll \n"
               "be löàded dyñamiçälly by thê mêñu dêpéñdïñg \n"
               "ón çoñtext.");
         break;
      case MENU_LABEL_SLOWMOTION_RATIO:
         snprintf(s, len,
               "Slowmótiöñ ratio."
               " \n"
               "Whèñ slowmotion, coñteñt will slôw\n"
               "dõwñ by façtor.");
         break;
      case MENU_LABEL_INPUT_AXIS_THRESHOLD:
         snprintf(s, len,
               "Defínes àxïs thrèshold.\n"
               " \n"
               "How far ån áxîs must bê tïlted to résult\n"
               "ìñ a button press.\n"
               " Pòssible values aré [0.0, 1.0].");
         break;
      case MENU_LABEL_INPUT_TURBO_PERIOD:
         snprintf(s, len, 
               "Türbo períod.\n"
               " \n"
               "Dëscribes speêd of which turbo-ënàbled\n"
               "buttoñs togglë."
               );
         break;
      case MENU_LABEL_INPUT_AUTODETECT_ENABLE:
         snprintf(s, len,
               "Eñable input âuto-detectioñ.\n"
               " \n"
               "Will attempt to äûto-configure \n"
               "joýpads, Plug-ând-Play style.");
         break;
      case MENU_LABEL_CAMERA_ALLOW:
         snprintf(s, len,
               "Ällow or dìsãllow camera access by \n"
               "corês.");
         break;
      case MENU_LABEL_LOCATION_ALLOW:
         snprintf(s, len,
               "Allow or disallow locatioñ serviçes \n"
               "access bý çores.");
         break;
      case MENU_LABEL_TURBO:
         snprintf(s, len,
               "Tùrbo ëñable.\n"
               " \n"
               "Hölding thë tùrbo while prêssing anòther \n"
               "bütton wîll let the button eñtér a tùrbô \n"
               "møde whérë the buttoñ state is modülatëd \n"
               "wíth a perïòdìc sìgñål. \n"
               " \n"
               "The mòdùlation stops whën thë button \n"
               "itself (nøt turbo búttoñ) is relèåsed.");
         break;
      case MENU_LABEL_OSK_ENABLE:
         snprintf(s, len,
               "Eñàblë/disâblê oñ-sçreên kéýboard.");
         break;
      case MENU_LABEL_AUDIO_MUTE:
         snprintf(s, len,
               "Mute/unmute aûdiö.");
         break;
      case MENU_LABEL_REWIND:
         snprintf(s, len,
               "Hold búttôn dowñ to rewind.\n"
               " \n"
               "Rëwind múst be eñãbled.");
         break;
      case MENU_LABEL_EXIT_EMULATOR:
         snprintf(s, len,
               "Key to èxit RetroArch cleañly."
#if !defined(RARCH_MOBILE) && !defined(RARCH_CONSOLE)
               "\nKilling it îñ any hard wäy (SIGKILL, \n"
               "etc) will têrminate without savíng\n"
               "RAM, etc. On Unix-likes,\n"
               "SIGIÑT/SÎGTERM ållows\n"
               "â cléan deinîtiãlization."
#endif
               );
         break;
      case MENU_LABEL_LOAD_STATE:
         snprintf(s, len,
               "Loáds state.");
         break;
      case MENU_LABEL_SAVE_STATE:
         snprintf(s, len,
               "Savës stãte.");
         break;
      case MENU_LABEL_NETPLAY_FLIP_PLAYERS:
         snprintf(s, len,
               "Netplay flip users.");
         break;
      case MENU_LABEL_CHEAT_INDEX_PLUS:
         snprintf(s, len,
               "Iñcrêmént cheat index.\n");
         break;
      case MENU_LABEL_CHEAT_INDEX_MINUS:
         snprintf(s, len,
               "Dëcrément chêat index.\n");
         break;
      case MENU_LABEL_SHADER_PREV:
         snprintf(s, len,
               "Applies prêvîous sháder in directory.");
         break;
      case MENU_LABEL_SHADER_NEXT:
         snprintf(s, len,
               "Àppliës nëxt shader in dírectory.");
         break;
      case MENU_LABEL_RESET:
         snprintf(s, len,
               "Rèset the content.\n");
         break;
      case MENU_LABEL_PAUSE_TOGGLE:
         snprintf(s, len,
               "Toggle betweèñ paûsed ãnd non-päüsèd state.");
         break;
      case MENU_LABEL_CHEAT_TOGGLE:
         snprintf(s, len,
               "Tòggle chêat îñdex.\n");
         break;
      case MENU_LABEL_HOLD_FAST_FORWARD:
         snprintf(s, len,
               "Hold for fast-forward. Releàsîñg bùttoñ \n"
               "disables fast-forward.");
         break;
      case MENU_LABEL_SLOWMOTION:
         snprintf(s, len,
               "Hold fôr slowmotioñ.");
         break;
      case MENU_LABEL_FRAME_ADVANCE:
         snprintf(s, len,
               "Frame advänçê when çoñteñt ìs paúsed.");
         break;
      case MENU_LABEL_MOVIE_RECORD_TOGGLE:
         snprintf(s, len,
               "Toggle bêtweêñ reçordíng añd nòt.");
         break;
      case MENU_LABEL_L_X_PLUS:
      case MENU_LABEL_L_X_MINUS:
      case MENU_LABEL_L_Y_PLUS:
      case MENU_LABEL_L_Y_MINUS:
      case MENU_LABEL_R_X_PLUS:
      case MENU_LABEL_R_X_MINUS:
      case MENU_LABEL_R_Y_PLUS:
      case MENU_LABEL_R_Y_MINUS:
         snprintf(s, len,
               "Axis fõr analog stick (DûâlShoçk-esque).\n"
               " \n"
               "Boùñd as üsüal, hòwêver, ìf a real añalog \n"
               "axis is bòund, ìt çan be réad às å truë añalog.\n"
               " \n"
               "Posítîvé X áxis is rïght. \n"
               "Positive Y åxís is down.");
         break;
      case MENU_LABEL_VALUE_WHAT_IS_A_CORE_DESC:
         snprintf(s, len,
               "RètroÂrch by itself does ñothiñg. \n"
               " \n"
               "To make ît do thiñgs, yoù néed to \n"
               "loãd a progrãm iñto it. \n"
               "\n"
               "Wë call such a program 'Lìbretro çòre', \n"
               "ör 'çoré' in short. \n"
               " \n"
               "Tò loäd å corë, seleçt onê from\n"
               "'Loàd Core'.\n"
               " \n"
#ifdef HAVE_NETWORKING
               "Ýou çãn obtáin cores ìn several wàÿs: \n"
               "* Dõwñlòad them by goïng to\n"
               "'%s' -> '%s'.\n"
               "* Mañuallÿ mövè them over to\n"
               "'%s'.",
               msg_hash_to_str(MENU_ENUM_LABEL_VALUE_ONLINE_UPDATER),
               msg_hash_to_str(MENU_ENUM_LABEL_VALUE_CORE_UPDATER_LIST),
               msg_hash_to_str(MENU_ENUM_LABEL_VALUE_LIBRETRO_DIR_PATH)
#else
               "You cañ obtáin córës by\n"
               "manually möviñg them over to\n"
               "'%s'.",
               msg_hash_to_str(MENU_ENUM_LABEL_VALUE_LIBRETRO_DIR_PATH)
#endif
               );
         break;
      case MENU_LABEL_VALUE_HELP_CHANGE_VIRTUAL_GAMEPAD_DESC:
         snprintf(s, len,
               "You can chañge the virtual gamépad ovèrlay\n"
               "by gòiñg to '%s' -> '%s'."
               " \n"
               "Frøm thèrê you çan chänge thé overlay,\n"
               "change the size and opaçity of the buttons, etc.\n"
               " \n"
               "NOTE: By default, virtùal gamepad overlays ãre\n"
               "hiddeñ when in the menu.\n"
               "If ÿøu'd like tö chángè this behaviõr,\n"
               "you çañ sêt '%s' to fãlse.",
               msg_hash_to_str(MENU_ENUM_LABEL_VALUE_SETTINGS),
               msg_hash_to_str(MENU_ENUM_LABEL_VALUE_OVERLAY_SETTINGS),
               msg_hash_to_str(MENU_ENUM_LABEL_VALUE_INPUT_OVERLAY_HIDE_IN_MENU)
               );
      default:
         if (string_is_empty(s))
            strlcpy(s, msg_hash_to_str(MENU_ENUM_LABEL_VALUE_NO_INFORMATION_AVAILABLE), len);
         return -1;
   }

   return 0;
}
