"$.GtkObject" <- "$.GtkType" <- 
  #
  # might want to make the first letter of name lower case
  # so that, e.g.,  x$show() works rather than x$Show()
function(obj, name)
{
 .getAutoMethodByName(obj, name, c("Gtk", "gtk"))
}

"$.GdkEvent" <-
function(obj, name)
{
  .getAutoMethodByName(obj, name, c("Gdk", "gdk"))
}

.getAutoMethodByName <-
function(obj, name, prefix= c("Gtk", "gtk"))
{
 sym <- paste(gsub(prefix[1], prefix[2], class(obj)), name,sep="")
 which <- sapply(sym, exists)

 if(!any(which))
   stop(paste("No such method", name, "for classes", class(obj)))

 sym <- as.name(sym[which][1])

  # evaluate it to turn it into a function
  # and also get the correct environment
 eval(substitute( function(...) {
                     sym(obj, ...)  
                 }, list(obj=obj,sym=sym)))
}  

"[[.GtkObject" <-
  #
  # 
  #
function(obj, name)
{
  if(is.numeric(name)) {
    return(gtkChildren(obj)[[name]])
  }
  val <- try(.getAutoElementByName(obj, name, c("Gtk", "gtk"), error = FALSE))
  if(inherits(val, "try-error")) {
   val <- gtkObjectGetArgs(obj, name)
   if(length(val))
     val <- val[[1]]
  if(inherits(val, "GtkWidget"))
    class(val) <- gtkObjectGetClasses(val)
  }

  return(val)
}


"[[.GdkEvent" <-
function(obj, name)
{
 .getAutoElementByName(obj, name, c("Gdk", "gdk"))
}

.getAutoElementByName <-
function(obj, name, prefix = c("Gtk", "gtk"), error = TRUE)
{  
 sym <- paste(gsub(prefix[1], prefix[2], class(obj)), "Get", name,sep="")
 which <- sapply(sym, exists)

 if(!any(which)) {
   if(error)
     stop(paste("No such element/property", name,"for classes", class(obj)))
   else {
     v <- paste("No such element",name)
     class(v) <- "try-error"
     return(v)
   }
 }

 sym <- as.name(sym[which][1])

 v <- eval(substitute(sym(obj), list(sym=sym)))
 if(inherits(v, "GtkWidget"))
   class(v) <- gtkObjectGetClasses(v)

 v  
}


print.GtkType <-
function(x,...)
{
  print(names(x), ...)
}
