
gtkComboSetPopdownStrings <-
  #
  # strings should be a character vector
  #
function(combo, strings, .flush = TRUE)
{
  gtkCheckInherits(combo, "GtkCombo")
  strings <- as.character(strings)
  .GtkCall("R_gtkComboSetPopdownStrings", combo, strings)
}





gtkTextGetText <-
function(w)
{
 .Call("R_gtk_getTextContents", w)
}

gtkTextClearText <-
function(w, start=0, end=-1)
{
 .Call("R_gtk_clearTextContents", w, as.integer(c(start, end)))
}

gtkTextSetText <-
function(w, contents="", append = FALSE)
{
 if(append == FALSE) {
   gtkTextClearText(w)
 }

 .Call("R_gtk_setTextContents", w, as.character(contents), as.logical(append))
}



gtkObjectRef =
function(obj)
{
  gtkCheckInherits(obj, "GtkObject")  
 .GtkCall("R_gtk_object_ref", obj, TRUE) 
}

gtkObjectUnref =
function(obj)
{
  gtkCheckInherits(obj, "GtkObject")  
 .GtkCall("R_gtk_object_ref", obj, FALSE) 
}



findWidgetByType =
  #
  # Recursively search a widget tree for the first occurence of
  # a widget of the specified type.
  #
function(win, gtkType = "GtkMenuBar", verbose = FALSE)
{
 if(verbose)
   print(class(win))

 if(is.function(gtkType)) {
   if(gtkType(win))
     return(win)
 } else if(as.character(gtkType) %in% class(win)) {
     return(win)
 } 

 if("GtkContainer" %in% class(win)) {
  for(i in win$GetChildren()) {
   tmp = findWidgetByType(i, gtkType, verbose = verbose)
   if(!is.null(tmp))
     return(tmp)
  }
 }
 
 return(NULL)
}


gtkWidgetSetFlags =
function(w, val, flags = .GtkWidgetFlags)
{
  if(is.character(val)) {
     which = match(val, names(flags))
     if(any(is.na(which)))
       stop("Unrecognized flags", paste(val[is.na(which)], collapse=", "))

     which = flags[which]
  } else
     which = val


  if(! ("GtkWidget" %in% class(w)))
    stop("Expecting a GtkWidget object")
  
  .Call("R_gtkWidgetSetFlags", w, as.integer(which), PACKAGE = "RGtk")
}

gtkWidgetGetFlags =
function(w)
{
  gtkWidgetSetFlags(w, integer(0))
}


gtkColorSelectionGetColor  =
function(colorsel=NULL, .flush=TRUE)
{
   gtkCheckInherits(colorsel, "GtkColorSelection")
   w = .GtkCall("S_gtk_color_selection_get_color", colorsel, PACKAGE='RGtk', .flush = .flush)
   return(w)
}


# Contributed by  Luca Di Gaspero <l.digaspero@uniud.it>

gtkWidgetGetAllocatedSize <-
  function(obj)
  {
      gtkCheckInherits(obj, 'GtkWidget')
        v <- .Call('S_GtkWidgetGetAllocatedSize', obj)
        v
    }


gtkCListGetText <-
function(w, row, cols, zeroBased = TRUE)
{
  gtkCheckInherits(w, "GtkCList")

  if(missing(cols) && is.matrix(row) && ncol(row) == 2)
     which = row
  else
     which = cbind(row, cols)

  if(!zeroBased)
    which <- which - 1
  
  storage.mode(which) <- "integer"

  .Call("R_gtkCListGetText", w, as.integer(t(which)), PACKAGE = "RGtk")
}


gtkCListSetText <-
function(w, row, cols, values, zeroBased = TRUE)
{
  gtkCheckInherits(w, "GtkCList")  

  if(missing(cols) && is.matrix(row) && ncol(row) == 2)
     which = row
  else
     which = cbind(row, cols)

  if(!zeroBased)
    which <- which - 1
  
  storage.mode(which) <- "integer"

  values <- rep(as.character(values), length = nrow(which))
  
  invisible(.Call("R_gtkCListSetText", w, which, values, PACKAGE = "RGtk"))
}

gtkLabelGet =
function(label)
{
   gtkCheckInherits(label, "GtkLabel")
   w = .GtkCall("S_gtk_label_get", label, PACKAGE='RGtk', .flush = .flush)
   w
}

gtkLabelGet <-
function(w)
{
    gtkCheckInherits(w, "GtkLabel")
    .Call("R_gtkLabelGet", w, PACKAGE = 'RGtk')
}


