names.GtkObject <-
  #
  # return a vector of the names of the properties/args
  # available for the given GtkObject, collapsing over
  # all the inherited classes and removing the class::
  # prefix.
  #
function(x)
{
  names(gtkObjectGetArgInfo(x, parents = TRUE, collapse = TRUE, strip = TRUE))
}

gtkObjectGetArgInfo <-
  #
  # Could be done in S code more readily using
  # {l,s}apply(class(obj), getTypeArgInfo)
  #
  #
  #  strip is intended to remove the `class::'
  #  prefix. Can do this in R or in C.
  #
function(obj, parents = TRUE, collapse = FALSE, strip = FALSE)
{
  if(is.character(obj))
    obj <- gtkGetType(obj)
  
  if(inherits(obj, "GtkType"))
    type <- obj
  else {
    gtkCheckInherits(obj, "GtkObject")
    type <- gtkObjectGetType(obj)
  }
  v <- .Call("R_gtkGetObjectArgInfo", as.numeric(type), as.logical(parents))

  if(collapse) {
         # Merge into a new list (vals)
         # making certain not to overwrite values in
         # more specific classes with names
    vals <- list()
    sapply(v, function(x) {
                  which <- is.na(match(names(x), names(vals)))
                  if(strip) {
                    Names <- gsub("^.*::","",names(x)[which])
                  } else
                    Names <- names(x)[which]
                  vals[Names] <<- x[which]
              })
    v <- vals
    #
    #unlist(v, recursive = FALSE)
    # messes up the names.
  } else if(strip) {

    v <- lapply(v, function(x) {
                    names(x) <- gsub("^.*::","",names(x))
                    x
                  })
  }
  
  v
}  


gtkObjectGetArgs <-
function(obj, argNames)
{
   gtkCheckInherits(obj, "GtkObject")
   .Call("R_getObjectArgs", obj, as.character(argNames))
}

gtkObjectGetArg <-
function(obj, argName)
{
   gtkCheckInherits(obj, "GtkObject")
   v <- .Call("R_getObjectArgs", obj, as.character(argName))
   if(!is.null(v))
     v <- v[[1]]

   v
}


if(FALSE) {
"[[.GtkObject" <-
function(x, name)
{
 v <- gtkObjectGetArgs(x, name)
 if(length(v))
   v <- v[[1]]

 v
}
}

"[.GtkObject" <-
function(x, ...)
{
 gtkObjectGetArgs(x, c(...))
}  

gtkObjectSetArgs <-
function(obj, ..., .vals, .flush = TRUE)
{
  args <- list(...)
  gtkCheckInherits(obj, "GtkObject")
  argNames <- names(args)
  if(any(argNames == ""))
    stop("All values must have a name")

  invisible(.GtkCall("R_setObjectArgs", obj, args, argNames,.flush = .flush))
}


"[[<-.GtkObject" <-
function(x, name, value)
{
  .GtkCall("R_setObjectArgs", x, list(value), name,.flush = TRUE)

   x
}  
