genLoadClassesCode <-
  #
  # writes a C file containing a routine
  # that forces the loading of all Gtk classes
  # known from the defs object.
  # This can be used to get information about the type
  # without having to create an instance of that type.
  #
function(classes, fileName)
{
 if(!missing(fileName)) {
   f <- file(fileName)
   open(f, "w")
   on.exit(close(f))
 } else
   f <- stderr()

   # Get only the names of the classes
  if(is.list(classes)) {
     classNames <- names(classes)
  } else
     classNames <- as.character(classes)
 
  cat("#include <gtk/gtk.h>\n#include <gdk/gdk.h>\n", file = f)
  cat("\n\nvoid\n","loadGtkTypes()\n{\n\n", file = f, sep="")
  for(i in classNames) {
    cat("   ", collapseClassName(i), "_get_type", "();\n", file = f, sep="")
  }

  cat("\n}\n", file = f)

  invisible(NULL)
}
