#include "RGtk.h"
#include "gtkUtils.h"

USER_OBJECT_
R_gtkDragDestSet(USER_OBJECT_ swidget, USER_OBJECT_ sflags,
		 USER_OBJECT_ stargets, USER_OBJECT_ sactions, USER_OBJECT_ isDest)
{

   GtkWidget *widget;
   int n_targets, i;
   GtkTargetEntry *targets;
   GdkDragAction actions;

   widget = GTK_WIDGET(getPtrValue(swidget));

   n_targets = GET_LENGTH(stargets);
   targets = (GtkTargetEntry *) R_alloc(n_targets, sizeof(GtkTargetEntry));
/*   targets = (GtkTargetEntry *) g_malloc(n_targets* sizeof(GtkTargetEntry)); */
   for(i = 0; i < n_targets; i++) {
       targets[i] = *((GtkTargetEntry*)getPtrValue(VECTOR_ELT(stargets, i)));
   }
   if(LOGICAL_DATA(isDest)[0])
      gtk_drag_dest_set(widget, INTEGER_DATA(sflags)[0], targets, n_targets, INTEGER_DATA(sactions)[0]);
   else
      gtk_drag_source_set(widget, INTEGER_DATA(sflags)[0], targets, n_targets, INTEGER_DATA(sactions)[0]);
   return(NULL_USER_OBJECT);
}


USER_OBJECT_
R_gtkSelectDataSet(USER_OBJECT_ s_selection_data, USER_OBJECT_ stype, USER_OBJECT_ sformat, USER_OBJECT_ sdata)
{
    GtkSelectionData *selection_data;
    gchar *data;
    gint format;
    GdkAtom type;

    selection_data = (GtkSelectionData *) getPtrValue(s_selection_data);    
    type = selection_data->type;

    data = g_strdup(CHAR_DEREF(STRING_ELT(sdata, 0)));
    format = INTEGER_DATA(sformat)[0];

    gtk_selection_data_set(selection_data, type, format, data, strlen(data));

    return(NULL_USER_OBJECT);
}


USER_OBJECT_
R_gtkSelectionDataField(USER_OBJECT_ self, USER_OBJECT_ sname)
{
    char *tmp = CHAR_DEREF(STRING_ELT(sname, 0));
    GtkSelectionData *data;
    USER_OBJECT_ ans;

    data = (GtkSelectionData*) getPtrValue(self);

    if(strcmp(tmp, "target") == 0) {
	ans = asRGdkAtom(data->target);
    } else if(strcmp(tmp, "type") == 0) {
	ans = asRGdkAtom(data->type);
    } else if(strcmp(tmp, "selection") == 0) {
	ans = asRGdkAtom(data->selection);
    } else if(strcmp(tmp, "format") == 0) {
        ans = asRInt(data->format);
    } else if(strcmp(tmp, "data") == 0) {
        ans = asRCharacter(data->data);
    } else if(strcmp(tmp, "length") == 0) {
        ans = asRInt(data->length);
    } else {
        PROBLEM "no such field %s in GtkSelectionData", tmp
        ERROR;
    }

    return(ans);
}
