#include "gtkUtils.h"
#include "gnomeuiFuncs.h"
#include "gnomeuiEnum.h"


#include "RGtk.h"

USER_OBJECT_
 S_gnome_dialog_set_default ( USER_OBJECT_ s_dialog, USER_OBJECT_ s_button )
{
   GnomeDialog * dialog = ( GnomeDialog * ) getPtrValue( s_dialog ) ;
   int button = INTEGER_DATA( s_button )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dialog_set_default ( dialog, button );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_scores_set_def_color ( USER_OBJECT_ s_gs, USER_OBJECT_ s_colour )
{
   GnomeScores * gs = ( GnomeScores * ) getPtrValue( s_gs ) ;
   GdkColor * colour = ( GdkColor * ) getPtrValue( s_colour ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_scores_set_def_color ( gs, colour );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_set_toolbar ( USER_OBJECT_ s_app, USER_OBJECT_ s_toolbar )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;
   GtkToolbar * toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_toolbar )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_app_set_toolbar ( app, toolbar );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_set_child_list_path ( USER_OBJECT_ s_mdi, USER_OBJECT_ s_path )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;
   string path = CHAR_DEREF( STRING_ELT( s_path , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_mdi_set_child_list_path ( mdi, path );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_get_client_area ( USER_OBJECT_ s_dock )
{
   GnomeDock * dock = ( GnomeDock * ) getPtrValue( s_dock ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dock_get_client_area ( dock );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_get_active_view ( USER_OBJECT_ s_mdi )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_mdi_get_active_view ( mdi );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dentry_edit_clear ( USER_OBJECT_ s_dee )
{
   GnomeDEntryEdit * dee = ( GnomeDEntryEdit * ) getPtrValue( s_dee ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dentry_edit_clear ( dee );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_unselect_icon ( USER_OBJECT_ s_gil, USER_OBJECT_ s_pos )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   int pos = INTEGER_DATA( s_pos )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_unselect_icon ( gil, pos );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_date_edit_set_popup_range ( USER_OBJECT_ s_gde, USER_OBJECT_ s_low_hour, USER_OBJECT_ s_up_hour )
{
   GnomeDateEdit * gde = ( GnomeDateEdit * ) getPtrValue( s_gde ) ;
   int low_hour = INTEGER_DATA( s_low_hour )[0] ;
   int up_hour = INTEGER_DATA( s_up_hour )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_date_edit_set_popup_range ( gde, low_hour, up_hour );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_error ( USER_OBJECT_ s_app, USER_OBJECT_ s_error )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;
   string error = CHAR_DEREF( STRING_ELT( s_error , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_app_error ( app, error );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_set_active_view ( USER_OBJECT_ s_mdi, USER_OBJECT_ s_view )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;
   GtkWidget * view = GTK_WIDGET ((GtkObject*) getPtrValue( s_view )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_mdi_set_active_view ( mdi, view );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clock_start ( USER_OBJECT_ s_gclock )
{
   GtkClock * gclock = GTK_CLOCK ((GtkObject*) getPtrValue( s_gclock )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clock_start ( gclock );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_font_picker_set_preview_text ( USER_OBJECT_ s_gfp, USER_OBJECT_ s_text )
{
   GnomeFontPicker * gfp = ( GnomeFontPicker * ) getPtrValue( s_gfp ) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_font_picker_set_preview_text ( gfp, text );


  return(_result);
}
 

USER_OBJECT_
 S_GNOME_APPBAR_INTERACTIVE ( USER_OBJECT_ s_appbar )
{
   GnomeAppBar * appbar = ( GnomeAppBar * ) getPtrValue( s_appbar ) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  GNOME_APPBAR_INTERACTIVE ( appbar );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dentry_edit_get_icon ( USER_OBJECT_ s_dee )
{
   GnomeDEntryEdit * dee = ( GnomeDEntryEdit * ) getPtrValue( s_dee ) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dentry_edit_get_icon ( dee );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_get_status ( USER_OBJECT_ s_animator )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;


    GnomeAnimatorStatus ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_animator_get_status ( animator );
   _result =  S_check_GnomeAnimatorStatus_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dentry_edit_child2 ( USER_OBJECT_ s_dee )
{
   GnomeDEntryEdit * dee = ( GnomeDEntryEdit * ) getPtrValue( s_dee ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dentry_edit_child2 ( dee );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dentry_edit_child1 ( USER_OBJECT_ s_dee )
{
   GnomeDEntryEdit * dee = ( GnomeDEntryEdit * ) getPtrValue( s_dee ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dentry_edit_child1 ( dee );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_color_picker_set_d ( USER_OBJECT_ s_cp, USER_OBJECT_ s_r, USER_OBJECT_ s_g, USER_OBJECT_ s_b, USER_OBJECT_ s_a )
{
   GnomeColorPicker * cp = ( GnomeColorPicker * ) getPtrValue( s_cp ) ;
   double r = NUMERIC_DATA( s_r )[0] ;
   double g = NUMERIC_DATA( s_g )[0] ;
   double b = NUMERIC_DATA( s_b )[0] ;
   double a = NUMERIC_DATA( s_a )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_color_picker_set_d ( cp, r, g, b, a );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_href_get_label ( USER_OBJECT_ s_href )
{
   GnomeHRef * href = ( GnomeHRef * ) getPtrValue( s_href ) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_href_get_label ( href );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_entry_gtk_entry ( USER_OBJECT_ s_ientry )
{
   GnomeIconEntry * ientry = ( GnomeIconEntry * ) getPtrValue( s_ientry ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_icon_entry_gtk_entry ( ientry );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_scores_set_current_player ( USER_OBJECT_ s_gs, USER_OBJECT_ s_index )
{
   GnomeScores * gs = ( GnomeScores * ) getPtrValue( s_gs ) ;
   int index = INTEGER_DATA( s_index )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_scores_set_current_player ( gs, index );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_paper_selector_get_left_margin ( USER_OBJECT_ s_gspaper )
{
   GnomePaperSelector * gspaper = ( GnomePaperSelector * ) getPtrValue( s_gspaper ) ;


    float ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_paper_selector_get_left_margin ( gspaper );
  _result = asRNumeric ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dialog_editable_enters ( USER_OBJECT_ s_dialog, USER_OBJECT_ s_editable )
{
   GnomeDialog * dialog = ( GnomeDialog * ) getPtrValue( s_dialog ) ;
   GtkEditable * editable = GTK_EDITABLE ((GtkObject*) getPtrValue( s_editable )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dialog_editable_enters ( dialog, editable );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_set_current_directory ( USER_OBJECT_ s_client, USER_OBJECT_ s_dir )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;
   string dir = CHAR_DEREF( STRING_ELT( s_dir , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_client_set_current_directory ( client, dir );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_less_show_file ( USER_OBJECT_ s_less, USER_OBJECT_ s_path )
{
   GnomeLess * less = ( GnomeLess * ) getPtrValue( s_less ) ;
   string path = CHAR_DEREF( STRING_ELT( s_path , 0)) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_less_show_file ( less, path );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_paper_selector_get_name ( USER_OBJECT_ s_gspaper )
{
   GnomePaperSelector * gspaper = ( GnomePaperSelector * ) getPtrValue( s_gspaper ) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_paper_selector_get_name ( gspaper );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_warning_dialog ( USER_OBJECT_ s_message )
{
   string message = CHAR_DEREF( STRING_ELT( s_message , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_warning_dialog ( message );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_appbar_refresh ( USER_OBJECT_ s_appbar )
{
   GnomeAppBar * appbar = ( GnomeAppBar * ) getPtrValue( s_appbar ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_appbar_refresh ( appbar );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_calculator_clear ( USER_OBJECT_ s_calc, USER_OBJECT_ s_reset )
{
   GnomeCalculator * calc = ( GnomeCalculator * ) getPtrValue( s_calc ) ;
   Rboolean reset = LOGICAL_DATA( s_reset )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_calculator_clear ( calc, reset );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_get_playback_direction ( USER_OBJECT_ s_animator )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_animator_get_playback_direction ( animator );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_unregister ( USER_OBJECT_ s_mdi, USER_OBJECT_ s_obj )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;
   GtkObject * obj = GTK_OBJECT ((GtkObject*) getPtrValue( s_obj )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_mdi_unregister ( mdi, obj );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_spell_kill ( USER_OBJECT_ s_spell )
{
   GnomeSpell * spell = ( GnomeSpell * ) getPtrValue( s_spell ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_spell_kill ( spell );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_set_playback_direction ( USER_OBJECT_ s_animator, USER_OBJECT_ s_playback_direction )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;
   int playback_direction = INTEGER_DATA( s_playback_direction )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_animator_set_playback_direction ( animator, playback_direction );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dentry_edit_get_name ( USER_OBJECT_ s_dee )
{
   GnomeDEntryEdit * dee = ( GnomeDEntryEdit * ) getPtrValue( s_dee ) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dentry_edit_get_name ( dee );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_cloned_client (  )
{


    GnomeClient * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_cloned_client (  );
   _result = toRPointer(ans, "GnomeClient");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_dial_set_percentage ( USER_OBJECT_ s_dial, USER_OBJECT_ s_percent )
{
   GtkDial * dial = GTK_DIAL ((GtkObject*) getPtrValue( s_dial )) ;
   float percent = NUMERIC_DATA( s_percent )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_dial_set_percentage ( dial, percent );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_finish_set_text_color ( USER_OBJECT_ s_page, USER_OBJECT_ s_colour )
{
   GnomeDruidPageFinish * page = ( GnomeDruidPageFinish * ) getPtrValue( s_page ) ;
   GdkColor * colour = ( GdkColor * ) getPtrValue( s_colour ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_finish_set_text_color ( page, colour );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_less_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_less_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_appbar_set_prompt ( USER_OBJECT_ s_appbar, USER_OBJECT_ s_prompt, USER_OBJECT_ s_modal )
{
   GnomeAppBar * appbar = ( GnomeAppBar * ) getPtrValue( s_appbar ) ;
   string prompt = CHAR_DEREF( STRING_ELT( s_prompt , 0)) ;
   Rboolean modal = LOGICAL_DATA( s_modal )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_appbar_set_prompt ( appbar, prompt, modal );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_font_picker_uw_set_widget ( USER_OBJECT_ s_gfp, USER_OBJECT_ s_widget )
{
   GnomeFontPicker * gfp = ( GnomeFontPicker * ) getPtrValue( s_gfp ) ;
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_font_picker_uw_set_widget ( gfp, widget );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_remove_menu_range ( USER_OBJECT_ s_app, USER_OBJECT_ s_path, USER_OBJECT_ s_start, USER_OBJECT_ s_items )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;
   string path = CHAR_DEREF( STRING_ELT( s_path , 0)) ;
   int start = INTEGER_DATA( s_start )[0] ;
   int items = INTEGER_DATA( s_items )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_app_remove_menu_range ( app, path, start, items );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_property_box_append_page ( USER_OBJECT_ s_property_box, USER_OBJECT_ s_child, USER_OBJECT_ s_tab_label )
{
   GnomePropertyBox * property_box = ( GnomePropertyBox * ) getPtrValue( s_property_box ) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   GtkWidget * tab_label = GTK_WIDGET ((GtkObject*) getPtrValue( s_tab_label )) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_property_box_append_page ( property_box, child, tab_label );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_item_grab ( USER_OBJECT_ s_item, USER_OBJECT_ s_mask, USER_OBJECT_ s_cursor, USER_OBJECT_ s_etime )
{
   GnomeCanvasItem * item = ( GnomeCanvasItem * ) getPtrValue( s_item ) ;
   GdkEventMask mask = ( GdkEventMask ) INTEGER_DATA( s_mask )[0] ;
   GdkCursor * cursor = ( GdkCursor * ) getPtrValue( s_cursor ) ;
   unsigned int etime = INTEGER_DATA( s_etime )[0] ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_canvas_item_grab ( item, mask, cursor, etime );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_back ( USER_OBJECT_ s_druid_page )
{
   GnomeDruidPage * druid_page = ( GnomeDruidPage * ) getPtrValue( s_druid_page ) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_druid_page_back ( druid_page );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_get_view_from_window ( USER_OBJECT_ s_mdi, USER_OBJECT_ s_app_win )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;
   GnomeApp * app_win = ( GnomeApp * ) getPtrValue( s_app_win ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_mdi_get_view_from_window ( mdi, app_win );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_add_toplevel_view ( USER_OBJECT_ s_mdi, USER_OBJECT_ s_child )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;
   GnomeMDIChild * child = ( GnomeMDIChild * ) getPtrValue( s_child ) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_mdi_add_toplevel_view ( mdi, child );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_dial_set_update_policy ( USER_OBJECT_ s_dial, USER_OBJECT_ s_policy )
{
   GtkDial * dial = GTK_DIAL ((GtkObject*) getPtrValue( s_dial )) ;
   GtkUpdateType policy = ( GtkUpdateType ) INTEGER_DATA( s_policy )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_dial_set_update_policy ( dial, policy );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_append_frames_from_file_at_size ( USER_OBJECT_ s_animator, USER_OBJECT_ s_name, USER_OBJECT_ s_x_offset, USER_OBJECT_ s_y_offset, USER_OBJECT_ s_interval, USER_OBJECT_ s_x_unit, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;
   int x_offset = INTEGER_DATA( s_x_offset )[0] ;
   int y_offset = INTEGER_DATA( s_y_offset )[0] ;
   unsigned int interval = INTEGER_DATA( s_interval )[0] ;
   int x_unit = INTEGER_DATA( s_x_unit )[0] ;
   unsigned int width = INTEGER_DATA( s_width )[0] ;
   unsigned int height = INTEGER_DATA( s_height )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_animator_append_frames_from_file_at_size ( animator, name, x_offset, y_offset, interval, x_unit, width, height );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_paper_selector_get_width ( USER_OBJECT_ s_gspaper )
{
   GnomePaperSelector * gspaper = ( GnomePaperSelector * ) getPtrValue( s_gspaper ) ;


    float ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_paper_selector_get_width ( gspaper );
  _result = asRNumeric ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_item_set_shadow_type ( USER_OBJECT_ s_item, USER_OBJECT_ s_type )
{
   GnomeDockItem * item = ( GnomeDockItem * ) getPtrValue( s_item ) ;
   GtkShadowType type = ( GtkShadowType ) INTEGER_DATA( s_type )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dock_item_set_shadow_type ( item, type );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clock_set_format ( USER_OBJECT_ s_gclock, USER_OBJECT_ s_fmt )
{
   GtkClock * gclock = GTK_CLOCK ((GtkObject*) getPtrValue( s_gclock )) ;
   string fmt = CHAR_DEREF( STRING_ELT( s_fmt , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clock_set_format ( gclock, fmt );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_number_entry_set_title ( USER_OBJECT_ s_nentry, USER_OBJECT_ s_calc_dialog_title )
{
   GnomeNumberEntry * nentry = ( GnomeNumberEntry * ) getPtrValue( s_nentry ) ;
   string calc_dialog_title = CHAR_DEREF( STRING_ELT( s_calc_dialog_title , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_number_entry_set_title ( nentry, calc_dialog_title );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_append_frame_from_file ( USER_OBJECT_ s_animator, USER_OBJECT_ s_name, USER_OBJECT_ s_x_offset, USER_OBJECT_ s_y_offset, USER_OBJECT_ s_interval )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;
   int x_offset = INTEGER_DATA( s_x_offset )[0] ;
   int y_offset = INTEGER_DATA( s_y_offset )[0] ;
   unsigned int interval = INTEGER_DATA( s_interval )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_animator_append_frame_from_file ( animator, name, x_offset, y_offset, interval );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_get_global_config_prefix ( USER_OBJECT_ s_client )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_client_get_global_config_prefix ( client );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_stock_or_ordinary_button ( USER_OBJECT_ s_type )
{
   string type = CHAR_DEREF( STRING_ELT( s_type , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_stock_or_ordinary_button ( type );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_band_prepend ( USER_OBJECT_ s_band, USER_OBJECT_ s_child, USER_OBJECT_ s_offset )
{
   GnomeDockBand * band = ( GnomeDockBand * ) getPtrValue( s_band ) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   unsigned int offset = INTEGER_DATA( s_offset )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dock_band_prepend ( band, child, offset );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_band_insert ( USER_OBJECT_ s_band, USER_OBJECT_ s_child, USER_OBJECT_ s_offset, USER_OBJECT_ s_position )
{
   GnomeDockBand * band = ( GnomeDockBand * ) getPtrValue( s_band ) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   unsigned int offset = INTEGER_DATA( s_offset )[0] ;
   int position = INTEGER_DATA( s_position )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dock_band_insert ( band, child, offset, position );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dentry_get_tryexec_entry ( USER_OBJECT_ s_dee )
{
   GnomeDEntryEdit * dee = ( GnomeDEntryEdit * ) getPtrValue( s_dee ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dentry_get_tryexec_entry ( dee );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_druid_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_dial_get_adjustment ( USER_OBJECT_ s_dial )
{
   GtkDial * dial = GTK_DIAL ((GtkObject*) getPtrValue( s_dial )) ;


    GtkAdjustment * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_dial_get_adjustment ( dial );
   _result = toRPointer(ans, "GtkAdjustment");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_set_environment ( USER_OBJECT_ s_client, USER_OBJECT_ s_name, USER_OBJECT_ s_value )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;
   string value = CHAR_DEREF( STRING_ELT( s_value , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_client_set_environment ( client, name, value );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_appbar_set_progress ( USER_OBJECT_ s_appbar, USER_OBJECT_ s_percentage )
{
   GnomeAppBar * appbar = ( GnomeAppBar * ) getPtrValue( s_appbar ) ;
   float percentage = NUMERIC_DATA( s_percentage )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_appbar_set_progress ( appbar, percentage );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_append_page ( USER_OBJECT_ s_druid, USER_OBJECT_ s_page )
{
   GnomeDruid * druid = ( GnomeDruid * ) getPtrValue( s_druid ) ;
   GnomeDruidPage * page = ( GnomeDruidPage * ) getPtrValue( s_page ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_append_page ( druid, page );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dialog_set_accelerator ( USER_OBJECT_ s_dialog, USER_OBJECT_ s_button, USER_OBJECT_ s_accelerator_key, USER_OBJECT_ s_accelerator_mods )
{
   GnomeDialog * dialog = ( GnomeDialog * ) getPtrValue( s_dialog ) ;
   int button = INTEGER_DATA( s_button )[0] ;
   unsigned int accelerator_key = INTEGER_DATA( s_accelerator_key )[0] ;
   GdkModifierType accelerator_mods = ( GdkModifierType ) INTEGER_DATA( s_accelerator_mods )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dialog_set_accelerator ( dialog, button, accelerator_key, accelerator_mods );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_stock_transparent_window ( USER_OBJECT_ s_icon, USER_OBJECT_ s_subtype )
{
   string icon = CHAR_DEREF( STRING_ELT( s_icon , 0)) ;
   string subtype = CHAR_DEREF( STRING_ELT( s_subtype , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_stock_transparent_window ( icon, subtype );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_entry_load_history ( USER_OBJECT_ s_gentry )
{
   GnomeEntry * gentry = ( GnomeEntry * ) getPtrValue( s_gentry ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_entry_load_history ( gentry );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_paper_selector_get_top_margin ( USER_OBJECT_ s_gspaper )
{
   GnomePaperSelector * gspaper = ( GnomePaperSelector * ) getPtrValue( s_gspaper ) ;


    float ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_paper_selector_get_top_margin ( gspaper );
  _result = asRNumeric ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_number_entry_gnome_entry ( USER_OBJECT_ s_nentry )
{
   GnomeNumberEntry * nentry = ( GnomeNumberEntry * ) getPtrValue( s_nentry ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_number_entry_gnome_entry ( nentry );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_text_item_get_text ( USER_OBJECT_ s_iti )
{
   GnomeIconTextItem * iti = ( GnomeIconTextItem * ) getPtrValue( s_iti ) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_icon_text_item_get_text ( iti );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_color_picker_set_use_alpha ( USER_OBJECT_ s_cp, USER_OBJECT_ s_use_alpha )
{
   GnomeColorPicker * cp = ( GnomeColorPicker * ) getPtrValue( s_cp ) ;
   Rboolean use_alpha = LOGICAL_DATA( s_use_alpha )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_color_picker_set_use_alpha ( cp, use_alpha );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_finish_set_text ( USER_OBJECT_ s_page, USER_OBJECT_ s_text )
{
   GnomeDruidPageFinish * page = ( GnomeDruidPageFinish * ) getPtrValue( s_page ) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_finish_set_text ( page, text );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_remove_view ( USER_OBJECT_ s_mdi, USER_OBJECT_ s_view, USER_OBJECT_ s_force )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;
   GtkWidget * view = GTK_WIDGET ((GtkObject*) getPtrValue( s_view )) ;
   int force = INTEGER_DATA( s_force )[0] ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_mdi_remove_view ( mdi, view, force );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_start_set_watermark ( USER_OBJECT_ s_page, USER_OBJECT_ s_image )
{
   GnomeDruidPageStart * page = ( GnomeDruidPageStart * ) getPtrValue( s_page ) ;
   GdkImlibImage * image = ( GdkImlibImage * ) getPtrValue( s_image ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_start_set_watermark ( page, image );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_entry_new ( USER_OBJECT_ s_history_id, USER_OBJECT_ s_browse_dialog_title, USER_OBJECT_ s_do_preview )
{
   string history_id = CHAR_DEREF( STRING_ELT( s_history_id , 0)) ;
   string browse_dialog_title = CHAR_DEREF( STRING_ELT( s_browse_dialog_title , 0)) ;
   Rboolean do_preview = LOGICAL_DATA( s_do_preview )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_pixmap_entry_new ( history_id, browse_dialog_title, do_preview );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_connect ( USER_OBJECT_ s_client )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_client_connect ( client );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_entry_gnome_entry ( USER_OBJECT_ s_pentry )
{
   GnomePixmapEntry * pentry = ( GnomePixmapEntry * ) getPtrValue( s_pentry ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_pixmap_entry_gnome_entry ( pentry );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_dial_get_value ( USER_OBJECT_ s_dial )
{
   GtkDial * dial = GTK_DIAL ((GtkObject*) getPtrValue( s_dial )) ;


    float ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_dial_get_value ( dial );
  _result = asRNumeric ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_band_get_num_children ( USER_OBJECT_ s_band )
{
   GnomeDockBand * band = ( GnomeDockBand * ) getPtrValue( s_band ) ;


    unsigned int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dock_band_get_num_children ( band );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_advance ( USER_OBJECT_ s_animator, USER_OBJECT_ s_num )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;
   int num = INTEGER_DATA( s_num )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_animator_advance ( animator, num );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_set_program ( USER_OBJECT_ s_client, USER_OBJECT_ s_program )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;
   string program = CHAR_DEREF( STRING_ELT( s_program , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_client_set_program ( client, program );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_get_id ( USER_OBJECT_ s_client )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_client_get_id ( client );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_remove_menus ( USER_OBJECT_ s_app, USER_OBJECT_ s_path, USER_OBJECT_ s_items )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;
   string path = CHAR_DEREF( STRING_ELT( s_path , 0)) ;
   int items = INTEGER_DATA( s_items )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_app_remove_menus ( app, path, items );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_entry_set_history_id ( USER_OBJECT_ s_gentry, USER_OBJECT_ s_history_id )
{
   GnomeEntry * gentry = ( GnomeEntry * ) getPtrValue( s_gentry ) ;
   string history_id = CHAR_DEREF( STRING_ELT( s_history_id , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_entry_set_history_id ( gentry, history_id );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_spell_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_spell_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dock_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_entry_set_preview ( USER_OBJECT_ s_pentry, USER_OBJECT_ s_do_preview )
{
   GnomePixmapEntry * pentry = ( GnomePixmapEntry * ) getPtrValue( s_pentry ) ;
   Rboolean do_preview = LOGICAL_DATA( s_do_preview )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_pixmap_entry_set_preview ( pentry, do_preview );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_item_ungrab ( USER_OBJECT_ s_item, USER_OBJECT_ s_etime )
{
   GnomeCanvasItem * item = ( GnomeCanvasItem * ) getPtrValue( s_item ) ;
   unsigned int etime = INTEGER_DATA( s_etime )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_canvas_item_ungrab ( item, etime );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_new_with_size ( USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   unsigned int width = INTEGER_DATA( s_width )[0] ;
   unsigned int height = INTEGER_DATA( s_height )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_animator_new_with_size ( width, height );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_less_set_fixed_font ( USER_OBJECT_ s_less, USER_OBJECT_ s_fixed )
{
   GnomeLess * less = ( GnomeLess * ) getPtrValue( s_less ) ;
   Rboolean fixed = LOGICAL_DATA( s_fixed )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_less_set_fixed_font ( less, fixed );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_start_set_bg_color ( USER_OBJECT_ s_page, USER_OBJECT_ s_colour )
{
   GnomeDruidPageStart * page = ( GnomeDruidPageStart * ) getPtrValue( s_page ) ;
   GdkColor * colour = ( GdkColor * ) getPtrValue( s_colour ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_start_set_bg_color ( page, colour );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_band_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dock_band_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_selection_show_icons ( USER_OBJECT_ s_gis )
{
   GnomeIconSelection * gis = ( GnomeIconSelection * ) getPtrValue( s_gis ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_selection_show_icons ( gis );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_item_grab_focus ( USER_OBJECT_ s_item )
{
   GnomeCanvasItem * item = ( GnomeCanvasItem * ) getPtrValue( s_item ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_canvas_item_grab_focus ( item );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_font_picker_set_title ( USER_OBJECT_ s_gfp, USER_OBJECT_ s_title )
{
   GnomeFontPicker * gfp = ( GnomeFontPicker * ) getPtrValue( s_gfp ) ;
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_font_picker_set_title ( gfp, title );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_appbar_get_response ( USER_OBJECT_ s_appbar )
{
   GnomeAppBar * appbar = ( GnomeAppBar * ) getPtrValue( s_appbar ) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_appbar_get_response ( appbar );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_appbar_pop ( USER_OBJECT_ s_appbar )
{
   GnomeAppBar * appbar = ( GnomeAppBar * ) getPtrValue( s_appbar ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_appbar_pop ( appbar );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_number_entry_get_number ( USER_OBJECT_ s_nentry )
{
   GnomeNumberEntry * nentry = ( GnomeNumberEntry * ) getPtrValue( s_nentry ) ;


    double ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_number_entry_get_number ( nentry );
  _result = asRNumeric ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_standard_set_title ( USER_OBJECT_ s_page, USER_OBJECT_ s_title )
{
   GnomeDruidPageStandard * page = ( GnomeDruidPageStandard * ) getPtrValue( s_page ) ;
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_standard_set_title ( page, title );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_band_drag_end ( USER_OBJECT_ s_band, USER_OBJECT_ s_item )
{
   GnomeDockBand * band = ( GnomeDockBand * ) getPtrValue( s_band ) ;
   GnomeDockItem * item = ( GnomeDockItem * ) getPtrValue( s_item ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dock_band_drag_end ( band, item );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_get_dock_item_by_name ( USER_OBJECT_ s_app, USER_OBJECT_ s_name )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;


    GnomeDockItem * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_app_get_dock_item_by_name ( app, name );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_href_new ( USER_OBJECT_ s_url, USER_OBJECT_ s_label )
{
   string url = CHAR_DEREF( STRING_ELT( s_url , 0)) ;
   string label = CHAR_DEREF( STRING_ELT( s_label , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_href_new ( url, label );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_stock_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_stock_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_font_picker_fi_set_show_size ( USER_OBJECT_ s_gfp, USER_OBJECT_ s_show_size )
{
   GnomeFontPicker * gfp = ( GnomeFontPicker * ) getPtrValue( s_gfp ) ;
   Rboolean show_size = LOGICAL_DATA( s_show_size )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_font_picker_fi_set_show_size ( gfp, show_size );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_file_entry_set_default_path ( USER_OBJECT_ s_fentry, USER_OBJECT_ s_path )
{
   GnomeFileEntry * fentry = ( GnomeFileEntry * ) getPtrValue( s_fentry ) ;
   string path = CHAR_DEREF( STRING_ELT( s_path , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_file_entry_set_default_path ( fentry, path );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_add_child ( USER_OBJECT_ s_mdi, USER_OBJECT_ s_child )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;
   GnomeMDIChild * child = ( GnomeMDIChild * ) getPtrValue( s_child ) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_mdi_add_child ( mdi, child );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_set_id ( USER_OBJECT_ s_client, USER_OBJECT_ s_client_id )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;
   string client_id = CHAR_DEREF( STRING_ELT( s_client_id , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_client_set_id ( client, client_id );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_less_show_filestream ( USER_OBJECT_ s_less, USER_OBJECT_ s_fp )
{
   GnomeLess * less = ( GnomeLess * ) getPtrValue( s_less ) ;
   FILE * fp = ( FILE * ) getPtrValue( s_fp ) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_less_show_filestream ( less, fp );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_get_active_child ( USER_OBJECT_ s_mdi )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;


    GnomeMDIChild * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_mdi_get_active_child ( mdi );
   _result = toRPointer(ans, "GnomeMDIChild");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_date_edit_get_flags ( USER_OBJECT_ s_gde )
{
   GnomeDateEdit * gde = ( GnomeDateEdit * ) getPtrValue( s_gde ) ;


    GnomeDateEditFlags ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_date_edit_get_flags ( gde );
   _result =  S_check_GnomeDateEditFlags_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_item_get_child ( USER_OBJECT_ s_item )
{
   GnomeDockItem * item = ( GnomeDockItem * ) getPtrValue( s_item ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dock_item_get_child ( item );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ted_add ( USER_OBJECT_ s_ted, USER_OBJECT_ s_widget, USER_OBJECT_ s_name )
{
   GtkTed * ted = GTK_TED ((GtkObject*) getPtrValue( s_ted )) ;
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ted_add ( ted, widget, name );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_get_previous_id ( USER_OBJECT_ s_client )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_client_get_previous_id ( client );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_set_priority ( USER_OBJECT_ s_client, USER_OBJECT_ s_priority )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;
   unsigned int priority = INTEGER_DATA( s_priority )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_client_set_priority ( client, priority );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_interaction_key_return ( USER_OBJECT_ s_key, USER_OBJECT_ s_cancel_shutdown )
{
   int key = INTEGER_DATA( s_key )[0] ;
   Rboolean cancel_shutdown = LOGICAL_DATA( s_cancel_shutdown )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_interaction_key_return ( key, cancel_shutdown );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_cancel ( USER_OBJECT_ s_druid_page )
{
   GnomeDruidPage * druid_page = ( GnomeDruidPage * ) getPtrValue( s_druid_page ) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_druid_page_cancel ( druid_page );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_calculator_set ( USER_OBJECT_ s_calc, USER_OBJECT_ s_result )
{
   GnomeCalculator * calc = ( GnomeCalculator * ) getPtrValue( s_calc ) ;
   double result = NUMERIC_DATA( s_result )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_calculator_set ( calc, result );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_set_icon_width ( USER_OBJECT_ s_gil, USER_OBJECT_ s_width )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   int width = INTEGER_DATA( s_width )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_set_icon_width ( gil, width );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_finish_set_watermark ( USER_OBJECT_ s_page, USER_OBJECT_ s_image )
{
   GnomeDruidPageFinish * page = ( GnomeDruidPageFinish * ) getPtrValue( s_page ) ;
   GdkImlibImage * image = ( GdkImlibImage * ) getPtrValue( s_image ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_finish_set_watermark ( page, image );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_update_now ( USER_OBJECT_ s_canvas )
{
   GnomeCanvas * canvas = ( GnomeCanvas * ) getPtrValue( s_canvas ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_canvas_update_now ( canvas );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_append_imlib ( USER_OBJECT_ s_gil, USER_OBJECT_ s_image, USER_OBJECT_ s_text )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   GdkImlibImage * image = ( GdkImlibImage * ) getPtrValue( s_image ) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_icon_list_append_imlib ( gil, image, text );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_set_restart_style ( USER_OBJECT_ s_client, USER_OBJECT_ s_style )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;
   GnomeRestartStyle style = ( GnomeRestartStyle ) INTEGER_DATA( s_style )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_client_set_restart_style ( client, style );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_register ( USER_OBJECT_ s_mdi, USER_OBJECT_ s_obj )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;
   GtkObject * obj = GTK_OBJECT ((GtkObject*) getPtrValue( s_obj )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_mdi_register ( mdi, obj );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_font_picker_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_font_picker_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_start_set_title_color ( USER_OBJECT_ s_page, USER_OBJECT_ s_colour )
{
   GnomeDruidPageStart * page = ( GnomeDruidPageStart * ) getPtrValue( s_page ) ;
   GdkColor * colour = ( GdkColor * ) getPtrValue( s_colour ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_start_set_title_color ( page, colour );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_entry_gtk_entry ( USER_OBJECT_ s_gentry )
{
   GnomeEntry * gentry = ( GnomeEntry * ) getPtrValue( s_gentry ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_entry_gtk_entry ( gentry );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_standard_set_title_color ( USER_OBJECT_ s_page, USER_OBJECT_ s_colour )
{
   GnomeDruidPageStandard * page = ( GnomeDruidPageStandard * ) getPtrValue( s_page ) ;
   GdkColor * colour = ( GdkColor * ) getPtrValue( s_colour ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_standard_set_title_color ( page, colour );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_item_lower_to_bottom ( USER_OBJECT_ s_item )
{
   GnomeCanvasItem * item = ( GnomeCanvasItem * ) getPtrValue( s_item ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_canvas_item_lower_to_bottom ( item );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_finish_set_textbox_color ( USER_OBJECT_ s_page, USER_OBJECT_ s_colour )
{
   GnomeDruidPageFinish * page = ( GnomeDruidPageFinish * ) getPtrValue( s_page ) ;
   GdkColor * colour = ( GdkColor * ) getPtrValue( s_colour ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_finish_set_textbox_color ( page, colour );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_finish_set_logo_bg_color ( USER_OBJECT_ s_page, USER_OBJECT_ s_colour )
{
   GnomeDruidPageFinish * page = ( GnomeDruidPageFinish * ) getPtrValue( s_page ) ;
   GdkColor * colour = ( GdkColor * ) getPtrValue( s_colour ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_finish_set_logo_bg_color ( page, colour );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_dial_set_view_only ( USER_OBJECT_ s_dial, USER_OBJECT_ s_view_only )
{
   GtkDial * dial = GTK_DIAL ((GtkObject*) getPtrValue( s_dial )) ;
   Rboolean view_only = LOGICAL_DATA( s_view_only )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_dial_set_view_only ( dial, view_only );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_append_frame_from_imlib ( USER_OBJECT_ s_animator, USER_OBJECT_ s_image, USER_OBJECT_ s_x_offset, USER_OBJECT_ s_y_offset, USER_OBJECT_ s_interval )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;
   GdkImlibImage * image = ( GdkImlibImage * ) getPtrValue( s_image ) ;
   int x_offset = INTEGER_DATA( s_x_offset )[0] ;
   int y_offset = INTEGER_DATA( s_y_offset )[0] ;
   unsigned int interval = INTEGER_DATA( s_interval )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_animator_append_frame_from_imlib ( animator, image, x_offset, y_offset, interval );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_entry_new ( USER_OBJECT_ s_history_id, USER_OBJECT_ s_browse_dialog_title )
{
   string history_id = CHAR_DEREF( STRING_ELT( s_history_id , 0)) ;
   string browse_dialog_title = CHAR_DEREF( STRING_ELT( s_browse_dialog_title , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_icon_entry_new ( history_id, browse_dialog_title );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_band_get_child_offset ( USER_OBJECT_ s_band, USER_OBJECT_ s_child )
{
   GnomeDockBand * band = ( GnomeDockBand * ) getPtrValue( s_band ) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


    unsigned int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dock_band_get_child_offset ( band, child );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_disconnect ( USER_OBJECT_ s_client )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_client_disconnect ( client );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_add_dock_item ( USER_OBJECT_ s_app, USER_OBJECT_ s_item, USER_OBJECT_ s_placement, USER_OBJECT_ s_band_num, USER_OBJECT_ s_band_position, USER_OBJECT_ s_offset )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;
   GnomeDockItem * item = ( GnomeDockItem * ) getPtrValue( s_item ) ;
   GnomeDockPlacement placement = ( GnomeDockPlacement ) INTEGER_DATA( s_placement )[0] ;
   int band_num = INTEGER_DATA( s_band_num )[0] ;
   int band_position = INTEGER_DATA( s_band_position )[0] ;
   int offset = INTEGER_DATA( s_offset )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_app_add_dock_item ( app, item, placement, band_num, band_position, offset );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_item_get_behavior ( USER_OBJECT_ s_item )
{
   GnomeDockItem * item = ( GnomeDockItem * ) getPtrValue( s_item ) ;


    GnomeDockItemBehavior ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dock_item_get_behavior ( item );
   _result =  S_check_GnomeDockItemBehavior_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gnome_appbar_set_status ( USER_OBJECT_ s_appbar, USER_OBJECT_ s_status )
{
   GnomeAppBar * appbar = ( GnomeAppBar * ) getPtrValue( s_appbar ) ;
   string status = CHAR_DEREF( STRING_ELT( s_status , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_appbar_set_status ( appbar, status );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_start_set_text ( USER_OBJECT_ s_page, USER_OBJECT_ s_text )
{
   GnomeDruidPageStart * page = ( GnomeDruidPageStart * ) getPtrValue( s_page ) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_start_set_text ( page, text );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_text_item_select ( USER_OBJECT_ s_iti, USER_OBJECT_ s_sel )
{
   GnomeIconTextItem * iti = ( GnomeIconTextItem * ) getPtrValue( s_iti ) ;
   int sel = INTEGER_DATA( s_sel )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_text_item_select ( iti, sel );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_font_picker_set_mode ( USER_OBJECT_ s_gfp, USER_OBJECT_ s_mode )
{
   GnomeFontPicker * gfp = ( GnomeFontPicker * ) getPtrValue( s_gfp ) ;
   GnomeFontPickerMode mode = ( GnomeFontPickerMode ) INTEGER_DATA( s_mode )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_font_picker_set_mode ( gfp, mode );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_remove ( USER_OBJECT_ s_gil, USER_OBJECT_ s_pos )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   int pos = INTEGER_DATA( s_pos )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_remove ( gil, pos );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_less_set_font ( USER_OBJECT_ s_less, USER_OBJECT_ s_font )
{
   GnomeLess * less = ( GnomeLess * ) getPtrValue( s_less ) ;
   GdkFont * font = ( GdkFont * ) getPtrValue( s_font ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_less_set_font ( less, font );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_get_icon_at ( USER_OBJECT_ s_gil, USER_OBJECT_ s_x, USER_OBJECT_ s_y )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_icon_list_get_icon_at ( gil, x, y );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_set_page ( USER_OBJECT_ s_druid, USER_OBJECT_ s_page )
{
   GnomeDruid * druid = ( GnomeDruid * ) getPtrValue( s_druid ) ;
   GnomeDruidPage * page = ( GnomeDruidPage * ) getPtrValue( s_page ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_set_page ( druid, page );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_font_picker_get_font_name ( USER_OBJECT_ s_gfp )
{
   GnomeFontPicker * gfp = ( GnomeFontPicker * ) getPtrValue( s_gfp ) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_font_picker_get_font_name ( gfp );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_child_remove_view ( USER_OBJECT_ s_mdic, USER_OBJECT_ s_view )
{
   GnomeMDIChild * mdic = ( GnomeMDIChild * ) getPtrValue( s_mdic ) ;
   GtkWidget * view = GTK_WIDGET ((GtkObject*) getPtrValue( s_view )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_mdi_child_remove_view ( mdic, view );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_get_loop_type ( USER_OBJECT_ s_animator )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;


    GnomeAnimatorLoopType ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_animator_get_loop_type ( animator );
   _result =  S_check_GnomeAnimatorLoopType_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clock_set_seconds ( USER_OBJECT_ s_gclock, USER_OBJECT_ s_seconds )
{
   GtkClock * gclock = GTK_CLOCK ((GtkObject*) getPtrValue( s_gclock )) ;
   unsigned int seconds = INTEGER_DATA( s_seconds )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clock_set_seconds ( gclock, seconds );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_entry_gnome_file_entry ( USER_OBJECT_ s_pentry )
{
   GnomePixmapEntry * pentry = ( GnomePixmapEntry * ) getPtrValue( s_pentry ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_pixmap_entry_gnome_file_entry ( pentry );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_append_frame_from_gnome_pixmap ( USER_OBJECT_ s_animator, USER_OBJECT_ s_pixmap, USER_OBJECT_ s_x_offset, USER_OBJECT_ s_y_offset, USER_OBJECT_ s_interval )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;
   GnomePixmap * pixmap = ( GnomePixmap * ) getPtrValue( s_pixmap ) ;
   int x_offset = INTEGER_DATA( s_x_offset )[0] ;
   int y_offset = INTEGER_DATA( s_y_offset )[0] ;
   unsigned int interval = INTEGER_DATA( s_interval )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_animator_append_frame_from_gnome_pixmap ( animator, pixmap, x_offset, y_offset, interval );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_generic_child_new ( USER_OBJECT_ s_name )
{
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;


    GnomeMDIGenericChild * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_mdi_generic_child_new ( name );
   _result = toRPointer(ans, "GnomeMDIGenericChild");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_standard_set_bg_color ( USER_OBJECT_ s_page, USER_OBJECT_ s_colour )
{
   GnomeDruidPageStandard * page = ( GnomeDruidPageStandard * ) getPtrValue( s_page ) ;
   GdkColor * colour = ( GdkColor * ) getPtrValue( s_colour ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_standard_set_bg_color ( page, colour );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_date_edit_set_flags ( USER_OBJECT_ s_gde, USER_OBJECT_ s_flags )
{
   GnomeDateEdit * gde = ( GnomeDateEdit * ) getPtrValue( s_gde ) ;
   GnomeDateEditFlags flags = ( GnomeDateEditFlags ) INTEGER_DATA( s_flags )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_date_edit_set_flags ( gde, flags );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_new ( USER_OBJECT_ s_appname, USER_OBJECT_ s_title )
{
   string appname = CHAR_DEREF( STRING_ELT( s_appname , 0)) ;
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;


    GtkObject * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_mdi_new ( appname, title );
   _result = toRPointer(ans, "GtkObject");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_ok_dialog_parented ( USER_OBJECT_ s_message, USER_OBJECT_ s_parent )
{
   string message = CHAR_DEREF( STRING_ELT( s_message , 0)) ;
   GtkWindow * parent = GTK_WINDOW ((GtkObject*) getPtrValue( s_parent )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_ok_dialog_parented ( message, parent );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_start_set_logo_bg_color ( USER_OBJECT_ s_page, USER_OBJECT_ s_colour )
{
   GnomeDruidPageStart * page = ( GnomeDruidPageStart * ) getPtrValue( s_page ) ;
   GdkColor * colour = ( GdkColor * ) getPtrValue( s_colour ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_start_set_logo_bg_color ( page, colour );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clock_new ( USER_OBJECT_ s_type )
{
   GtkClockType type = ( GtkClockType ) INTEGER_DATA( s_type )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_clock_new ( type );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_request_phase_2 ( USER_OBJECT_ s_client )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_client_request_phase_2 ( client );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_flash ( USER_OBJECT_ s_app, USER_OBJECT_ s_flash )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;
   string flash = CHAR_DEREF( STRING_ELT( s_flash , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_app_flash ( app, flash );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_scroll_to ( USER_OBJECT_ s_canvas, USER_OBJECT_ s_cx, USER_OBJECT_ s_cy )
{
   GnomeCanvas * canvas = ( GnomeCanvas * ) getPtrValue( s_canvas ) ;
   int cx = INTEGER_DATA( s_cx )[0] ;
   int cy = INTEGER_DATA( s_cy )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_canvas_scroll_to ( canvas, cx, cy );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_error_dialog ( USER_OBJECT_ s_message )
{
   string message = CHAR_DEREF( STRING_ELT( s_message , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_error_dialog ( message );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_stock_menu_item ( USER_OBJECT_ s_type, USER_OBJECT_ s_text )
{
   string type = CHAR_DEREF( STRING_ELT( s_type , 0)) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_stock_menu_item ( type, text );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_enable_layout_config ( USER_OBJECT_ s_app, USER_OBJECT_ s_enable )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;
   Rboolean enable = LOGICAL_DATA( s_enable )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_app_enable_layout_config ( app, enable );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_next ( USER_OBJECT_ s_druid_page )
{
   GnomeDruidPage * druid_page = ( GnomeDruidPage * ) getPtrValue( s_druid_page ) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_druid_page_next ( druid_page );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_paper_selector_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_paper_selector_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_load_imlib ( USER_OBJECT_ s_gpixmap, USER_OBJECT_ s_image )
{
   GnomePixmap * gpixmap = ( GnomePixmap * ) getPtrValue( s_gpixmap ) ;
   GdkImlibImage * image = ( GdkImlibImage * ) getPtrValue( s_image ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_pixmap_load_imlib ( gpixmap, image );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_appbar_clear_prompt ( USER_OBJECT_ s_appbar )
{
   GnomeAppBar * appbar = ( GnomeAppBar * ) getPtrValue( s_appbar ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_appbar_clear_prompt ( appbar );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dentry_get_exec_entry ( USER_OBJECT_ s_dee )
{
   GnomeDEntryEdit * dee = ( GnomeDEntryEdit * ) getPtrValue( s_dee ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dentry_get_exec_entry ( dee );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_open_toplevel ( USER_OBJECT_ s_mdi )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_mdi_open_toplevel ( mdi );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_entry_set_pixmap_subdir ( USER_OBJECT_ s_ientry, USER_OBJECT_ s_subdir )
{
   GnomeIconEntry * ientry = ( GnomeIconEntry * ) getPtrValue( s_ientry ) ;
   string subdir = CHAR_DEREF( STRING_ELT( s_subdir , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_entry_set_pixmap_subdir ( ientry, subdir );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ted_set_app_name ( USER_OBJECT_ s_appname )
{
   string appname = CHAR_DEREF( STRING_ELT( s_appname , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ted_set_app_name ( appname );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_color_picker_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_color_picker_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_finish_new_with_vals ( USER_OBJECT_ s_title, USER_OBJECT_ s_text, USER_OBJECT_ s_logo, USER_OBJECT_ s_watermark )
{
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;
   GdkImlibImage * logo = ( GdkImlibImage * ) getPtrValue( s_logo ) ;
   GdkImlibImage * watermark = ( GdkImlibImage * ) getPtrValue( s_watermark ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_druid_page_finish_new_with_vals ( title, text, logo, watermark );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dentry_edit_new (  )
{


    GtkObject * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dentry_edit_new (  );
   _result = toRPointer(ans, "GtkObject");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_get_playback_speed ( USER_OBJECT_ s_animator )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;


    double ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_animator_get_playback_speed ( animator );
  _result = asRNumeric ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_standard_set_logo_bg_color ( USER_OBJECT_ s_page, USER_OBJECT_ s_colour )
{
   GnomeDruidPageStandard * page = ( GnomeDruidPageStandard * ) getPtrValue( s_page ) ;
   GdkColor * colour = ( GdkColor * ) getPtrValue( s_colour ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_standard_set_logo_bg_color ( page, colour );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_item_new ( USER_OBJECT_ s_name, USER_OBJECT_ s_behavior )
{
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;
   GnomeDockItemBehavior behavior = ( GnomeDockItemBehavior ) INTEGER_DATA( s_behavior )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dock_item_new ( name, behavior );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_paper_selector_get_right_margin ( USER_OBJECT_ s_gspaper )
{
   GnomePaperSelector * gspaper = ( GnomePaperSelector * ) getPtrValue( s_gspaper ) ;


    float ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_paper_selector_get_right_margin ( gspaper );
  _result = asRNumeric ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_add_item ( USER_OBJECT_ s_dock, USER_OBJECT_ s_item, USER_OBJECT_ s_placement, USER_OBJECT_ s_band_num, USER_OBJECT_ s_position, USER_OBJECT_ s_offset, USER_OBJECT_ s_in_new_band )
{
   GnomeDock * dock = ( GnomeDock * ) getPtrValue( s_dock ) ;
   GnomeDockItem * item = ( GnomeDockItem * ) getPtrValue( s_item ) ;
   GnomeDockPlacement placement = ( GnomeDockPlacement ) INTEGER_DATA( s_placement )[0] ;
   unsigned int band_num = INTEGER_DATA( s_band_num )[0] ;
   int position = INTEGER_DATA( s_position )[0] ;
   unsigned int offset = INTEGER_DATA( s_offset )[0] ;
   Rboolean in_new_band = LOGICAL_DATA( s_in_new_band )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dock_add_item ( dock, item, placement, band_num, position, offset, in_new_band );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_stock_new_with_icon ( USER_OBJECT_ s_icon )
{
   string icon = CHAR_DEREF( STRING_ELT( s_icon , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_stock_new_with_icon ( icon );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_finish_set_title ( USER_OBJECT_ s_page, USER_OBJECT_ s_title )
{
   GnomeDruidPageFinish * page = ( GnomeDruidPageFinish * ) getPtrValue( s_page ) ;
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_finish_set_title ( page, title );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_set_separators ( USER_OBJECT_ s_gil, USER_OBJECT_ s_separators )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   string separators = CHAR_DEREF( STRING_ELT( s_separators , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_set_separators ( gil, separators );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_dial_get_percentage ( USER_OBJECT_ s_dial )
{
   GtkDial * dial = GTK_DIAL ((GtkObject*) getPtrValue( s_dial )) ;


    float ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_dial_get_percentage ( dial );
  _result = asRNumeric ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dentry_get_doc_entry ( USER_OBJECT_ s_dee )
{
   GnomeDEntryEdit * dee = ( GnomeDEntryEdit * ) getPtrValue( s_dee ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dentry_get_doc_entry ( dee );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_set_col_spacing ( USER_OBJECT_ s_gil, USER_OBJECT_ s_pixels )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   int pixels = INTEGER_DATA( s_pixels )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_set_col_spacing ( gil, pixels );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_scores_set_color ( USER_OBJECT_ s_gs, USER_OBJECT_ s_pos, USER_OBJECT_ s_colour )
{
   GnomeScores * gs = ( GnomeScores * ) getPtrValue( s_gs ) ;
   unsigned int pos = INTEGER_DATA( s_pos )[0] ;
   GdkColor * colour = ( GdkColor * ) getPtrValue( s_colour ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_scores_set_color ( gs, pos, colour );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_load_file_at_size ( USER_OBJECT_ s_gpixmap, USER_OBJECT_ s_filename, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   GnomePixmap * gpixmap = ( GnomePixmap * ) getPtrValue( s_gpixmap ) ;
   string filename = CHAR_DEREF( STRING_ELT( s_filename , 0)) ;
   int width = INTEGER_DATA( s_width )[0] ;
   int height = INTEGER_DATA( s_height )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_pixmap_load_file_at_size ( gpixmap, filename, width, height );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_set_pixels_per_unit ( USER_OBJECT_ s_canvas, USER_OBJECT_ s_n )
{
   GnomeCanvas * canvas = ( GnomeCanvas * ) getPtrValue( s_canvas ) ;
   double n = NUMERIC_DATA( s_n )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_canvas_set_pixels_per_unit ( canvas, n );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dialog_close_hides ( USER_OBJECT_ s_dialog, USER_OBJECT_ s_just_hide )
{
   GnomeDialog * dialog = ( GnomeDialog * ) getPtrValue( s_dialog ) ;
   Rboolean just_hide = LOGICAL_DATA( s_just_hide )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dialog_close_hides ( dialog, just_hide );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_scores_display ( USER_OBJECT_ s_title, USER_OBJECT_ s_app_name, USER_OBJECT_ s_level, USER_OBJECT_ s_pos )
{
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;
   string app_name = CHAR_DEREF( STRING_ELT( s_app_name , 0)) ;
   string level = CHAR_DEREF( STRING_ELT( s_level , 0)) ;
   int pos = INTEGER_DATA( s_pos )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_scores_display ( title, app_name, level, pos );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_set_mode ( USER_OBJECT_ s_mdi, USER_OBJECT_ s_mode )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;
   GnomeMDIMode mode = ( GnomeMDIMode ) INTEGER_DATA( s_mode )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_mdi_set_mode ( mdi, mode );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_entry_get_filename ( USER_OBJECT_ s_ientry )
{
   GnomeIconEntry * ientry = ( GnomeIconEntry * ) getPtrValue( s_ientry ) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_icon_entry_get_filename ( ientry );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_property_box_changed ( USER_OBJECT_ s_property_box )
{
   GnomePropertyBox * property_box = ( GnomePropertyBox * ) getPtrValue( s_property_box ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_property_box_changed ( property_box );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_get_current_frame_number ( USER_OBJECT_ s_animator )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;


    unsigned int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_animator_get_current_frame_number ( animator );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_item_get_orientation ( USER_OBJECT_ s_item )
{
   GnomeDockItem * item = ( GnomeDockItem * ) getPtrValue( s_item ) ;


    GtkOrientation ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dock_item_get_orientation ( item );
   _result =  S_check_GtkOrientation_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gnome_file_entry_set_modal ( USER_OBJECT_ s_fentry, USER_OBJECT_ s_is_modal )
{
   GnomeFileEntry * fentry = ( GnomeFileEntry * ) getPtrValue( s_fentry ) ;
   Rboolean is_modal = LOGICAL_DATA( s_is_modal )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_file_entry_set_modal ( fentry, is_modal );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_new (  )
{


    GnomeClient * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_client_new (  );
   _result = toRPointer(ans, "GnomeClient");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_set_buttons_sensitive ( USER_OBJECT_ s_druid, USER_OBJECT_ s_back_sensitive, USER_OBJECT_ s_next_sensitive, USER_OBJECT_ s_cancel_sensitive )
{
   GnomeDruid * druid = ( GnomeDruid * ) getPtrValue( s_druid ) ;
   Rboolean back_sensitive = LOGICAL_DATA( s_back_sensitive )[0] ;
   Rboolean next_sensitive = LOGICAL_DATA( s_next_sensitive )[0] ;
   Rboolean cancel_sensitive = LOGICAL_DATA( s_cancel_sensitive )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_set_buttons_sensitive ( druid, back_sensitive, next_sensitive, cancel_sensitive );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_set_client_area ( USER_OBJECT_ s_dock, USER_OBJECT_ s_widget )
{
   GnomeDock * dock = ( GnomeDock * ) getPtrValue( s_dock ) ;
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dock_set_client_area ( dock, widget );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_file_entry_new ( USER_OBJECT_ s_history_id, USER_OBJECT_ s_browse_dialog_title )
{
   string history_id = CHAR_DEREF( STRING_ELT( s_history_id , 0)) ;
   string browse_dialog_title = CHAR_DEREF( STRING_ELT( s_browse_dialog_title , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_file_entry_new ( history_id, browse_dialog_title );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_href_get_url ( USER_OBJECT_ s_href )
{
   GnomeHRef * href = ( GnomeHRef * ) getPtrValue( s_href ) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_href_get_url ( href );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_dial_new ( USER_OBJECT_ s_adjustment )
{
   GtkAdjustment * adjustment = Rf_length( s_adjustment ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_dial_new ( adjustment );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_less_show_command ( USER_OBJECT_ s_less, USER_OBJECT_ s_command_line )
{
   GnomeLess * less = ( GnomeLess * ) getPtrValue( s_less ) ;
   string command_line = CHAR_DEREF( STRING_ELT( s_command_line , 0)) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_less_show_command ( less, command_line );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_get_app_from_view ( USER_OBJECT_ s_view )
{
   GtkWidget * view = GTK_WIDGET ((GtkObject*) getPtrValue( s_view )) ;


    GnomeApp * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_mdi_get_app_from_view ( view );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_number_entry_new ( USER_OBJECT_ s_history_id, USER_OBJECT_ s_calc_dialog_title )
{
   string history_id = CHAR_DEREF( STRING_ELT( s_history_id , 0)) ;
   string calc_dialog_title = CHAR_DEREF( STRING_ELT( s_calc_dialog_title , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_number_entry_new ( history_id, calc_dialog_title );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dialog_set_close ( USER_OBJECT_ s_dialog, USER_OBJECT_ s_click_closes )
{
   GnomeDialog * dialog = ( GnomeDialog * ) getPtrValue( s_dialog ) ;
   Rboolean click_closes = LOGICAL_DATA( s_click_closes )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dialog_set_close ( dialog, click_closes );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clock_stop ( USER_OBJECT_ s_gclock )
{
   GtkClock * gclock = GTK_CLOCK ((GtkObject*) getPtrValue( s_gclock )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clock_stop ( gclock );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_item_show ( USER_OBJECT_ s_item )
{
   GnomeCanvasItem * item = ( GnomeCanvasItem * ) getPtrValue( s_item ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_canvas_item_show ( item );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_selection_add_directory ( USER_OBJECT_ s_gis, USER_OBJECT_ s_dir )
{
   GnomeIconSelection * gis = ( GnomeIconSelection * ) getPtrValue( s_gis ) ;
   string dir = CHAR_DEREF( STRING_ELT( s_dir , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_selection_add_directory ( gis, dir );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_start_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_druid_page_start_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_item_lower ( USER_OBJECT_ s_item, USER_OBJECT_ s_positions )
{
   GnomeCanvasItem * item = ( GnomeCanvasItem * ) getPtrValue( s_item ) ;
   int positions = INTEGER_DATA( s_positions )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_canvas_item_lower ( item, positions );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dialog_set_sensitive ( USER_OBJECT_ s_dialog, USER_OBJECT_ s_button, USER_OBJECT_ s_setting )
{
   GnomeDialog * dialog = ( GnomeDialog * ) getPtrValue( s_dialog ) ;
   int button = INTEGER_DATA( s_button )[0] ;
   Rboolean setting = LOGICAL_DATA( s_setting )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dialog_set_sensitive ( dialog, button, setting );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_new_from_gnome_pixmap ( USER_OBJECT_ s_gpixmap )
{
   GnomePixmap * gpixmap = ( GnomePixmap * ) getPtrValue( s_gpixmap ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_pixmap_new_from_gnome_pixmap ( gpixmap );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_item_set_orientation ( USER_OBJECT_ s_item, USER_OBJECT_ s_orientation )
{
   GnomeDockItem * item = ( GnomeDockItem * ) getPtrValue( s_item ) ;
   GtkOrientation orientation = ( GtkOrientation ) INTEGER_DATA( s_orientation )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dock_item_set_orientation ( item, orientation );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_selection_clear ( USER_OBJECT_ s_gis, USER_OBJECT_ s_not_shown )
{
   GnomeIconSelection * gis = ( GnomeIconSelection * ) getPtrValue( s_gis ) ;
   Rboolean not_shown = LOGICAL_DATA( s_not_shown )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_selection_clear ( gis, not_shown );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_stop ( USER_OBJECT_ s_animator )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_animator_stop ( animator );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_new ( USER_OBJECT_ s_appname, USER_OBJECT_ s_title )
{
   string appname = CHAR_DEREF( STRING_ELT( s_appname , 0)) ;
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_app_new ( appname, title );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_add_floating_item ( USER_OBJECT_ s_dock, USER_OBJECT_ s_item, USER_OBJECT_ s_x, USER_OBJECT_ s_y, USER_OBJECT_ s_orientation )
{
   GnomeDock * dock = ( GnomeDock * ) getPtrValue( s_dock ) ;
   GnomeDockItem * item = ( GnomeDockItem * ) getPtrValue( s_item ) ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;
   GtkOrientation orientation = ( GtkOrientation ) INTEGER_DATA( s_orientation )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dock_add_floating_item ( dock, item, x, y, orientation );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_request_redraw ( USER_OBJECT_ s_canvas, USER_OBJECT_ s_x1, USER_OBJECT_ s_y1, USER_OBJECT_ s_x2, USER_OBJECT_ s_y2 )
{
   GnomeCanvas * canvas = ( GnomeCanvas * ) getPtrValue( s_canvas ) ;
   int x1 = INTEGER_DATA( s_x1 )[0] ;
   int y1 = INTEGER_DATA( s_y1 )[0] ;
   int x2 = INTEGER_DATA( s_x2 )[0] ;
   int y2 = INTEGER_DATA( s_y2 )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_canvas_request_redraw ( canvas, x1, y1, x2, y2 );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_set_vadjustment ( USER_OBJECT_ s_gil, USER_OBJECT_ s_vadj )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   GtkAdjustment * vadj = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_vadj )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_set_vadjustment ( gil, vadj );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_band_drag_begin ( USER_OBJECT_ s_band, USER_OBJECT_ s_item )
{
   GnomeDockBand * band = ( GnomeDockBand * ) getPtrValue( s_band ) ;
   GnomeDockItem * item = ( GnomeDockItem * ) getPtrValue( s_item ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dock_band_drag_begin ( band, item );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_set_selection_mode ( USER_OBJECT_ s_gil, USER_OBJECT_ s_mode )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   GtkSelectionMode mode = ( GtkSelectionMode ) INTEGER_DATA( s_mode )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_set_selection_mode ( gil, mode );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_set_playback_speed ( USER_OBJECT_ s_animator, USER_OBJECT_ s_speed )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;
   double speed = NUMERIC_DATA( s_speed )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_animator_set_playback_speed ( animator, speed );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_guru_current_page ( USER_OBJECT_ s_guru )
{
   GnomeGuru * guru = ( GnomeGuru * ) getPtrValue( s_guru ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_guru_current_page ( guru );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_canvas_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_dial_set_adjustment ( USER_OBJECT_ s_dial, USER_OBJECT_ s_adjustment )
{
   GtkDial * dial = GTK_DIAL ((GtkObject*) getPtrValue( s_dial )) ;
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_dial_set_adjustment ( dial, adjustment );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_get_active_window ( USER_OBJECT_ s_mdi )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;


    GnomeApp * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_mdi_get_active_window ( mdi );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dialog_run_and_close ( USER_OBJECT_ s_dialog )
{
   GnomeDialog * dialog = ( GnomeDialog * ) getPtrValue( s_dialog ) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dialog_run_and_close ( dialog );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_add_docked ( USER_OBJECT_ s_app, USER_OBJECT_ s_widget, USER_OBJECT_ s_name, USER_OBJECT_ s_behavior, USER_OBJECT_ s_placement, USER_OBJECT_ s_band_num, USER_OBJECT_ s_band_position, USER_OBJECT_ s_offset )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;
   GnomeDockItemBehavior behavior = ( GnomeDockItemBehavior ) INTEGER_DATA( s_behavior )[0] ;
   GnomeDockPlacement placement = ( GnomeDockPlacement ) INTEGER_DATA( s_placement )[0] ;
   int band_num = INTEGER_DATA( s_band_num )[0] ;
   int band_position = INTEGER_DATA( s_band_position )[0] ;
   int offset = INTEGER_DATA( s_offset )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_app_add_docked ( app, widget, name, behavior, placement, band_num, band_position, offset );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_warning ( USER_OBJECT_ s_app, USER_OBJECT_ s_warning )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;
   string warning = CHAR_DEREF( STRING_ELT( s_warning , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_app_warning ( app, warning );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_button ( USER_OBJECT_ s_pixmap, USER_OBJECT_ s_text )
{
   GtkWidget * pixmap = GTK_WIDGET ((GtkObject*) getPtrValue( s_pixmap )) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_pixmap_button ( pixmap, text );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_root ( USER_OBJECT_ s_canvas )
{
   GnomeCanvas * canvas = ( GnomeCanvas * ) getPtrValue( s_canvas ) ;


    GnomeCanvasGroup * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_canvas_root ( canvas );
   _result = toRPointer(ans, "GnomeCanvasGroup");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_clear ( USER_OBJECT_ s_gil )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_clear ( gil );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_load_imlib_at_size ( USER_OBJECT_ s_gpixmap, USER_OBJECT_ s_image, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   GnomePixmap * gpixmap = ( GnomePixmap * ) getPtrValue( s_gpixmap ) ;
   GdkImlibImage * image = ( GdkImlibImage * ) getPtrValue( s_image ) ;
   int width = INTEGER_DATA( s_width )[0] ;
   int height = INTEGER_DATA( s_height )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_pixmap_load_imlib_at_size ( gpixmap, image, width, height );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_allow_floating_items ( USER_OBJECT_ s_dock, USER_OBJECT_ s_enable )
{
   GnomeDock * dock = ( GnomeDock * ) getPtrValue( s_dock ) ;
   Rboolean enable = LOGICAL_DATA( s_enable )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dock_allow_floating_items ( dock, enable );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dialog_new ( USER_OBJECT_ s_title, USER_OBJECT_ s_b1, USER_OBJECT_ s_b2, USER_OBJECT_ s_b3, USER_OBJECT_ s_b4, USER_OBJECT_ s_b5, USER_OBJECT_ s_b6, USER_OBJECT_ s_b7, USER_OBJECT_ s_b8, USER_OBJECT_ s_b9, USER_OBJECT_ s_b10, USER_OBJECT_ s_b11 )
{
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;
   string b1 = CHAR_DEREF( STRING_ELT( s_b1 , 0)) ;
   string b2 = CHAR_DEREF( STRING_ELT( s_b2 , 0)) ;
   string b3 = CHAR_DEREF( STRING_ELT( s_b3 , 0)) ;
   string b4 = CHAR_DEREF( STRING_ELT( s_b4 , 0)) ;
   string b5 = CHAR_DEREF( STRING_ELT( s_b5 , 0)) ;
   string b6 = CHAR_DEREF( STRING_ELT( s_b6 , 0)) ;
   string b7 = CHAR_DEREF( STRING_ELT( s_b7 , 0)) ;
   string b8 = CHAR_DEREF( STRING_ELT( s_b8 , 0)) ;
   string b9 = CHAR_DEREF( STRING_ELT( s_b9 , 0)) ;
   string b10 = CHAR_DEREF( STRING_ELT( s_b10 , 0)) ;
   string b11 = CHAR_DEREF( STRING_ELT( s_b11 , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dialog_new ( title, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11 );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_dial_set_value ( USER_OBJECT_ s_dial, USER_OBJECT_ s_value )
{
   GtkDial * dial = GTK_DIAL ((GtkObject*) getPtrValue( s_dial )) ;
   float value = NUMERIC_DATA( s_value )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_dial_set_value ( dial, value );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_prepend_page ( USER_OBJECT_ s_druid, USER_OBJECT_ s_page )
{
   GnomeDruid * druid = ( GnomeDruid * ) getPtrValue( s_druid ) ;
   GnomeDruidPage * page = ( GnomeDruidPage * ) getPtrValue( s_page ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_prepend_page ( druid, page );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_paper_selector_get_height ( USER_OBJECT_ s_gspaper )
{
   GnomePaperSelector * gspaper = ( GnomePaperSelector * ) getPtrValue( s_gspaper ) ;


    float ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_paper_selector_get_height ( gspaper );
  _result = asRNumeric ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ted_new ( USER_OBJECT_ s_dialog_name )
{
   string dialog_name = CHAR_DEREF( STRING_ELT( s_dialog_name , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_ted_new ( dialog_name );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_standard_new_with_vals ( USER_OBJECT_ s_title, USER_OBJECT_ s_logo )
{
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;
   GdkImlibImage * logo = ( GdkImlibImage * ) getPtrValue( s_logo ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_druid_page_standard_new_with_vals ( title, logo );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_set_show_finish ( USER_OBJECT_ s_druid, USER_OBJECT_ s_show_finish )
{
   GnomeDruid * druid = ( GnomeDruid * ) getPtrValue( s_druid ) ;
   Rboolean show_finish = LOGICAL_DATA( s_show_finish )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_set_show_finish ( druid, show_finish );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_spell_check ( USER_OBJECT_ s_spell, USER_OBJECT_ s_str )
{
   GnomeSpell * spell = ( GnomeSpell * ) getPtrValue( s_spell ) ;
   string str = CHAR_DEREF( STRING_ELT( s_str , 0)) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_spell_check ( spell, str );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ted_prepare ( USER_OBJECT_ s_ted )
{
   GtkTed * ted = GTK_TED ((GtkObject*) getPtrValue( s_ted )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ted_prepare ( ted );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_set_text_spacing ( USER_OBJECT_ s_gil, USER_OBJECT_ s_pixels )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   int pixels = INTEGER_DATA( s_pixels )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_set_text_spacing ( gil, pixels );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_request_save ( USER_OBJECT_ s_client, USER_OBJECT_ s_save_style, USER_OBJECT_ s_shutdown, USER_OBJECT_ s_interact_style, USER_OBJECT_ s_fast, USER_OBJECT_ s_global )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;
   GnomeSaveStyle save_style = ( GnomeSaveStyle ) INTEGER_DATA( s_save_style )[0] ;
   Rboolean shutdown = LOGICAL_DATA( s_shutdown )[0] ;
   GnomeInteractStyle interact_style = ( GnomeInteractStyle ) INTEGER_DATA( s_interact_style )[0] ;
   Rboolean fast = LOGICAL_DATA( s_fast )[0] ;
   Rboolean global = LOGICAL_DATA( s_global )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_client_request_save ( client, save_style, shutdown, interact_style, fast, global );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_selection_get_icon ( USER_OBJECT_ s_gis, USER_OBJECT_ s_full_path )
{
   GnomeIconSelection * gis = ( GnomeIconSelection * ) getPtrValue( s_gis ) ;
   Rboolean full_path = LOGICAL_DATA( s_full_path )[0] ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_icon_selection_get_icon ( gis, full_path );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_append_frame_from_file_at_size ( USER_OBJECT_ s_animator, USER_OBJECT_ s_name, USER_OBJECT_ s_x_offset, USER_OBJECT_ s_y_offset, USER_OBJECT_ s_interval, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;
   int x_offset = INTEGER_DATA( s_x_offset )[0] ;
   int y_offset = INTEGER_DATA( s_y_offset )[0] ;
   unsigned int interval = INTEGER_DATA( s_interval )[0] ;
   unsigned int width = INTEGER_DATA( s_width )[0] ;
   unsigned int height = INTEGER_DATA( s_height )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_animator_append_frame_from_file_at_size ( animator, name, x_offset, y_offset, interval, width, height );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_freeze ( USER_OBJECT_ s_gil )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_freeze ( gil );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_appbar_set_default ( USER_OBJECT_ s_appbar, USER_OBJECT_ s_default_status )
{
   GnomeAppBar * appbar = ( GnomeAppBar * ) getPtrValue( s_appbar ) ;
   string default_status = CHAR_DEREF( STRING_ELT( s_default_status , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_appbar_set_default ( appbar, default_status );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_load_file ( USER_OBJECT_ s_gpixmap, USER_OBJECT_ s_filename )
{
   GnomePixmap * gpixmap = ( GnomePixmap * ) getPtrValue( s_gpixmap ) ;
   string filename = CHAR_DEREF( STRING_ELT( s_filename , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_pixmap_load_file ( gpixmap, filename );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dialog_append_buttons ( USER_OBJECT_ s_dialog, USER_OBJECT_ s_b1, USER_OBJECT_ s_b2, USER_OBJECT_ s_b3, USER_OBJECT_ s_b4, USER_OBJECT_ s_b5, USER_OBJECT_ s_b6, USER_OBJECT_ s_b7, USER_OBJECT_ s_b8, USER_OBJECT_ s_b9, USER_OBJECT_ s_b10, USER_OBJECT_ s_b11 )
{
   GnomeDialog * dialog = ( GnomeDialog * ) getPtrValue( s_dialog ) ;
   string b1 = CHAR_DEREF( STRING_ELT( s_b1 , 0)) ;
   string b2 = CHAR_DEREF( STRING_ELT( s_b2 , 0)) ;
   string b3 = CHAR_DEREF( STRING_ELT( s_b3 , 0)) ;
   string b4 = CHAR_DEREF( STRING_ELT( s_b4 , 0)) ;
   string b5 = CHAR_DEREF( STRING_ELT( s_b5 , 0)) ;
   string b6 = CHAR_DEREF( STRING_ELT( s_b6 , 0)) ;
   string b7 = CHAR_DEREF( STRING_ELT( s_b7 , 0)) ;
   string b8 = CHAR_DEREF( STRING_ELT( s_b8 , 0)) ;
   string b9 = CHAR_DEREF( STRING_ELT( s_b9 , 0)) ;
   string b10 = CHAR_DEREF( STRING_ELT( s_b10 , 0)) ;
   string b11 = CHAR_DEREF( STRING_ELT( s_b11 , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dialog_append_buttons ( dialog, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11 );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_start_set_logo ( USER_OBJECT_ s_page, USER_OBJECT_ s_image )
{
   GnomeDruidPageStart * page = ( GnomeDruidPageStart * ) getPtrValue( s_page ) ;
   GdkImlibImage * image = ( GdkImlibImage * ) getPtrValue( s_image ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_start_set_logo ( page, image );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_selection_add_defaults ( USER_OBJECT_ s_gis )
{
   GnomeIconSelection * gis = ( GnomeIconSelection * ) getPtrValue( s_gis ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_selection_add_defaults ( gis );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_stock_set_icon ( USER_OBJECT_ s_stock, USER_OBJECT_ s_icon )
{
   GnomeStock * stock = ( GnomeStock * ) getPtrValue( s_stock ) ;
   string icon = CHAR_DEREF( STRING_ELT( s_icon , 0)) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_stock_set_icon ( stock, icon );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_file_entry_set_directory ( USER_OBJECT_ s_fentry, USER_OBJECT_ s_directory_entry )
{
   GnomeFileEntry * fentry = ( GnomeFileEntry * ) getPtrValue( s_fentry ) ;
   Rboolean directory_entry = LOGICAL_DATA( s_directory_entry )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_file_entry_set_directory ( fentry, directory_entry );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_band_get_orientation ( USER_OBJECT_ s_band )
{
   GnomeDockBand * band = ( GnomeDockBand * ) getPtrValue( s_band ) ;


    GtkOrientation ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dock_band_get_orientation ( band );
   _result =  S_check_GtkOrientation_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_append ( USER_OBJECT_ s_gil, USER_OBJECT_ s_icon_filename, USER_OBJECT_ s_text )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   string icon_filename = CHAR_DEREF( STRING_ELT( s_icon_filename , 0)) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_icon_list_append ( gil, icon_filename, text );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_set_child_menu_path ( USER_OBJECT_ s_mdi, USER_OBJECT_ s_path )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;
   string path = CHAR_DEREF( STRING_ELT( s_path , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_mdi_set_child_menu_path ( mdi, path );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_set_icon_border ( USER_OBJECT_ s_gil, USER_OBJECT_ s_pixels )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   int pixels = INTEGER_DATA( s_pixels )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_set_icon_border ( gil, pixels );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_insert_imlib ( USER_OBJECT_ s_gil, USER_OBJECT_ s_pos, USER_OBJECT_ s_image, USER_OBJECT_ s_text )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   int pos = INTEGER_DATA( s_pos )[0] ;
   GdkImlibImage * image = ( GdkImlibImage * ) getPtrValue( s_image ) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_insert_imlib ( gil, pos, image, text );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_set_row_spacing ( USER_OBJECT_ s_gil, USER_OBJECT_ s_pixels )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   int pixels = INTEGER_DATA( s_pixels )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_set_row_spacing ( gil, pixels );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_color_picker_set_i8 ( USER_OBJECT_ s_cp, USER_OBJECT_ s_r, USER_OBJECT_ s_g, USER_OBJECT_ s_b, USER_OBJECT_ s_a )
{
   GnomeColorPicker * cp = ( GnomeColorPicker * ) getPtrValue( s_cp ) ;
   unsigned int r = INTEGER_DATA( s_r )[0] ;
   unsigned int g = INTEGER_DATA( s_g )[0] ;
   unsigned int b = INTEGER_DATA( s_b )[0] ;
   unsigned int a = INTEGER_DATA( s_a )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_color_picker_set_i8 ( cp, r, g, b, a );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_less_write_file ( USER_OBJECT_ s_less, USER_OBJECT_ s_filename )
{
   GnomeLess * less = ( GnomeLess * ) getPtrValue( s_less ) ;
   string filename = CHAR_DEREF( STRING_ELT( s_filename , 0)) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_less_write_file ( less, filename );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_paper_selector_get_bottom_margin ( USER_OBJECT_ s_gspaper )
{
   GnomePaperSelector * gspaper = ( GnomePaperSelector * ) getPtrValue( s_gspaper ) ;


    float ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_paper_selector_get_bottom_margin ( gspaper );
  _result = asRNumeric ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_less_reshow ( USER_OBJECT_ s_less )
{
   GnomeLess * less = ( GnomeLess * ) getPtrValue( s_less ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_less_reshow ( less );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_icon_is_visible ( USER_OBJECT_ s_gil, USER_OBJECT_ s_pos )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   int pos = INTEGER_DATA( s_pos )[0] ;


    GtkVisibility ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_icon_list_icon_is_visible ( gil, pos );
   _result =  S_check_GtkVisibility_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_set_statusbar ( USER_OBJECT_ s_app, USER_OBJECT_ s_statusbar )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;
   GtkWidget * statusbar = GTK_WIDGET ((GtkObject*) getPtrValue( s_statusbar )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_app_set_statusbar ( app, statusbar );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_entry_gnome_file_entry ( USER_OBJECT_ s_ientry )
{
   GnomeIconEntry * ientry = ( GnomeIconEntry * ) getPtrValue( s_ientry ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_icon_entry_gnome_file_entry ( ientry );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_moveto ( USER_OBJECT_ s_gil, USER_OBJECT_ s_pos, USER_OBJECT_ s_yalign )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   int pos = INTEGER_DATA( s_pos )[0] ;
   double yalign = NUMERIC_DATA( s_yalign )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_moveto ( gil, pos, yalign );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_font_picker_fi_set_use_font_in_label ( USER_OBJECT_ s_gfp, USER_OBJECT_ s_use_font_in_label, USER_OBJECT_ s_size )
{
   GnomeFontPicker * gfp = ( GnomeFontPicker * ) getPtrValue( s_gfp ) ;
   Rboolean use_font_in_label = LOGICAL_DATA( s_use_font_in_label )[0] ;
   int size = INTEGER_DATA( s_size )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_font_picker_fi_set_use_font_in_label ( gfp, use_font_in_label, size );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_remove_child ( USER_OBJECT_ s_mdi, USER_OBJECT_ s_child, USER_OBJECT_ s_force )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;
   GnomeMDIChild * child = ( GnomeMDIChild * ) getPtrValue( s_child ) ;
   int force = INTEGER_DATA( s_force )[0] ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_mdi_remove_child ( mdi, child, force );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_add_view ( USER_OBJECT_ s_mdi, USER_OBJECT_ s_child )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;
   GnomeMDIChild * child = ( GnomeMDIChild * ) getPtrValue( s_child ) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_mdi_add_view ( mdi, child );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_entry_prepend_history ( USER_OBJECT_ s_gentry, USER_OBJECT_ s_save, USER_OBJECT_ s_text )
{
   GnomeEntry * gentry = ( GnomeEntry * ) getPtrValue( s_gentry ) ;
   int save = INTEGER_DATA( s_save )[0] ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_entry_prepend_history ( gentry, save, text );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_entry_append_history ( USER_OBJECT_ s_gentry, USER_OBJECT_ s_save, USER_OBJECT_ s_text )
{
   GnomeEntry * gentry = ( GnomeEntry * ) getPtrValue( s_gentry ) ;
   int save = INTEGER_DATA( s_save )[0] ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_entry_append_history ( gentry, save, text );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_finish ( USER_OBJECT_ s_druid_page )
{
   GnomeDruidPage * druid_page = ( GnomeDruidPage * ) getPtrValue( s_druid_page ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_finish ( druid_page );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_guru_back_set_sensitive ( USER_OBJECT_ s_guru, USER_OBJECT_ s_sensitivity )
{
   GnomeGuru * guru = ( GnomeGuru * ) getPtrValue( s_guru ) ;
   Rboolean sensitivity = LOGICAL_DATA( s_sensitivity )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_guru_back_set_sensitive ( guru, sensitivity );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_band_drag_to ( USER_OBJECT_ s_band, USER_OBJECT_ s_item, USER_OBJECT_ s_x, USER_OBJECT_ s_y )
{
   GnomeDockBand * band = ( GnomeDockBand * ) getPtrValue( s_band ) ;
   GnomeDockItem * item = ( GnomeDockItem * ) getPtrValue( s_item ) ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dock_band_drag_to ( band, item, x, y );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_insert ( USER_OBJECT_ s_gil, USER_OBJECT_ s_pos, USER_OBJECT_ s_icon_filename, USER_OBJECT_ s_text )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   int pos = INTEGER_DATA( s_pos )[0] ;
   string icon_filename = CHAR_DEREF( STRING_ELT( s_icon_filename , 0)) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_insert ( gil, pos, icon_filename, text );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_href_set_label ( USER_OBJECT_ s_href, USER_OBJECT_ s_label )
{
   GnomeHRef * href = ( GnomeHRef * ) getPtrValue( s_href ) ;
   string label = CHAR_DEREF( STRING_ELT( s_label , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_href_set_label ( href, label );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_calculator_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_calculator_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_get_config_prefix ( USER_OBJECT_ s_client )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_client_get_config_prefix ( client );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_prepare ( USER_OBJECT_ s_druid_page )
{
   GnomeDruidPage * druid_page = ( GnomeDruidPage * ) getPtrValue( s_druid_page ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_prepare ( druid_page );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_date_edit_get_date ( USER_OBJECT_ s_gde )
{
   GnomeDateEdit * gde = ( GnomeDateEdit * ) getPtrValue( s_gde ) ;


    unsigned int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_date_edit_get_date ( gde );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_item_get_name ( USER_OBJECT_ s_item )
{
   GnomeDockItem * item = ( GnomeDockItem * ) getPtrValue( s_item ) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dock_item_get_name ( item );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_start_new_with_vals ( USER_OBJECT_ s_title, USER_OBJECT_ s_text, USER_OBJECT_ s_logo, USER_OBJECT_ s_watermark )
{
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;
   GdkImlibImage * logo = ( GdkImlibImage * ) getPtrValue( s_logo ) ;
   GdkImlibImage * watermark = ( GdkImlibImage * ) getPtrValue( s_watermark ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_druid_page_start_new_with_vals ( title, text, logo, watermark );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_widget_add_help ( USER_OBJECT_ s_widget, USER_OBJECT_ s_help )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   string help = CHAR_DEREF( STRING_ELT( s_help , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_widget_add_help ( widget, help );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_text_item_stop_editing ( USER_OBJECT_ s_iti, USER_OBJECT_ s_accept )
{
   GnomeIconTextItem * iti = ( GnomeIconTextItem * ) getPtrValue( s_iti ) ;
   Rboolean accept = LOGICAL_DATA( s_accept )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_text_item_stop_editing ( iti, accept );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dentry_get_icon_entry ( USER_OBJECT_ s_dee )
{
   GnomeDEntryEdit * dee = ( GnomeDEntryEdit * ) getPtrValue( s_dee ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dentry_get_icon_entry ( dee );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_set_process_id ( USER_OBJECT_ s_client, USER_OBJECT_ s_pid )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;
   int pid = INTEGER_DATA( s_pid )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_client_set_process_id ( client, pid );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_color_picker_set_dither ( USER_OBJECT_ s_cp, USER_OBJECT_ s_dither )
{
   GnomeColorPicker * cp = ( GnomeColorPicker * ) getPtrValue( s_cp ) ;
   Rboolean dither = LOGICAL_DATA( s_dither )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_color_picker_set_dither ( cp, dither );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_start_set_text_color ( USER_OBJECT_ s_page, USER_OBJECT_ s_colour )
{
   GnomeDruidPageStart * page = ( GnomeDruidPageStart * ) getPtrValue( s_page ) ;
   GdkColor * colour = ( GdkColor * ) getPtrValue( s_colour ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_start_set_text_color ( page, colour );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_color_picker_set_title ( USER_OBJECT_ s_cp, USER_OBJECT_ s_title )
{
   GnomeColorPicker * cp = ( GnomeColorPicker * ) getPtrValue( s_cp ) ;
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_color_picker_set_title ( cp, title );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_stock_button ( USER_OBJECT_ s_type )
{
   string type = CHAR_DEREF( STRING_ELT( s_type , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_stock_button ( type );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_append_frame_from_imlib_at_size ( USER_OBJECT_ s_animator, USER_OBJECT_ s_image, USER_OBJECT_ s_x_offset, USER_OBJECT_ s_y_offset, USER_OBJECT_ s_interval, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;
   GdkImlibImage * image = ( GdkImlibImage * ) getPtrValue( s_image ) ;
   int x_offset = INTEGER_DATA( s_x_offset )[0] ;
   int y_offset = INTEGER_DATA( s_y_offset )[0] ;
   unsigned int interval = INTEGER_DATA( s_interval )[0] ;
   unsigned int width = INTEGER_DATA( s_width )[0] ;
   unsigned int height = INTEGER_DATA( s_height )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_animator_append_frame_from_imlib_at_size ( animator, image, x_offset, y_offset, interval, width, height );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_band_set_orientation ( USER_OBJECT_ s_band, USER_OBJECT_ s_orientation )
{
   GnomeDockBand * band = ( GnomeDockBand * ) getPtrValue( s_band ) ;
   GtkOrientation orientation = ( GtkOrientation ) INTEGER_DATA( s_orientation )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dock_band_set_orientation ( band, orientation );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_select_icon ( USER_OBJECT_ s_gil, USER_OBJECT_ s_pos )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   int pos = INTEGER_DATA( s_pos )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_select_icon ( gil, pos );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_text_item_setxy ( USER_OBJECT_ s_iti, USER_OBJECT_ s_x, USER_OBJECT_ s_y )
{
   GnomeIconTextItem * iti = ( GnomeIconTextItem * ) getPtrValue( s_iti ) ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_text_item_setxy ( iti, x, y );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_item_reparent ( USER_OBJECT_ s_item, USER_OBJECT_ s_new_group )
{
   GnomeCanvasItem * item = ( GnomeCanvasItem * ) getPtrValue( s_item ) ;
   GnomeCanvasGroup * new_group = ( GnomeCanvasGroup * ) getPtrValue( s_new_group ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_canvas_item_reparent ( item, new_group );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_color_picker_set_i16 ( USER_OBJECT_ s_cp, USER_OBJECT_ s_r, USER_OBJECT_ s_g, USER_OBJECT_ s_b, USER_OBJECT_ s_a )
{
   GnomeColorPicker * cp = ( GnomeColorPicker * ) getPtrValue( s_cp ) ;
   unsigned int r = INTEGER_DATA( s_r )[0] ;
   unsigned int g = INTEGER_DATA( s_g )[0] ;
   unsigned int b = INTEGER_DATA( s_b )[0] ;
   unsigned int a = INTEGER_DATA( s_a )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_color_picker_set_i16 ( cp, r, g, b, a );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_entry_new ( USER_OBJECT_ s_history_id )
{
   string history_id = CHAR_DEREF( STRING_ELT( s_history_id , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_entry_new ( history_id );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_entry_set_pixmap_subdir ( USER_OBJECT_ s_pentry, USER_OBJECT_ s_subdir )
{
   GnomePixmapEntry * pentry = ( GnomePixmapEntry * ) getPtrValue( s_pentry ) ;
   string subdir = CHAR_DEREF( STRING_ELT( s_subdir , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_pixmap_entry_set_pixmap_subdir ( pentry, subdir );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_start ( USER_OBJECT_ s_animator )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_animator_start ( animator );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_set_loop_type ( USER_OBJECT_ s_animator, USER_OBJECT_ s_loop_type )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;
   GnomeAnimatorLoopType loop_type = ( GnomeAnimatorLoopType ) INTEGER_DATA( s_loop_type )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_animator_set_loop_type ( animator, loop_type );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_thaw ( USER_OBJECT_ s_gil )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_thaw ( gil );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_unselect_all ( USER_OBJECT_ s_gil, USER_OBJECT_ s_event, USER_OBJECT_ s_keep )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   GdkEvent * event = ( GdkEvent * ) getPtrValue( s_event ) ;
   string keep = CHAR_DEREF( STRING_ELT( s_keep , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_unselect_all ( gil, event, keep );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_appbar_clear_stack ( USER_OBJECT_ s_appbar )
{
   GnomeAppBar * appbar = ( GnomeAppBar * ) getPtrValue( s_appbar ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_appbar_clear_stack ( appbar );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_child_add_view ( USER_OBJECT_ s_mdic )
{
   GnomeMDIChild * mdic = ( GnomeMDIChild * ) getPtrValue( s_mdic ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_mdi_child_add_view ( mdic );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_item_get_shadow_type ( USER_OBJECT_ s_item )
{
   GnomeDockItem * item = ( GnomeDockItem * ) getPtrValue( s_item ) ;


    GtkShadowType ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dock_item_get_shadow_type ( item );
   _result =  S_check_GtkShadowType_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gnome_entry_save_history ( USER_OBJECT_ s_gentry )
{
   GnomeEntry * gentry = ( GnomeEntry * ) getPtrValue( s_gentry ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_entry_save_history ( gentry );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_font_picker_set_font_name ( USER_OBJECT_ s_gfp, USER_OBJECT_ s_fontname )
{
   GnomeFontPicker * gfp = ( GnomeFontPicker * ) getPtrValue( s_gfp ) ;
   string fontname = CHAR_DEREF( STRING_ELT( s_fontname , 0)) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_font_picker_set_font_name ( gfp, fontname );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_new_without_connection (  )
{


    GnomeClient * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_client_new_without_connection (  );
   _result = toRPointer(ans, "GnomeClient");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_less_show_string ( USER_OBJECT_ s_less, USER_OBJECT_ s_str )
{
   GnomeLess * less = ( GnomeLess * ) getPtrValue( s_less ) ;
   string str = CHAR_DEREF( STRING_ELT( s_str , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_less_show_string ( less, str );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_get_dock ( USER_OBJECT_ s_app )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;


    GnomeDock * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_app_get_dock ( app );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_set_scroll_region ( USER_OBJECT_ s_canvas, USER_OBJECT_ s_x1, USER_OBJECT_ s_y1, USER_OBJECT_ s_x2, USER_OBJECT_ s_y2 )
{
   GnomeCanvas * canvas = ( GnomeCanvas * ) getPtrValue( s_canvas ) ;
   double x1 = NUMERIC_DATA( s_x1 )[0] ;
   double y1 = NUMERIC_DATA( s_y1 )[0] ;
   double x2 = NUMERIC_DATA( s_x2 )[0] ;
   double y2 = NUMERIC_DATA( s_y2 )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_canvas_set_scroll_region ( canvas, x1, y1, x2, y2 );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_file_entry_gtk_entry ( USER_OBJECT_ s_fentry )
{
   GnomeFileEntry * fentry = ( GnomeFileEntry * ) getPtrValue( s_fentry ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_file_entry_gtk_entry ( fentry );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dentry_edit_load_file ( USER_OBJECT_ s_dee, USER_OBJECT_ s_filename )
{
   GnomeDEntryEdit * dee = ( GnomeDEntryEdit * ) getPtrValue( s_dee ) ;
   string filename = CHAR_DEREF( STRING_ELT( s_filename , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dentry_edit_load_file ( dee, filename );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_property_box_set_modified ( USER_OBJECT_ s_property_box, USER_OBJECT_ s_modified )
{
   GnomePropertyBox * property_box = ( GnomePropertyBox * ) getPtrValue( s_property_box ) ;
   Rboolean modified = LOGICAL_DATA( s_modified )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_property_box_set_modified ( property_box, modified );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_set_user_id ( USER_OBJECT_ s_client, USER_OBJECT_ s_user_id )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;
   string user_id = CHAR_DEREF( STRING_ELT( s_user_id , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_client_set_user_id ( client, user_id );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_get_items_per_line ( USER_OBJECT_ s_gil )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_icon_list_get_items_per_line ( gil );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_entry_set_preview_size ( USER_OBJECT_ s_pentry, USER_OBJECT_ s_preview_w, USER_OBJECT_ s_preview_h )
{
   GnomePixmapEntry * pentry = ( GnomePixmapEntry * ) getPtrValue( s_pentry ) ;
   int preview_w = INTEGER_DATA( s_preview_w )[0] ;
   int preview_h = INTEGER_DATA( s_preview_h )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_pixmap_entry_set_preview_size ( pentry, preview_w, preview_h );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_new_from_file_at_size ( USER_OBJECT_ s_filename, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   string filename = CHAR_DEREF( STRING_ELT( s_filename , 0)) ;
   int width = INTEGER_DATA( s_width )[0] ;
   int height = INTEGER_DATA( s_height )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_pixmap_new_from_file_at_size ( filename, width, height );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_font_picker_get_font ( USER_OBJECT_ s_gfp )
{
   GnomeFontPicker * gfp = ( GnomeFontPicker * ) getPtrValue( s_gfp ) ;


    GdkFont * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_font_picker_get_font ( gfp );
   _result = toRPointer(ans, "GdkFont");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_ok_dialog ( USER_OBJECT_ s_message )
{
   string message = CHAR_DEREF( STRING_ELT( s_message , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_ok_dialog ( message );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_remove_all ( USER_OBJECT_ s_mdi, USER_OBJECT_ s_force )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;
   int force = INTEGER_DATA( s_force )[0] ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_mdi_remove_all ( mdi, force );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_error_dialog_parented ( USER_OBJECT_ s_message, USER_OBJECT_ s_parent )
{
   string message = CHAR_DEREF( STRING_ELT( s_message , 0)) ;
   GtkWindow * parent = GTK_WINDOW ((GtkObject*) getPtrValue( s_parent )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_error_dialog_parented ( message, parent );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_date_edit_new_flags ( USER_OBJECT_ s_the_time, USER_OBJECT_ s_flags )
{
   unsigned int the_time = INTEGER_DATA( s_the_time )[0] ;
   GnomeDateEditFlags flags = ( GnomeDateEditFlags ) INTEGER_DATA( s_flags )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_date_edit_new_flags ( the_time, flags );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dialog_set_parent ( USER_OBJECT_ s_dialog, USER_OBJECT_ s_parent )
{
   GnomeDialog * dialog = ( GnomeDialog * ) getPtrValue( s_dialog ) ;
   GtkWindow * parent = GTK_WINDOW ((GtkObject*) getPtrValue( s_parent )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dialog_set_parent ( dialog, parent );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_set_menus ( USER_OBJECT_ s_app, USER_OBJECT_ s_menubar )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;
   GtkMenuBar * menubar = GTK_MENU_BAR ((GtkObject*) getPtrValue( s_menubar )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_app_set_menus ( app, menubar );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_item_move ( USER_OBJECT_ s_item, USER_OBJECT_ s_dx, USER_OBJECT_ s_dy )
{
   GnomeCanvasItem * item = ( GnomeCanvasItem * ) getPtrValue( s_item ) ;
   double dx = NUMERIC_DATA( s_dx )[0] ;
   double dy = NUMERIC_DATA( s_dy )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_canvas_item_move ( item, dx, dy );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_entry_get_filename ( USER_OBJECT_ s_pentry )
{
   GnomePixmapEntry * pentry = ( GnomePixmapEntry * ) getPtrValue( s_pentry ) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_pixmap_entry_get_filename ( pentry );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_appbar_push ( USER_OBJECT_ s_appbar, USER_OBJECT_ s_status )
{
   GnomeAppBar * appbar = ( GnomeAppBar * ) getPtrValue( s_appbar ) ;
   string status = CHAR_DEREF( STRING_ELT( s_status , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_appbar_push ( appbar, status );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dentry_edit_new_notebook ( USER_OBJECT_ s_notebook )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;


    GtkObject * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dentry_edit_new_notebook ( notebook );
   _result = toRPointer(ans, "GtkObject");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_append_frames_from_imlib ( USER_OBJECT_ s_animator, USER_OBJECT_ s_image, USER_OBJECT_ s_x_offset, USER_OBJECT_ s_y_offset, USER_OBJECT_ s_interval, USER_OBJECT_ s_x_unit )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;
   GdkImlibImage * image = ( GdkImlibImage * ) getPtrValue( s_image ) ;
   int x_offset = INTEGER_DATA( s_x_offset )[0] ;
   int y_offset = INTEGER_DATA( s_y_offset )[0] ;
   unsigned int interval = INTEGER_DATA( s_interval )[0] ;
   int x_unit = INTEGER_DATA( s_x_unit )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_animator_append_frames_from_imlib ( animator, image, x_offset, y_offset, interval, x_unit );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_goto_frame ( USER_OBJECT_ s_animator, USER_OBJECT_ s_num_frame )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;
   unsigned int num_frame = INTEGER_DATA( s_num_frame )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_animator_goto_frame ( animator, num_frame );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dialog_close ( USER_OBJECT_ s_dialog )
{
   GnomeDialog * dialog = ( GnomeDialog * ) getPtrValue( s_dialog ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dialog_close ( dialog );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_appbar_get_progress ( USER_OBJECT_ s_appbar )
{
   GnomeAppBar * appbar = ( GnomeAppBar * ) getPtrValue( s_appbar ) ;


    GtkProgress * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_appbar_get_progress ( appbar );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_flush ( USER_OBJECT_ s_client )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_client_flush ( client );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ted_new_layout ( USER_OBJECT_ s_dialog_name, USER_OBJECT_ s_layout )
{
   string dialog_name = CHAR_DEREF( STRING_ELT( s_dialog_name , 0)) ;
   string layout = CHAR_DEREF( STRING_ELT( s_layout , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_ted_new_layout ( dialog_name, layout );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dialog_append_button ( USER_OBJECT_ s_dialog, USER_OBJECT_ s_name )
{
   GnomeDialog * dialog = ( GnomeDialog * ) getPtrValue( s_dialog ) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dialog_append_button ( dialog, name );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_update_child ( USER_OBJECT_ s_mdi, USER_OBJECT_ s_child )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;
   GnomeMDIChild * child = ( GnomeMDIChild * ) getPtrValue( s_child ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_mdi_update_child ( mdi, child );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_get_child_from_view ( USER_OBJECT_ s_view )
{
   GtkWidget * view = GTK_WIDGET ((GtkObject*) getPtrValue( s_view )) ;


    GnomeMDIChild * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_mdi_get_child_from_view ( view );
   _result = toRPointer(ans, "GnomeMDIChild");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_scores_set_logo_label ( USER_OBJECT_ s_gs, USER_OBJECT_ s_text, USER_OBJECT_ s_font, USER_OBJECT_ s_colour )
{
   GnomeScores * gs = ( GnomeScores * ) getPtrValue( s_gs ) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;
   string font = CHAR_DEREF( STRING_ELT( s_font , 0)) ;
   GdkColor * colour = ( GdkColor * ) getPtrValue( s_colour ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_scores_set_logo_label ( gs, text, font, colour );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_new ( USER_OBJECT_ s_icon_width, USER_OBJECT_ s_adj, USER_OBJECT_ s_is_editable )
{
   unsigned int icon_width = INTEGER_DATA( s_icon_width )[0] ;
   GtkAdjustment * adj = Rf_length( s_adj ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adj )) ;
   Rboolean is_editable = LOGICAL_DATA( s_is_editable )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_icon_list_new ( icon_width, adj, is_editable );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_item_hide ( USER_OBJECT_ s_item )
{
   GnomeCanvasItem * item = ( GnomeCanvasItem * ) getPtrValue( s_item ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_canvas_item_hide ( item );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_scores_set_logo_pixmap ( USER_OBJECT_ s_gs, USER_OBJECT_ s_logo )
{
   GnomeScores * gs = ( GnomeScores * ) getPtrValue( s_gs ) ;
   string logo = CHAR_DEREF( STRING_ELT( s_logo , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_scores_set_logo_pixmap ( gs, logo );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_append_frames_from_file ( USER_OBJECT_ s_animator, USER_OBJECT_ s_name, USER_OBJECT_ s_x_offset, USER_OBJECT_ s_y_offset, USER_OBJECT_ s_interval, USER_OBJECT_ s_x_unit )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;
   int x_offset = INTEGER_DATA( s_x_offset )[0] ;
   int y_offset = INTEGER_DATA( s_y_offset )[0] ;
   unsigned int interval = INTEGER_DATA( s_interval )[0] ;
   int x_unit = INTEGER_DATA( s_x_unit )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_animator_append_frames_from_file ( animator, name, x_offset, y_offset, interval, x_unit );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_new_from_imlib ( USER_OBJECT_ s_image )
{
   GdkImlibImage * image = ( GdkImlibImage * ) getPtrValue( s_image ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_pixmap_new_from_imlib ( image );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dentry_get_name_entry ( USER_OBJECT_ s_dee )
{
   GnomeDEntryEdit * dee = ( GnomeDEntryEdit * ) getPtrValue( s_dee ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dentry_get_name_entry ( dee );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clock_set_update_interval ( USER_OBJECT_ s_gclock, USER_OBJECT_ s_seconds )
{
   GtkClock * gclock = GTK_CLOCK ((GtkObject*) getPtrValue( s_gclock )) ;
   int seconds = INTEGER_DATA( s_seconds )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clock_set_update_interval ( gclock, seconds );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_selection_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_icon_selection_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_insert_page ( USER_OBJECT_ s_druid, USER_OBJECT_ s_back_page, USER_OBJECT_ s_page )
{
   GnomeDruid * druid = ( GnomeDruid * ) getPtrValue( s_druid ) ;
   GnomeDruidPage * back_page = ( GnomeDruidPage * ) getPtrValue( s_back_page ) ;
   GnomeDruidPage * page = ( GnomeDruidPage * ) getPtrValue( s_page ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_insert_page ( druid, back_page, page );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dialog_append_button_with_pixmap ( USER_OBJECT_ s_dialog, USER_OBJECT_ s_name, USER_OBJECT_ s_pixmap )
{
   GnomeDialog * dialog = ( GnomeDialog * ) getPtrValue( s_dialog ) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;
   string pixmap = CHAR_DEREF( STRING_ELT( s_pixmap , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dialog_append_button_with_pixmap ( dialog, name, pixmap );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_spell_insert ( USER_OBJECT_ s_spell, USER_OBJECT_ s_word, USER_OBJECT_ s_lowercase )
{
   GnomeSpell * spell = ( GnomeSpell * ) getPtrValue( s_spell ) ;
   string word = CHAR_DEREF( STRING_ELT( s_word , 0)) ;
   int lowercase = INTEGER_DATA( s_lowercase )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_spell_insert ( spell, word, lowercase );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_file_entry_set_title ( USER_OBJECT_ s_fentry, USER_OBJECT_ s_browse_dialog_title )
{
   GnomeFileEntry * fentry = ( GnomeFileEntry * ) getPtrValue( s_fentry ) ;
   string browse_dialog_title = CHAR_DEREF( STRING_ELT( s_browse_dialog_title , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_file_entry_set_title ( fentry, browse_dialog_title );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_start_set_title ( USER_OBJECT_ s_page, USER_OBJECT_ s_title )
{
   GnomeDruidPageStart * page = ( GnomeDruidPageStart * ) getPtrValue( s_page ) ;
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_start_set_title ( page, title );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_entry_set_icon ( USER_OBJECT_ s_ientry, USER_OBJECT_ s_filename )
{
   GnomeIconEntry * ientry = ( GnomeIconEntry * ) getPtrValue( s_ientry ) ;
   string filename = CHAR_DEREF( STRING_ELT( s_filename , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_entry_set_icon ( ientry, filename );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_find_child ( USER_OBJECT_ s_mdi, USER_OBJECT_ s_name )
{
   GnomeMDI * mdi = ( GnomeMDI * ) getPtrValue( s_mdi ) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;


    GnomeMDIChild * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_mdi_find_child ( mdi, name );
   _result = toRPointer(ans, "GnomeMDIChild");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_message_box_new ( USER_OBJECT_ s_message, USER_OBJECT_ s_messagebox_type, USER_OBJECT_ s_b1, USER_OBJECT_ s_b2, USER_OBJECT_ s_b3, USER_OBJECT_ s_b4, USER_OBJECT_ s_b5, USER_OBJECT_ s_b6, USER_OBJECT_ s_b7, USER_OBJECT_ s_b8, USER_OBJECT_ s_b9, USER_OBJECT_ s_b10, USER_OBJECT_ s_b11 )
{
   string message = CHAR_DEREF( STRING_ELT( s_message , 0)) ;
   string messagebox_type = CHAR_DEREF( STRING_ELT( s_messagebox_type , 0)) ;
   string b1 = CHAR_DEREF( STRING_ELT( s_b1 , 0)) ;
   string b2 = CHAR_DEREF( STRING_ELT( s_b2 , 0)) ;
   string b3 = CHAR_DEREF( STRING_ELT( s_b3 , 0)) ;
   string b4 = CHAR_DEREF( STRING_ELT( s_b4 , 0)) ;
   string b5 = CHAR_DEREF( STRING_ELT( s_b5 , 0)) ;
   string b6 = CHAR_DEREF( STRING_ELT( s_b6 , 0)) ;
   string b7 = CHAR_DEREF( STRING_ELT( s_b7 , 0)) ;
   string b8 = CHAR_DEREF( STRING_ELT( s_b8 , 0)) ;
   string b9 = CHAR_DEREF( STRING_ELT( s_b9 , 0)) ;
   string b10 = CHAR_DEREF( STRING_ELT( s_b10 , 0)) ;
   string b11 = CHAR_DEREF( STRING_ELT( s_b11 , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_message_box_new ( message, messagebox_type, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11 );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_date_edit_new ( USER_OBJECT_ s_the_time, USER_OBJECT_ s_show_time, USER_OBJECT_ s_use_24_format )
{
   unsigned int the_time = INTEGER_DATA( s_the_time )[0] ;
   Rboolean show_time = LOGICAL_DATA( s_show_time )[0] ;
   Rboolean use_24_format = LOGICAL_DATA( s_use_24_format )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_date_edit_new ( the_time, show_time, use_24_format );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_guru_new ( USER_OBJECT_ s_name, USER_OBJECT_ s_graphic, USER_OBJECT_ s_dialog )
{
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;
   GtkWidget * graphic = GTK_WIDGET ((GtkObject*) getPtrValue( s_graphic )) ;
   GnomeDialog * dialog = ( GnomeDialog * ) getPtrValue( s_dialog ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_guru_new ( name, graphic, dialog );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_finish_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_druid_page_finish_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_start_set_textbox_color ( USER_OBJECT_ s_page, USER_OBJECT_ s_colour )
{
   GnomeDruidPageStart * page = ( GnomeDruidPageStart * ) getPtrValue( s_page ) ;
   GdkColor * colour = ( GdkColor * ) getPtrValue( s_colour ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_start_set_textbox_color ( page, colour );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_href_set_url ( USER_OBJECT_ s_href, USER_OBJECT_ s_url )
{
   GnomeHRef * href = ( GnomeHRef * ) getPtrValue( s_href ) ;
   string url = CHAR_DEREF( STRING_ELT( s_url , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_href_set_url ( href, url );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_finish_set_bg_color ( USER_OBJECT_ s_page, USER_OBJECT_ s_colour )
{
   GnomeDruidPageFinish * page = ( GnomeDruidPageFinish * ) getPtrValue( s_page ) ;
   GdkColor * colour = ( GdkColor * ) getPtrValue( s_colour ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_finish_set_bg_color ( page, colour );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_font_picker_get_mode ( USER_OBJECT_ s_gfp )
{
   GnomeFontPicker * gfp = ( GnomeFontPicker * ) getPtrValue( s_gfp ) ;


    GnomeFontPickerMode ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_font_picker_get_mode ( gfp );
   _result =  S_check_GnomeFontPickerMode_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gnome_master_client (  )
{


    GnomeClient * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_master_client (  );
   _result = toRPointer(ans, "GnomeClient");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_standard_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_druid_page_standard_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_scores_set_logo_widget ( USER_OBJECT_ s_gs, USER_OBJECT_ s_w )
{
   GnomeScores * gs = ( GnomeScores * ) getPtrValue( s_gs ) ;
   GtkWidget * w = GTK_WIDGET ((GtkObject*) getPtrValue( s_w )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_scores_set_logo_widget ( gs, w );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_item_raise ( USER_OBJECT_ s_item, USER_OBJECT_ s_positions )
{
   GnomeCanvasItem * item = ( GnomeCanvasItem * ) getPtrValue( s_item ) ;
   int positions = INTEGER_DATA( s_positions )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_canvas_item_raise ( item, positions );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_animator_append_frames_from_imlib_at_size ( USER_OBJECT_ s_animator, USER_OBJECT_ s_image, USER_OBJECT_ s_x_offset, USER_OBJECT_ s_y_offset, USER_OBJECT_ s_interval, USER_OBJECT_ s_x_unit, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   GnomeAnimator * animator = ( GnomeAnimator * ) getPtrValue( s_animator ) ;
   GdkImlibImage * image = ( GdkImlibImage * ) getPtrValue( s_image ) ;
   int x_offset = INTEGER_DATA( s_x_offset )[0] ;
   int y_offset = INTEGER_DATA( s_y_offset )[0] ;
   unsigned int interval = INTEGER_DATA( s_interval )[0] ;
   int x_unit = INTEGER_DATA( s_x_unit )[0] ;
   unsigned int width = INTEGER_DATA( s_width )[0] ;
   unsigned int height = INTEGER_DATA( s_height )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_animator_append_frames_from_imlib_at_size ( animator, image, x_offset, y_offset, interval, x_unit, width, height );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_number_entry_gtk_entry ( USER_OBJECT_ s_nentry )
{
   GnomeNumberEntry * nentry = ( GnomeNumberEntry * ) getPtrValue( s_nentry ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_number_entry_gtk_entry ( nentry );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_spell_accept ( USER_OBJECT_ s_spell, USER_OBJECT_ s_word )
{
   GnomeSpell * spell = ( GnomeSpell * ) getPtrValue( s_spell ) ;
   string word = CHAR_DEREF( STRING_ELT( s_word , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_spell_accept ( spell, word );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_guru_append_page ( USER_OBJECT_ s_guru, USER_OBJECT_ s_name, USER_OBJECT_ s_page )
{
   GnomeGuru * guru = ( GnomeGuru * ) getPtrValue( s_guru ) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;
   GtkWidget * page = GTK_WIDGET ((GtkObject*) getPtrValue( s_page )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_guru_append_page ( guru, name, page );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_list_set_hadjustment ( USER_OBJECT_ s_gil, USER_OBJECT_ s_hadj )
{
   GnomeIconList * gil = ( GnomeIconList * ) getPtrValue( s_gil ) ;
   GtkAdjustment * hadj = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_hadj )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_list_set_hadjustment ( gil, hadj );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_set_contents ( USER_OBJECT_ s_app, USER_OBJECT_ s_contents )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;
   GtkWidget * contents = GTK_WIDGET ((GtkObject*) getPtrValue( s_contents )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_app_set_contents ( app, contents );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_date_edit_set_time ( USER_OBJECT_ s_gde, USER_OBJECT_ s_the_time )
{
   GnomeDateEdit * gde = ( GnomeDateEdit * ) getPtrValue( s_gde ) ;
   unsigned int the_time = INTEGER_DATA( s_the_time )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_date_edit_set_time ( gde, the_time );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_selection_select_icon ( USER_OBJECT_ s_gis, USER_OBJECT_ s_filename )
{
   GnomeIconSelection * gis = ( GnomeIconSelection * ) getPtrValue( s_gis ) ;
   string filename = CHAR_DEREF( STRING_ELT( s_filename , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_icon_selection_select_icon ( gis, filename );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_property_box_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_property_box_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_new_from_imlib_at_size ( USER_OBJECT_ s_image, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   GdkImlibImage * image = ( GdkImlibImage * ) getPtrValue( s_image ) ;
   int width = INTEGER_DATA( s_width )[0] ;
   int height = INTEGER_DATA( s_height )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_pixmap_new_from_imlib_at_size ( image, width, height );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_scores_set_logo_label_title ( USER_OBJECT_ s_gs, USER_OBJECT_ s_logo )
{
   GnomeScores * gs = ( GnomeScores * ) getPtrValue( s_gs ) ;
   string logo = CHAR_DEREF( STRING_ELT( s_logo , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_scores_set_logo_label_title ( gs, logo );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_finish_set_title_color ( USER_OBJECT_ s_page, USER_OBJECT_ s_colour )
{
   GnomeDruidPageFinish * page = ( GnomeDruidPageFinish * ) getPtrValue( s_page ) ;
   GdkColor * colour = ( GdkColor * ) getPtrValue( s_colour ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_finish_set_title_color ( page, colour );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_band_append ( USER_OBJECT_ s_band, USER_OBJECT_ s_child, USER_OBJECT_ s_offset )
{
   GnomeDockBand * band = ( GnomeDockBand * ) getPtrValue( s_band ) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   unsigned int offset = INTEGER_DATA( s_offset )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dock_band_append ( band, child, offset );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dentry_get_comment_entry ( USER_OBJECT_ s_dee )
{
   GnomeDEntryEdit * dee = ( GnomeDEntryEdit * ) getPtrValue( s_dee ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dentry_get_comment_entry ( dee );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_font_picker_get_preview_text ( USER_OBJECT_ s_gfp )
{
   GnomeFontPicker * gfp = ( GnomeFontPicker * ) getPtrValue( s_gfp ) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_font_picker_get_preview_text ( gfp );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_guru_next_set_sensitive ( USER_OBJECT_ s_guru, USER_OBJECT_ s_sensitivity )
{
   GnomeGuru * guru = ( GnomeGuru * ) getPtrValue( s_guru ) ;
   Rboolean sensitivity = LOGICAL_DATA( s_sensitivity )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_guru_next_set_sensitive ( guru, sensitivity );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_message ( USER_OBJECT_ s_app, USER_OBJECT_ s_message )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;
   string message = CHAR_DEREF( STRING_ELT( s_message , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_app_message ( app, message );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_entry_gtk_entry ( USER_OBJECT_ s_pentry )
{
   GnomePixmapEntry * pentry = ( GnomePixmapEntry * ) getPtrValue( s_pentry ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_pixmap_entry_gtk_entry ( pentry );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_set_stipple_origin ( USER_OBJECT_ s_canvas, USER_OBJECT_ s_gc )
{
   GnomeCanvas * canvas = ( GnomeCanvas * ) getPtrValue( s_canvas ) ;
   GdkGC * gc = ( GdkGC * ) getPtrValue( s_gc ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_canvas_set_stipple_origin ( canvas, gc );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dialog_run ( USER_OBJECT_ s_dialog )
{
   GnomeDialog * dialog = ( GnomeDialog * ) getPtrValue( s_dialog ) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_dialog_run ( dialog );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_mdi_child_set_name ( USER_OBJECT_ s_mdic, USER_OBJECT_ s_name )
{
   GnomeMDIChild * mdic = ( GnomeMDIChild * ) getPtrValue( s_mdic ) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_mdi_child_set_name ( mdic, name );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_spell_next ( USER_OBJECT_ s_spell )
{
   GnomeSpell * spell = ( GnomeSpell * ) getPtrValue( s_spell ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_spell_next ( spell );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_dock_band_set_child_offset ( USER_OBJECT_ s_band, USER_OBJECT_ s_child, USER_OBJECT_ s_offset )
{
   GnomeDockBand * band = ( GnomeDockBand * ) getPtrValue( s_band ) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   unsigned int offset = INTEGER_DATA( s_offset )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_dock_band_set_child_offset ( band, child, offset );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_get_flags ( USER_OBJECT_ s_client )
{
   GnomeClient * client = ( GnomeClient * ) getPtrValue( s_client ) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_client_get_flags ( client );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_canvas_item_raise_to_top ( USER_OBJECT_ s_item )
{
   GnomeCanvasItem * item = ( GnomeCanvasItem * ) getPtrValue( s_item ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_canvas_item_raise_to_top ( item );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_icon_entry_gnome_entry ( USER_OBJECT_ s_ientry )
{
   GnomeIconEntry * ientry = ( GnomeIconEntry * ) getPtrValue( s_ientry ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_icon_entry_gnome_entry ( ientry );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_add_toolbar ( USER_OBJECT_ s_app, USER_OBJECT_ s_toolbar, USER_OBJECT_ s_name, USER_OBJECT_ s_behavior, USER_OBJECT_ s_placement, USER_OBJECT_ s_band_num, USER_OBJECT_ s_band_position, USER_OBJECT_ s_offset )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;
   GtkToolbar * toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_toolbar )) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;
   GnomeDockItemBehavior behavior = ( GnomeDockItemBehavior ) INTEGER_DATA( s_behavior )[0] ;
   GnomeDockPlacement placement = ( GnomeDockPlacement ) INTEGER_DATA( s_placement )[0] ;
   int band_num = INTEGER_DATA( s_band_num )[0] ;
   int band_position = INTEGER_DATA( s_band_position )[0] ;
   int offset = INTEGER_DATA( s_offset )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_app_add_toolbar ( app, toolbar, name, behavior, placement, band_num, band_position, offset );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_pixmap_new_from_file ( USER_OBJECT_ s_filename )
{
   string filename = CHAR_DEREF( STRING_ELT( s_filename , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_pixmap_new_from_file ( filename );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_file_entry_gnome_entry ( USER_OBJECT_ s_fentry )
{
   GnomeFileEntry * fentry = ( GnomeFileEntry * ) getPtrValue( s_fentry ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_file_entry_gnome_entry ( fentry );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_warning_dialog_parented ( USER_OBJECT_ s_message, USER_OBJECT_ s_parent )
{
   string message = CHAR_DEREF( STRING_ELT( s_message , 0)) ;
   GtkWindow * parent = GTK_WINDOW ((GtkObject*) getPtrValue( s_parent )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_warning_dialog_parented ( message, parent );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_app_set_statusbar_custom ( USER_OBJECT_ s_app, USER_OBJECT_ s_container, USER_OBJECT_ s_statusbar )
{
   GnomeApp * app = ( GnomeApp * ) getPtrValue( s_app ) ;
   GtkWidget * container = GTK_WIDGET ((GtkObject*) getPtrValue( s_container )) ;
   GtkWidget * statusbar = GTK_WIDGET ((GtkObject*) getPtrValue( s_statusbar )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_app_set_statusbar_custom ( app, container, statusbar );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_client_disable_master_connection (  )
{


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_client_disable_master_connection (  );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_less_clear ( USER_OBJECT_ s_less )
{
   GnomeLess * less = ( GnomeLess * ) getPtrValue( s_less ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_less_clear ( less );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_standard_set_logo ( USER_OBJECT_ s_page, USER_OBJECT_ s_image )
{
   GnomeDruidPageStandard * page = ( GnomeDruidPageStandard * ) getPtrValue( s_page ) ;
   GdkImlibImage * image = ( GdkImlibImage * ) getPtrValue( s_image ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_standard_set_logo ( page, image );


  return(_result);
}
 

USER_OBJECT_
 S_gnome_appbar_new ( USER_OBJECT_ s_has_progress, USER_OBJECT_ s_has_status, USER_OBJECT_ s_interactivity )
{
   Rboolean has_progress = LOGICAL_DATA( s_has_progress )[0] ;
   Rboolean has_status = LOGICAL_DATA( s_has_status )[0] ;
   GnomePreferencesType interactivity = ( GnomePreferencesType ) INTEGER_DATA( s_interactivity )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gnome_appbar_new ( has_progress, has_status, interactivity );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gnome_druid_page_finish_set_logo ( USER_OBJECT_ s_page, USER_OBJECT_ s_image )
{
   GnomeDruidPageFinish * page = ( GnomeDruidPageFinish * ) getPtrValue( s_page ) ;
   GdkImlibImage * image = ( GdkImlibImage * ) getPtrValue( s_image ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gnome_druid_page_finish_set_logo ( page, image );


  return(_result);
}
 

