# Copyright (c) 2002 Red Hat, Inc. All rights reserved.
#
# This software may be freely redistributed under the terms of the
# GNU General Public License.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Display Help->About Box
#
# Written for Red Hat Inc. by Neil Padgett <npadgett@redhat.com>
#
# Component of: Red Hat Database GUI Administration tool


package require Itcl
package require Itk
package require Iwidgets
package provide aboutBox 1.0

proc displayAboutBox { aboutTitle aboutImage aboutBody } {
    destroy .aboutBox

    # Create the messagedialog
    
    iwidgets::messagedialog .aboutBox \
	-text $aboutBody \
	-title $aboutTitle \
	-textpady 0 \
	-imagepos n\
	-image $aboutImage

    wm withdraw .aboutBox

    # Change the border around the image

    .aboutBox component image configure -relief ridge -bd 3

    # Revoke all buttons except ok

    .aboutBox hide Help
    .aboutBox hide Apply
    .aboutBox hide Cancel
    
    # Centre the messagedialog and activate it
    
    .aboutBox center
    after idle ".aboutBox activate"

    wm deiconify .aboutBox
}

# End of file
