# Copyright (c) 2002 Red Hat, Inc. All rights reserved.
#
# This software may be freely redistributed under the terms of the
# GNU General Public License.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Alter privileges dialog raiser
#
# Written for Red Hat Inc. by Alifiya Hussain <ahussain@redhat.com>
# and Andrew Overholt <overholt@redhat.com>
#
# Component of: Red Hat Database GUI Administration tool

package require Itcl
package require Itk
package require Iwidgets
package require alterPrivilegesDialog
package provide alterPrivilegesRaiser 1.0

proc alterPrivilegesRaiser { windowTitle args } {

    # Create the privileges window

    toplevel .alterPrivileges
    
    # Withdraw the window while we pack it

    wm withdraw .alterPrivileges

    # Disable the main program window

    wm transient .alterPrivileges .
    grab .alterPrivileges

    # Set the window title

    wm title .alterPrivileges $windowTitle

    # Create a frame to hold the privilegesDialog
    
    frame .alterPrivileges.hostedDialog -relief groove -borderwidth 1

    # Place the AlterPrivilegesDialog in the window inside the frame
    # Note: I am hard-coding the name of the hyperlinkWatcher here.

    if {[catch {eval AlterPrivilegesDialog \
	.alterPrivileges.hostedDialog.alterPrivilegesDialog "$args -hyperlinkWatcher hyperlinkWatcher -parentDialog .alterPrivileges"} errorText]} {
	tk_messageBox -icon error -message "An error occurred while raising the dialog box:\n $errorText\nThe operation was aborted." -title "errorText"
	destroy .alterPrivileges
	return
    }

    # Pack the frame

    pack .alterPrivileges.hostedDialog.alterPrivilegesDialog -fill both -expand\
	y
    pack .alterPrivileges.hostedDialog -side top -fill both -expand y

    # Create and pack Ok and Cancel Buttons

    button .alterPrivileges.okButton -text "OK" -underline 0 -command \
	alterPrivilegesDialog_OK
    button .alterPrivileges.applyButton -text "Apply" -underline 0 -command \
	alterPrivilegesDialog_Apply
    button .alterPrivileges.cancelButton -text "Cancel" -underline 0 -command \
	alterPrivilegesDialog_Cancel
   
    bind .alterPrivileges <Alt-o> {alterPrivilegesDialog_OK; break}
    bind .alterPrivileges <Alt-a> {alterPrivilegesDialog_Apply; break}
    bind .alterPrivileges <Alt-c> {alterPrivilegesDialog_Cancel; break}
    bind .alterPrivileges.okButton <Return> {alterPrivilegesDialog_OK; break}
    bind .alterPrivileges.applyButton <Return> {alterPrivilegesDialog_Apply; break}
    bind .alterPrivileges.cancelButton <Return> {alterPrivilegesDialog_Cancel; break}
    bind .alterPrivileges <Escape> {alterPrivilegesDialog_Cancel; break}

    pack .alterPrivileges.cancelButton .alterPrivileges.applyButton \
	.alterPrivileges.okButton -side right 

    wm deiconify .alterPrivileges
}

proc alterPrivilegesDialog_OK {} {

    # Disable the buttons until the operation has finished

    .alterPrivileges.applyButton configure -state disabled
    .alterPrivileges.okButton configure -state disabled
    .alterPrivileges.cancelButton configure -state disabled

    blt::busy hold .alterPrivileges.hostedDialog.alterPrivilegesDialog
    wm protocol .alterPrivileges WM_DELETE_WINDOW {#}
    
    # Start the busy indicator

    status loadNotify 1

    # Now try and execute the action (apply the form)

    if {[catch {set errorText [.alterPrivileges.hostedDialog.alterPrivilegesDialog apply]} errorText2]} {

	# Lower the busy indicator

	status loadNotify 0

	tk_messageBox -icon error -title "Error" \
	    -message "An error occurred while processing this directive:\n$errorText2\nThe operation was aborted."
	catch {.alterPrivileges.applyButton configure -state normal}
	catch {.alterPrivileges.okButton configure -state normal}
	catch {.alterPrivileges.cancelButton configure -state normal}
	catch {blt::busy release .alterPrivileges.hostedDialog.alterPrivilegesDialog}
	catch {wm protocol .alterPrivileges WM_DELETE_WINDOW { destroy .alterPrivileges }}
	return
    }

    # Lower the busy indicator

    status loadNotify 0

    # Check if everything went cleanly

    if {$errorText != "" } {

	# No, so display error message

	catch {tk_messageBox -icon error -parent .alterPrivileges -title \
	    "Error" -message "The backend returned the error:\n $errorText"}

	# Re-enable the buttons

	catch {.alterPrivileges.applyButton configure -state normal}
	catch {.alterPrivileges.okButton configure -state normal}
	catch {.alterPrivileges.cancelButton configure -state normal}
	catch {blt::busy release .alterPrivileges.hostedDialog.alterPrivilegesDialog}
	catch {wm protocol .alterPrivileges WM_DELETE_WINDOW { destroy .alterPrivileges }}

    } else {

	# Yes, so lower the dialog (just use the cancel procedure)

	alterPrivilegesDialog_Cancel
    }
    
}

proc alterPrivilegesDialog_Apply {} {

    # Disable the buttons until the operation has finished

    .alterPrivileges.applyButton configure -state disabled
    .alterPrivileges.okButton configure -state disabled
    .alterPrivileges.cancelButton configure -state disabled

    blt::busy hold .alterPrivileges.hostedDialog.alterPrivilegesDialog
    wm protocol .alterPrivileges WM_DELETE_WINDOW {#}

    # Start the busy indicator

    status loadNotify 1

    set changed [.alterPrivileges.hostedDialog.alterPrivilegesDialog checkForChanges]

    if {[catch {set errorText [.alterPrivileges.hostedDialog.alterPrivilegesDialog apply]} errorText2]} {

	# Lower the busy indicator

	status loadNotify 0

	tk_messageBox -icon error -title "Error" \
	    -message "An error occurred while processing this directive:\n$errorText2\nThe current operation was aborted"
	catch {.alterPrivileges.applyButton configure -state normal}
	catch {.alterPrivileges.okButton configure -state normal}
	catch {.alterPrivileges.cancelButton configure -state normal}
	catch {blt::busy release .alterPrivileges.hostedDialog.alterPrivilegesDialog}
	catch {wm protocol .alterPrivileges WM_DELETE_WINDOW { destroy .alterPrivileges }}
	return
    }

    # Lower the busy indicator

    status loadNotify 0

    # Check if everything went cleanly

    if {$errorText != "" } {

	# No, so display error message

	catch {tk_messageBox -icon error -parent .alterPrivileges -title "Error" -message "$errorText"}

	# Re-enable the buttons

	catch {.alterPrivileges.applyButton configure -state normal}
	catch {.alterPrivileges.okButton configure -state normal}
	catch {.alterPrivileges.cancelButton configure -state normal}
	catch {blt::busy release .alterPrivileges.hostedDialog.alterPrivilegesDialog}
	catch {wm protocol .alterPrivileges WM_DELETE_WINDOW { destroy .alterPrivileges }}

	return
    } elseif { $changed } {
	catch {.alterPrivileges.hostedDialog.alterPrivilegesDialog clearAllSelections}
	catch {tk_messageBox -icon info -parent .alterPrivileges -title "Success" -message "Operation performed successfully"}
    }

    # Re-enable the OK and Apply buttons

    catch {.alterPrivileges.applyButton configure -state normal}
    catch {.alterPrivileges.okButton configure -state normal}
    catch {.alterPrivileges.cancelButton configure -state normal}
    catch {blt::busy release .alterPrivileges.hostedDialog.alterPrivilegesDialog}
    catch {wm protocol .alterPrivileges WM_DELETE_WINDOW { destroy .alterPrivileges }}
}

proc alterPrivilegesDialog_Cancel {} {

    catch {wm protocol .alterPrivileges WM_DELETE_WINDOW { destroy .alterPrivileges }}

    .alterPrivileges.hostedDialog.alterPrivilegesDialog resetPrivileges

    destroy .alterPrivileges

}

# End of file
