#!/bin/sh
# \
exec wish "$0" "$@"

# Copyright (c) 2002 Red Hat, Inc. All rights reserved.
#
# This software may be freely redistributed under the terms of the
# GNU General Public License.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Red Hat Database Administration GUI Tool
# Main program body
#
# Written for Red Hat Inc. by Neil Padgett <npadgett@redhat.com>

lappend auto_path classes/backend
lappend auto_path classes/widgets
lappend auto_path classes/utility
lappend auto_path classes/dialogs
lappend auto_path lib

# Source the pgtcl file (safer than auto load file in /usr/lib)

package ifneeded Pgtcl 1.3 [list load [file join /usr/lib libpgtcl.so]]

package require Tk
package require Itcl
package require Itk

package require versionInfo
package require bugHandler

package require clusterCollection
package require clusterHierbox
package require megaView
package require Iwidgets
package require popUpHandler
package require refreshDispatcher
package require splash
package require menuProcs
package require mainMisc
package require hyperlinkDispatcher
package require hyperlinkWatcher
package require navigationToolbar
package require statusBar
package require statusNotifier
package require SQLLogWindow
package require lockfile
package require widgetBusyWatcher
package require preferences
package require stopClearinghouse

global applicationName
global splashScreen
global configDone 

# Sets the maximum length of an identifier to NAMEDATALEN - 1

global MAXDATALEN 
set MAXDATALEN 31

set configDone 0

option add *Font "Helvetica 11 normal" userDefault
image create photo splashScreen -file "img/Splash.gif"

displaySplash splashScreen

wm withdraw .
wm title . "$applicationName"
wm iconname . "$applicationName"
wm iconbitmap . @img/rhdb-admin.xbm
wm iconmask . @img/rhdb-admin_mask.xbm

# Create the SQL logger

createSQLLogWindow
hideSQLLogWindow

# Create the dispatchers

RefreshDispatcher refresher
HyperlinkDispatcher hyperlinker
HyperlinkWatcher hyperlinkWatcher -hyperlinkDispatcher hyperlinker -refreshDispatcher refresher

# Now, load the cluster collections settings

ClusterCollection x -refreshDispatcher refresher

# Wait for the splash screen to go away

catch {tkwait window .placard}

readClusterSettings x

# Use the wm protocol command to bind the cleanup handler to 
# main window close

wm protocol . WM_DELETE_WINDOW {cleanUp}

#bind . <Destroy> {if {"%W" == "."} {cleanUp}}

# Global used to pass along clusterCollectionName

set clusterCollectionName x

getMenuBar .mb

StatusNotifier status

StopClearinghouse stopClearinghouse -statusNotifier status

StatusBar .sb

NavigationToolbar .tb -hyperlinkWatcher hyperlinkWatcher\
	-hyperlinkDispatcher hyperlinker \
	-statusNotifier status \
        -stopClearinghouseName stopClearinghouse

iwidgets::panedwindow .pw -orient vertical

.pw add left
.pw add right

set leftcs [.pw childsite left]
set rightcs [.pw childsite right]

MegaView $rightcs.megaView  -hyperlinkDispatcher hyperlinker \
	-clusterCollectionName x \
	-statusNotifier status \
        -showSystemObjects 1 \
        -statusBarName .sb \
        -stopClearinghouseName stopClearinghouse
ClusterHierbox $leftcs.box -clusterCollectionName x \
	-viewInfoTarget $rightcs.megaView \
	-popUpTarget popUpHandler \
	-refreshDispatcher refresher \
	-hyperlinkDispatcher hyperlinker \
        -statusNotifier status \
        -showSystemObjects 1 \
        -statusBarName .sb \
        -stopClearinghouseName stopClearinghouse

# Create the busy watcher

WidgetBusyWatcher busyWatch -statusNotifier status

# Global needed to pass status bar name to the connection pool

set statusBarName .sb

pack $leftcs.box -fill both -expand y
pack $rightcs.megaView -fill both -expand y
.pw fraction 40 60

pack .mb -fill x -side top
pack .tb -fill x -side top
pack .pw -expand 1 -fill both
pack .sb -fill x -side top

# Start up with the user's preferences from the configuration
# file

readPreferences

# The following focus shift is a workaround for tkTable and embedded views

bind . <Button-1> {

    # If the window focus was to be granted to a generated window, just give it
    # to the megaView instead (format of %W =
    # .pw.pane1.childsite.megaView.generatedUniqueName##.<more here>) - we only
    # want the first 4 elements in the window to which we give the focus

    if { [string first "generated" %W] != -1 } {
	set location "[join [lrange [split %W "."] 0 3] "."]"
	focus $location

    # Otherwise, give it to the window itself

    } else {
	focus %W
    }
}

# Unhide the main window

wm deiconify .

# End of file
