#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
# --------------------------------------------------------------------
# run tests on scalar problems
# --------------------------------------------------------------------
TMPDIR=${TMPDIR-"/tmp"}
BINGEO=${BINGEO-"../../nfem/bin"}
BINFEM=${BINFEM-"../../nfem/bin"}
SRCDIR=${SRCDIR-"../../../rheolef/doc/usrman"}

RHEOLEF_BASIS_PATH=${RHEOLEF_BASIS_PATH-"../../nfem/basis"}
RHEOLEF_NUMBERING_PATH=${RHEOLEF_NUMBERING_PATH-"../../nfem/basis"}
RHEOLEF_FORM_ELEMENT_PATH=${RHEOLEF_FORM_ELEMENT_PATH-"../../nfem/form_element"}
export RHEOLEF_BASIS_PATH
export RHEOLEF_NUMBERING_PATH
export RHEOLEF_FORM_ELEMENT_PATH

status=0

command="${BINGEO}/mkgeo_grid_2d 17 17 -a -1 -b 1 -c -1 -d 1 -boundary > square.geo"
echo "      $command"
eval $command 2>/dev/null
if test $? -ne 0; then echo "        => *NO*"; exit 1; fi

progs="p-laplacian-fixed-point p-laplacian-newton p-laplacian-damped-newton"
approxs="P1 P2"
pvalues="1.5 2.5"
for prog in $progs; do
  for approx in $approxs; do
    for p in $pvalues; do
      if test $p = "1.5" && test $approx = "P2"; then
        continue
      fi
      command="./$prog square $approx $p 2>/dev/null | ./p-laplacian-post - -check"
      echo "      $command"
      eval "      $command 2>/dev/null"
      if test $? -ne 0; then status=1; echo "        => *NO*"; continue; fi
    done
  done
done

# --------------------------------------------------------------------
# clean
# --------------------------------------------------------------------
command="/bin/rm -f square.geo"
echo "      $command"
eval        $command

exit $status

