#ifndef _RHEO_FORM_MANIP_H
#define _RHEO_FORM_MANIP_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/form.h"
namespace rheolef { 

/*Class:form_manip
NAME: @code{form_manip} - form concatenation on a product space
DESCRIPTION:
  build a form on a product space
TO DO: a general implementation without switch and with a loop.
SEE ALSO: "space"(3), "form"(3), "form_diag_manip"(3)
AUTHOR: 
  LMC-IMAG, 38041 Grenoble cedex 9, France
  | Nicolas.Roquet@imag.fr
  | Pierre.Saramito@imag.fr
DATE:   15 sept 1997
METHODS: @form_manip
End:
*/

//<form_manip:  
class form_manip {
public:
// typedefs:

    typedef form::size_type size_type;

// constructors/destructor:

    form_manip();

// accessors:

    size_type nform() const;
    size_type nrowbloc() const;
    size_type ncolbloc() const;
    form& bloc(size_type i, size_type j);
    const form& bloc(size_type i, size_type j) const;

// manipulators:
  
    form_manip& operator << (const form&);
    form_manip& operator >> (form&);
    form_manip& operator << (form_manip& (*)(form_manip&));

    friend form_manip& verbose (form_manip&);
    friend form_manip& noverbose (form_manip&);
  
// implementation:
   
    friend class size;
    friend form_manip& operator << (form_manip&, const class size&);

protected:
    bool         _verbose;
    size_type    _nform;
    size_type    _nrowbloc;
    size_type    _ncolbloc;
    std::vector<form> _a;
};
//>form_manip:

class size
{
public:
    typedef form_manip::size_type size_type;
    size(size_type nrowbloc, size_type ncolbloc);
    friend form_manip& operator << (form_manip &fm, const size& s);
protected:
    size_type _nrowbloc;
    size_type _ncolbloc;
};
}// namespace rheolef
#endif // _RHEO_FORM_MANIP_H
