///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
# include "rheolef/geo-connectivity.h"
# include "rheolef/geo.h"
using namespace rheolef;
using namespace std;
namespace rheolef {
// ============================================================================
//  connectivity manipulations
// ============================================================================

void
build_connectivity (georep& g)
{
    typedef georep::size_type size_type;

    size_type map_d = g.map_dimension();
    if (map_d <= 1) {
        return;
    }
    vector<set<size_type> > ball (g.n_node());
    build_point_to_element_sets (g.begin(), g.end(), ball.begin());
    if (map_d >= 2) {
        size_type nedge = build_subgeo_numbering (g.begin(), g.end(), ball.begin(), 1,
		g._count_geo, g._count_element);
    }
    if (map_d >= 3) {
        size_type nface = build_subgeo_numbering (g.begin(), g.end(), ball.begin(), 2, 
		g._count_geo, g._count_element);
    }
    for (georep::domlist_type::iterator i = g._domlist.begin(); i != g._domlist.end(); i++) {
	propagate_subgeo_numbering ((*i).begin(), (*i).end(), g.begin(), ball.begin());
    }
}
void
build_edge (const geo& omega, vector<pair<size_t,size_t> >& edge) {
  vector<bool> done (omega.n_edge(), false);
  edge.resize (omega.n_edge());
  for (size_t iK = 0; iK < omega.size(); iK++) {
    const geo_element& K = omega.element(iK);
    for (size_t i = 0; i < K.n_edge(); i++) {
      size_t iE = K.edge(i);
      if (done[iE]) continue;
      edge[iE].first  = K.subgeo_vertex (1, i, 0);
      edge[iE].second = K.subgeo_vertex (1, i, 1);
    }
  }
}
void
build_edge (const geo& omega, vector<geo_element>& edge) {
  vector<bool> done (omega.n_edge(), false);
  edge.resize (omega.n_edge());
  for (geo::const_iterator p = omega.begin(); p != omega.end(); p++) {
    const geo_element& K = *p;
    for (size_t i = 0; i < K.n_edge(); i++) {
      size_t E_idx = K.edge(i);
      if (done[E_idx]) continue;
      edge[E_idx].set_type (reference_element::e);
      edge[E_idx].set_index (E_idx);
      edge[E_idx][0] = K.subgeo_vertex (1, i, 0);
      edge[E_idx][1] = K.subgeo_vertex (1, i, 1);
    }
  }
}
} // namespace rheolef
