///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
#include "rheolef/field.h"

namespace rheolef {

template <class T>
field_basic<T>::field_basic (
	const space& V,
	const Float& init_value)
 : _V (V), 
   _u (),
   _b ()
{
   _u.resize (_V.iu_ownership(), init_value);
   _b.resize (_V.ib_ownership(), init_value);
}
template <class T>
oparstream& 
field_basic<T>::put (oparstream& ops) const
{
    using namespace std;
    // merge distributed blocked and non-blocked onto proc=0
    communicator_type comm = _V.comm();
    size_type io_proc = oparstream::io_proc();
    size_type my_proc = comm.rank();
    distributor io_ownership (_V.par_size(), comm, (my_proc == io_proc ? _V.par_size() : 0)); 
    vec<T> u_io (io_ownership, std::numeric_limits<T>::max());
    for (size_type idof = 0, n_dof = _V.size(); idof < n_dof; idof++) {
        T value = operator[] (idof);
        size_type par_old_idof = _V.idof2par_old_idof (idof);
        u_io.set (par_old_idof, value);
        trace_macro ("idof="<<idof<<", par_old_idof="<<par_old_idof<<", value="<<value);
    }
    u_io.assembly();  

    // then output
    ops << "field" << endl
        << "1 " << u_io.par_size() << endl 
        << _V.get_geo().name() << endl
        << "P1" << endl
        << endl
        << u_io;
    return ops;
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
template class field_basic<Float>;
template oparstream& operator << (oparstream& s, const field_basic<Float>& x);

} // namespace rheolef
