#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"../../../rheolef/nfem/tst"}

RHEOLEF_BASIS_PATH=${RHEOLEF_BASIS_PATH-"../basis"}
RHEOLEF_NUMBERING_PATH=${RHEOLEF_NUMBERING_PATH-"../basis"}
RHEOLEF_FORM_ELEMENT_PATH=${RHEOLEF_FORM_ELEMENT_PATH-"../form_element"}
export RHEOLEF_BASIS_PATH
export RHEOLEF_NUMBERING_PATH
export RHEOLEF_FORM_ELEMENT_PATH

# with Omega = ]-.5,.5[^2

status=0

command="../bin/mkgeo_grid_2d 10 10 -boundary -a -0.5 -b 0.5 -c -0.5 -d 0.5 > square.geo"
echo "      $command"
eval $command 2>/dev/null

command="./dunsinane_tst square.geo -slope 1e-2 -nu 1e-3 -tabata -iter_tabata"
echo "      $command"
eval $command 2>/dev/null | diff $SRCDIR/dunsinane_tst.out.valid -
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

/bin/rm -f square.geo synopsis.txt
exit ${status}

