#ifndef _SKIT_BLAS1_MIXT_H
#define _SKIT_BLAS1_MIXT_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// blas 1 
// sparse vectors / dense vector
// expressions without template expression
//
// author: Pierre.Saramito@imag.fr
//
// date: 11 march 1997
//
// NOTE: use #define's for size code reduction
//
# include "rheolef/vec.h"
# include "rheolef/csr.h"
# include "rheolef/avec.h"
# include "rheolef/blas-algorithm.h"

#ifdef _RHEOLEF_HAVE_EXPRESSION_TEMPLATE
#include "rheolef/blas1-mixt-tmpl.h"
#else
#include "rheolef/blas1-mixt-no-tmpl.h"
#endif

#ifdef TODO
// ===========================[ DOT PRODUCT ]====================================
#define dot_product(Svec, Vec)							\
template<class T2>								\
inline 										\
skit_promote(typename Svec::element_type,T2)					\
dot(const Svec& x, const Vec<T2>& y)						\
{										\
    check_length(x,y);								\
    typedef skit_promote(typename Svec::element_type,T2)			\
	    element_type;							\
    return sxdoty(x.begin(), x.end(), y.begin(), element_type());		\
}										\
template<class T1>								\
inline 										\
skit_promote(T1,typename Svec::element_type)					\
dot(const Vec<T1>& x, const Svec& y)						\
{										\
    check_length(y,x);								\
    typedef skit_promote(T1,typename Svec::element_type)			\
	    element_type;							\
    return sxdoty(y.begin(), y.end(), x.begin(), element_type());		\
}
// ------------------------------------------------------------------------------

dot_product(avec<Float>, vec)
#endif // TODO

#endif // _SKIT_BLAS1_MIXT_H
