///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// test d'un brouillon de tableau polymorphe 
//
// pb avec ptr_vector & heap_allocator (ou bien boost::object_pool)
// ----------------------------------------------------------------
// http://www.cplusplus.com/forum/general/12508/
// kfmfe04 (257)   	Link to this post Jul 10, 2009 at 12:52am
// 
// If I use a plain new to allocate, boost::ptr_vector seems like the best bet.
// But in this special case, I am allocating a lot of elements, so I need to use boost::object_pool.
// 
// If boost::ptr_vector also owns its items (ie deletes them on destruct), I probably have to use one or the other (either ptr_vector or object_pool, but not both).
// 
// If I am mistaken, please let me know. Thx.
//
#include "rheolef/polymorphic_array.h"
#include <boost/ptr_container/ptr_vector.hpp>
//#include "rheolef/stack_allocator.h"
#include "rheolef/heap_allocator.h"

#include "rheolef/polymorphic_array.h"
#include "geo_element_tst.h"

//#include <boost/pool/pool_alloc.hpp>
//#include <boost/pool/object_pool.hpp>
//#include <boost/pool/pool.hpp>

#include <deque>

using namespace rheolef;
using namespace std;

int main(int argc, char**argv) {
    warning_macro ("main[1]");
    environment parallel(argc, argv);
    warning_macro ("main[2]");
    string head;
    size_t n;
    cin >> head >> n;
    warning_macro ("n="<<n);
    {//block
        typedef polymorphic_data_vector<geo_element, mpl::vector<rheolef::geo_element_t,rheolef::geo_element_q>, 2> pool_type;
	typedef geo_element::get<pool_type>  pool_get_type;
        pool_type pool;
        pool_get_type get_element;
	{//block
	    warning_macro ("entering block...");
	    boost::ptr_vector<geo_element> elts;
	    warning_macro ("elts.size="<<elts.size());
	    warning_macro ("elts.capacity="<<elts.capacity());
	    for (size_t i = 0; i < n; i++) {
	        warning_macro ("get...");
	        geo_element* ptr = get_element(cin, pool);
	        warning_macro ("get done: "<<*ptr);
	        warning_macro ("push_back...");
	        elts.push_back (ptr);
	        warning_macro ("push_back done");
	    }
	    cout << "geo " << elts.size() << endl;
	    for (size_t i = 0; i < elts.size(); i++) {
	       cout << elts[i] << endl;
	    }
	    warning_macro ("elts.size="<<elts.size());
	    warning_macro ("elts.capacity="<<elts.capacity());
#ifdef TODO
	    warning_macro ("cleanning pool...");
            pool_t.clear();
            pool_q.clear();
	    warning_macro ("clearing pool done");
#endif // TODO
	    warning_macro ("cleanning ptr_vector...");
	    elts.clear(); // le dstor de vector_ptr appelle les dstors des elements pointes...?
	    warning_macro ("clearing ptr_vector done");
	    warning_macro ("quitting block...");
	}//end block
	warning_macro ("quitting block done");
    }
}
