#ifndef _RHEO_UBLAS_MATRIX_RANGE_H
#define _RHEO_UBLAS_MATRIX_RANGE_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

// small utility :
//    m(range(i1,j1), range(i2,j2)p := m_expr
//
// voir : http://www.boost.org/libs/numeric/ublas/doc/matrix_proxy.htm#matrix_range
//
#include <boost/numeric/ublas/matrix_proxy.hpp>

namespace rheolef { 
template <class Range1, class Range2>
static
inline
void
mr_set (ublas::matrix<Float>& m, Range1 r1, Range2 r2, const ublas::matrix<Float>& m_expr) 
{
    ublas::matrix_range<ublas::matrix<Float> > mr (m, r1, r2);
    mr = m_expr;
}
}// namespace rheolef
#endif // _RHEO_UBLAS_MATRIX_RANGE_H
