#include "rheolef.h"
using namespace rheolef;
using namespace std;
size_t N;
Float f (const point& x) { return 1.0*N*sin(x[0]+x[1]+x[2]); }
Float g (const point& x) { return sin(x[0]+x[1]+x[2]); }
int main(int argc, char**argv) {
  environment distributed(argc, argv);
  geo omega (argv[1]);
  Float prec = (argc > 2) ? atof(argv[2]) : 1e-10;
  N = omega.dimension();
  space Vh (omega, "P1");
  Vh.block ("boundary");
  form a(Vh, Vh, "grad_grad");
  form m(Vh, Vh, "mass");
  field uh (Vh);
  field fh = interpolate(Vh, f);
  space Wh (omega["boundary"], "P1");
  uh["boundary"] = interpolate(Wh, g);
  solver sa (a.uu);
  uh.u = sa.solve (m.uu*fh.u + m.ub*fh.b - a.ub*uh.b);
  dcout << uh;
}
