#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "neumann-laplace-assembly.h"
size_t N;
Float f (const point& x) { return 1; }
Float g (const point& x) { return -0.5/N; }
int main(int argc, char**argv) {
  environment distributed (argc, argv);
  geo omega (argv[1]);
  N = omega.dimension();
  space Xh (omega, argv[2]);
  form m (Xh, Xh, "mass");
  form a (Xh, Xh, "grad_grad");
  field b = m*field(Xh,1.0);
  field fh = interpolate(Xh, f);
  space Wh (omega["boundary"], argv[2]);
  field gh = interpolate(Wh, g);
  form mb (Wh, Xh, "mass");
  field mfh = m*fh + mb*gh;
  distributor ext_ownership = mfh.u.ownership();
  communicator comm = ext_ownership.comm();
  size_t   my_proc = comm.rank();
  size_t last_proc = comm.size() - 1;
  ext_ownership [last_proc+1]++;
  csr<Float> A = neumann_laplace_assembly (ext_ownership, a.uu, b.u);
  solver sa (A);
  vec<Float> B (ext_ownership);
  for (size_t i = 0; i < mfh.u.size(); i++) B[i] = mfh.u[i];
  if (my_proc == last_proc) B [B.size()-1] = 0;
  vec<Float> U (ext_ownership);
  U = sa.solve (B);
  warning_macro ("retour de solve");
  field uh(Xh);
  warning_macro ("coucou {1}");
  for (size_t i = 0; i < uh.u.size(); i++) uh.u[i] = U[i];
  warning_macro ("coucou {2}");
  Float lambda = (my_proc == last_proc) ? U [U.size()-1] : 0;
  warning_macro ("coucou {3}");
#ifdef _RHEOLEF_HAVE_MPI
  mpi::broadcast (comm, lambda, last_proc); 
#endif // _RHEOLEF_HAVE_MPI
  warning_macro ("coucou {4}");
  dcout << uh 
        << "lambda" << lambda << endl;
  warning_macro ("coucou {5}");
}
